/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.EnumSet;
import java.util.List;
import replicatorg.machine.model.AxisId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OnboardParameters {
    public static final int EXTRUDER = 0;
    public static final int BUILD_PLATFORM = 1;

    public List<Integer> toolheadsWithStoredData();

    public EnumSet<AxisId> getInvertedParameters();

    public void setInvertedParameters(EnumSet<AxisId> var1);

    public String getMachineName();

    public void setMachineName(String var1);

    public double getAxisHomeOffset(int var1);

    public void setAxisHomeOffset(int var1, double var2);

    public EndstopType getInvertedEndstops();

    public void setInvertedEndstops(EndstopType var1);

    public boolean hasFeatureOnboardParameters();

    public void createThermistorTable(int var1, double var2, double var4, double var6, int var8);

    public int getR0(int var1, int var2);

    public int getT0(int var1, int var2);

    public int getBeta(int var1, int var2);

    public boolean getCoolingFanEnabled(int var1);

    public int getCoolingFanSetpoint(int var1);

    public void setCoolingFanParameters(boolean var1, int var2, int var3);

    public BackoffParameters getBackoffParameters(int var1);

    public void setBackoffParameters(BackoffParameters var1, int var2);

    public PIDParameters getPIDParameters(int var1, int var2);

    public void setPIDParameters(int var1, PIDParameters var2, int var3);

    public ExtraFeatures getExtraFeatures(int var1);

    public void setExtraFeatures(ExtraFeatures var1, int var2);

    public EstopType getEstopConfig();

    public void setEstopConfig(EstopType var1);

    public void resetToFactory();

    public void resetToolToFactory(int var1);

    public CommunicationStatistics getCommunicationStatistics();

    public static class CommunicationStatistics {
        public int packetCount;
        public int sentPacketCount;
        public int packetFailureCount;
        public int packetRetryCount;
        public int noiseByteCount;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EstopType {
        NOT_PRESENT(0),
        ACTIVE_HIGH(1),
        ACTIVE_LOW(2);

        final byte value;

        private EstopType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EstopType estopTypeForValue(byte value) {
            if (value == EstopType.ACTIVE_HIGH.value) {
                return ACTIVE_HIGH;
            }
            if (value == EstopType.ACTIVE_LOW.value) {
                return ACTIVE_LOW;
            }
            return NOT_PRESENT;
        }
    }

    public static class ExtraFeatures {
        static final int CHA = 0;
        static final int CHB = 1;
        static final int CHC = 2;
        public boolean swapMotorController;
        public int heaterChannel;
        public int hbpChannel;
        public int abpChannel;
    }

    public static class PIDParameters {
        public float p;
        public float i;
        public float d;
    }

    public static class BackoffParameters {
        public int stopMs;
        public int reverseMs;
        public int forwardMs;
        public int triggerMs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EndstopType {
        NOT_PRESENT(0),
        INVERTED(-97),
        NON_INVERTED(-128);

        final byte value;

        private EndstopType(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EndstopType endstopTypeForValue(byte value) {
            if ((value & 0x80) == 0) {
                return NOT_PRESENT;
            }
            return (value & 1) == 0 ? NON_INVERTED : INVERTED;
        }
    }
}

