/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.awt.geom.Rectangle2D;
import javax.vecmath.Point3d;
import replicatorg.drivers.DriverBaseImplementation;
import replicatorg.drivers.RetryException;
import replicatorg.util.Point5d;

public class EstimationDriver
extends DriverBaseImplementation {
    private double buildTime = 0.0;
    private double moveLength = 0.0;
    private Rectangle2D.Double bounds = new Rectangle2D.Double();

    public Rectangle2D.Double getBounds() {
        return this.bounds;
    }

    public void delay(long millis) {
        this.buildTime += (double)millis / 1000.0;
    }

    protected Point5d reconcilePosition() {
        return new Point5d();
    }

    public void queuePoint(Point5d p) throws RetryException {
        Point5d delta = this.getDelta(p);
        this.moveLength = delta.get3D().distance(new Point3d());
        double feedrate = this.getSafeFeedrate(delta);
        double millis = this.moveLength / feedrate * 60000.0;
        this.bounds.add(p.x(), p.y());
        if (millis > 0.0) {
            this.buildTime += millis;
        }
        this.setInternalPosition(p);
    }

    public double getBuildTime() {
        return this.buildTime;
    }

    public static String getBuildTimeString(double tempTime) {
        return EstimationDriver.getBuildTimeString(tempTime, false);
    }

    public static String getBuildTimeString(double tempTime, boolean useSeconds) {
        int seconds;
        int minutes;
        int hours;
        int days;
        String val = new String();
        if (!useSeconds) {
            tempTime += 59999.0;
        }
        if ((days = (int)Math.floor(tempTime / 8.64E7)) > 0) {
            tempTime -= (double)(days * 86400000);
            val = val + days + " day";
            if (days > 1) {
                val = val + "s";
            }
        }
        if ((hours = (int)Math.floor(tempTime / 3600000.0)) > 0) {
            tempTime -= (double)(hours * 3600000);
            if (days > 0) {
                val = val + ", ";
            }
            val = val + hours + " hour";
            if (hours > 1) {
                val = val + "s";
            }
        }
        if ((minutes = (int)Math.floor(tempTime / 60000.0)) > 0) {
            tempTime -= (double)(minutes * 60000);
            if (days > 0 || hours > 0) {
                val = val + ", ";
            }
            val = val + minutes + " minute";
            if (minutes > 1) {
                val = val + "s";
            }
        }
        if (useSeconds && (seconds = (int)Math.floor(tempTime / 1000.0)) > 0) {
            tempTime -= (double)(seconds * 1000);
            if (days > 0 || hours > 0 || minutes > 0) {
                val = val + ", ";
            }
            val = val + seconds + " second";
            if (seconds > 1) {
                val = val + "s";
            }
        }
        return val;
    }
}

