/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.drivers;

import java.util.EnumSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.vecmath.Point3d;
import org.w3c.dom.Node;
import replicatorg.app.Base;
import replicatorg.app.exceptions.BuildFailureException;
import replicatorg.drivers.Driver;
import replicatorg.drivers.DriverError;
import replicatorg.drivers.DriverQueryInterface;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.Version;
import replicatorg.machine.model.AxisId;
import replicatorg.machine.model.MachineModel;
import replicatorg.util.Point5d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverBaseImplementation
implements Driver,
DriverQueryInterface {
    protected MachineModel machine;
    private String firmwareName = "Unknown";
    protected Version version = new Version(0, 0);
    protected Version preferredVersion = new Version(0, 0);
    protected Version minimumVersion = new Version(0, 0);
    private Point3d[] offsets;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    ConcurrentLinkedQueue<DriverError> errorList;
    private double currentFeedrate;
    protected int positioningMode = 0;
    public static int ABSOLUTE = 0;
    public static int INCREMENTAL = 1;
    protected boolean hasEmergencyStop = false;
    protected boolean hasSoftStop = false;
    protected final AtomicReference<Point5d> currentPosition = new AtomicReference<Object>(null);

    public DriverBaseImplementation() {
        this.errorList = new ConcurrentLinkedQueue();
        this.offsets = new Point3d[7];
        for (int i = 0; i < 7; ++i) {
            this.offsets[i] = new Point3d();
        }
        this.machine = new MachineModel();
    }

    @Override
    public void loadXML(Node xml) {
    }

    @Override
    public void updateManualControl() {
    }

    @Override
    public boolean isPassthroughDriver() {
        return false;
    }

    @Override
    public void executeGCodeLine(String code) {
        Base.logger.severe("Ignoring executeGCode command: " + code);
    }

    @Override
    public void dispose() {
        if (Base.logger.isLoggable(Level.FINE)) {
            Base.logger.fine("Disposing of driver " + this.getDriverName());
        }
    }

    @Override
    public void initialize() {
        this.setInitialized(true);
    }

    @Override
    public void uninitialize() {
        this.setInitialized(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInitialized(boolean status) {
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            this.isInitialized.set(status);
            if (!status) {
                this.invalidatePosition();
            }
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized.get();
    }

    @Override
    public void assessState() {
    }

    protected void setError(DriverError newError) {
        this.errorList.add(newError);
    }

    protected void setError(String e) {
        this.setError(new DriverError(e, true));
    }

    @Override
    public boolean hasError() {
        return this.errorList.size() > 0;
    }

    @Override
    public DriverError getError() {
        return (DriverError)this.errorList.remove();
    }

    @Override
    @Deprecated
    public void checkErrors() throws BuildFailureException {
        if (this.errorList.size() > 0) {
            throw new BuildFailureException(this.getError().getMessage());
        }
    }

    @Override
    public boolean isFinished() {
        return true;
    }

    @Override
    public boolean isBufferEmpty() {
        return true;
    }

    @Override
    public String getFirmwareInfo() {
        return this.firmwareName + " v" + this.getVersion();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Version getMinimumVersion() {
        return this.minimumVersion;
    }

    @Override
    public Version getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public Point3d getOffset(int i) {
        return this.offsets[i];
    }

    @Override
    public void setOffsetX(int offsetSystemNum, double j) {
        this.offsets[offsetSystemNum].x = j;
    }

    @Override
    public void setOffsetY(int offsetSystemNum, double j) {
        this.offsets[offsetSystemNum].y = j;
    }

    @Override
    public void setOffsetZ(int offsetSystemNum, double j) {
        this.offsets[offsetSystemNum].z = j;
    }

    @Override
    public void setCurrentPosition(Point5d p) throws RetryException {
        this.currentPosition.set(p);
    }

    @Override
    public void invalidatePosition() {
        this.currentPosition.set(null);
    }

    protected Point5d reconcilePosition() throws RetryException {
        throw new RuntimeException("Position reconcilliation requested, but not implemented for this driver");
    }

    @Override
    public boolean positionLost() {
        return this.currentPosition.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point5d getCurrentPosition(boolean forceUpdate) {
        AtomicReference<Point5d> atomicReference = this.currentPosition;
        synchronized (atomicReference) {
            if (this.positionLost() || forceUpdate) {
                try {
                    Point5d newPoint = this.reconcilePosition();
                    this.currentPosition.set(newPoint);
                }
                catch (RetryException e) {
                    Base.logger.severe("Attempt to reconcile machine position failed, due to Retry Exception");
                }
            }
            if (this.positionLost()) {
                return new Point5d();
            }
            return new Point5d(this.currentPosition.get());
        }
    }

    @Override
    public Point5d getPosition() {
        return this.getCurrentPosition(false);
    }

    @Override
    public void queuePoint(Point5d p) throws RetryException {
        this.setInternalPosition(p);
    }

    protected void setInternalPosition(Point5d position) {
        this.currentPosition.set(position);
    }

    @Override
    public void setFeedrate(double feed) {
        this.currentFeedrate = feed;
    }

    @Override
    public double getCurrentFeedrate() {
        return this.currentFeedrate;
    }

    public double getSafeFeedrate(Point5d delta) {
        double feedrate = this.getCurrentFeedrate();
        Point5d maxFeedrates = this.machine.getMaximumFeedrates();
        if (feedrate == 0.0) {
            for (int i = 0; i < 5; ++i) {
                feedrate = Math.max(feedrate, maxFeedrates.get(i));
            }
            feedrate = Math.max(feedrate, 1.0);
            Base.logger.warning("Zero feedrate detected, reset to: " + feedrate);
        }
        double length = delta.length();
        for (int i = 0; i < 5; ++i) {
            if (delta.get(i) == 0.0 || !(feedrate * delta.get(i) / length > maxFeedrates.get(i))) continue;
            feedrate = maxFeedrates.get(i) * length / delta.get(i);
        }
        return feedrate;
    }

    public Point5d getDelta(Point5d p) {
        Point5d delta = new Point5d();
        Point5d current = this.getCurrentPosition(false);
        delta.sub(p, current);
        delta.absolute();
        return delta;
    }

    @Override
    public void homeAxes(EnumSet<AxisId> axes, boolean positive, double feedrate) throws RetryException {
    }

    @Override
    public MachineModel getMachine() {
        return this.machine;
    }

    @Override
    public void setMachine(MachineModel m) {
        this.machine = m;
    }

    @Override
    public void requestToolChange(int toolIndex, int timeout) throws RetryException {
        this.machine.selectTool(toolIndex);
    }

    @Override
    public void selectTool(int toolIndex) throws RetryException {
        this.machine.selectTool(toolIndex);
    }

    @Override
    public void delay(long millis) throws RetryException {
    }

    @Override
    public void openClamp(int index) {
        this.machine.getClamp(index).open();
    }

    @Override
    public void closeClamp(int index) {
        this.machine.getClamp(index).close();
    }

    @Override
    public void enableDrives() throws RetryException {
        this.machine.enableDrives();
    }

    @Override
    public void disableDrives() throws RetryException {
        this.machine.disableDrives();
    }

    @Override
    public void enableAxes(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public void disableAxes(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public void changeGearRatio(int ratioIndex) {
        this.machine.changeGearRatio(ratioIndex);
    }

    @Override
    public void setMotorDirection(int dir) {
        this.machine.currentTool().setMotorDirection(dir);
    }

    @Override
    public void setMotorRPM(double rpm) throws RetryException {
        this.machine.currentTool().setMotorSpeedRPM(rpm);
    }

    @Override
    public void setMotorSpeedPWM(int pwm) throws RetryException {
        this.machine.currentTool().setMotorSpeedPWM(pwm);
    }

    @Override
    public void enableMotor() throws RetryException {
        this.machine.currentTool().enableMotor();
    }

    @Override
    public void enableMotor(long millis) throws RetryException {
        this.enableMotor();
        this.delay(millis);
        this.disableMotor();
    }

    @Override
    public void disableMotor() throws RetryException {
        this.machine.currentTool().disableMotor();
    }

    @Override
    public double getMotorRPM() {
        return this.machine.currentTool().getMotorSpeedRPM();
    }

    @Override
    public int getMotorSpeedPWM() {
        return this.machine.currentTool().getMotorSpeedReadingPWM();
    }

    public double getMotorSteps() {
        return this.machine.currentTool().getMotorSteps();
    }

    @Override
    public void readToolStatus() {
    }

    @Override
    public int getToolStatus() {
        this.readToolStatus();
        return this.machine.currentTool().getToolStatus();
    }

    @Override
    public void setSpindleDirection(int dir) {
        this.machine.currentTool().setSpindleDirection(dir);
    }

    @Override
    public void setSpindleRPM(double rpm) throws RetryException {
        this.machine.currentTool().setSpindleSpeedRPM(rpm);
    }

    @Override
    public void setSpindleSpeedPWM(int pwm) throws RetryException {
        this.machine.currentTool().setSpindleSpeedPWM(pwm);
    }

    @Override
    public void enableSpindle() throws RetryException {
        this.machine.currentTool().enableSpindle();
    }

    @Override
    public void disableSpindle() throws RetryException {
        this.machine.currentTool().disableSpindle();
    }

    @Override
    public double getSpindleRPM() {
        return this.machine.currentTool().getSpindleSpeedReadingRPM();
    }

    @Override
    public int getSpindleSpeedPWM() {
        return this.machine.currentTool().getSpindleSpeedReadingPWM();
    }

    @Override
    public void setTemperature(double temperature) throws RetryException {
        this.machine.currentTool().setTargetTemperature(temperature);
    }

    @Override
    public void readTemperature() {
    }

    @Override
    public double getTemperature() {
        this.readTemperature();
        return this.machine.currentTool().getCurrentTemperature();
    }

    @Override
    public void setPlatformTemperature(double temperature) throws RetryException {
        this.machine.currentTool().setPlatformTargetTemperature(temperature);
    }

    @Override
    public void readPlatformTemperature() {
    }

    @Override
    public double getPlatformTemperature() {
        this.readPlatformTemperature();
        return this.machine.currentTool().getPlatformCurrentTemperature();
    }

    @Override
    public void enableFloodCoolant() {
        this.machine.currentTool().enableFloodCoolant();
    }

    @Override
    public void disableFloodCoolant() {
        this.machine.currentTool().disableFloodCoolant();
    }

    @Override
    public void enableMistCoolant() {
        this.machine.currentTool().enableMistCoolant();
    }

    @Override
    public void disableMistCoolant() {
        this.machine.currentTool().disableMistCoolant();
    }

    @Override
    public void enableFan() throws RetryException {
        this.machine.currentTool().enableFan();
    }

    @Override
    public void disableFan() throws RetryException {
        this.machine.currentTool().disableFan();
    }

    @Override
    public void setAutomatedBuildPlatformRunning(boolean state) throws RetryException {
        this.machine.currentTool().setAutomatedBuildPlatformRunning(state);
    }

    @Override
    public boolean hasAutomatedBuildPlatform() {
        return this.machine.currentTool().hasAutomatedPlatform();
    }

    @Override
    public void openValve() throws RetryException {
        this.machine.currentTool().openValve();
    }

    @Override
    public void closeValve() throws RetryException {
        this.machine.currentTool().closeValve();
    }

    @Override
    public void openCollet() {
        this.machine.currentTool().openCollet();
    }

    @Override
    public void closeCollet() {
        this.machine.currentTool().closeCollet();
    }

    @Override
    public void pause() {
    }

    @Override
    public void unpause() {
    }

    @Override
    public void stop(boolean abort) {
        Base.logger.info("Machine stop called.");
    }

    @Override
    public void reset() {
        Base.logger.info("Machine reset called.");
    }

    @Override
    public String getDriverName() {
        return null;
    }

    @Override
    public boolean heartbeat() {
        return true;
    }

    @Override
    public double getChamberTemperature() {
        return 0.0;
    }

    @Override
    public void readChamberTemperature() {
    }

    @Override
    public void setChamberTemperature(double temperature) {
    }

    @Override
    public double getPlatformTemperatureSetting() {
        return this.machine.currentTool().getPlatformTargetTemperature();
    }

    @Override
    public double getTemperatureSetting() {
        return this.machine.currentTool().getTargetTemperature();
    }

    @Override
    public void storeHomePositions(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public void recallHomePositions(EnumSet<AxisId> axes) throws RetryException {
    }

    @Override
    public boolean hasSoftStop() {
        return this.hasSoftStop;
    }

    @Override
    public boolean hasEmergencyStop() {
        return this.hasEmergencyStop;
    }

    @Override
    public Point5d getMaximumFeedrates() {
        return this.getMachine().getMaximumFeedrates();
    }
}

