/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui.controlpanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.miginfocom.swing.MigLayout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import replicatorg.app.Base;
import replicatorg.app.ui.CallbackTextField;
import replicatorg.drivers.RetryException;
import replicatorg.drivers.commands.CloseCollet;
import replicatorg.drivers.commands.CloseValve;
import replicatorg.drivers.commands.Delay;
import replicatorg.drivers.commands.DisableFan;
import replicatorg.drivers.commands.DisableFloodCoolant;
import replicatorg.drivers.commands.DisableMistCoolant;
import replicatorg.drivers.commands.DisableMotor;
import replicatorg.drivers.commands.DisableSpindle;
import replicatorg.drivers.commands.DriverCommand;
import replicatorg.drivers.commands.EnableFan;
import replicatorg.drivers.commands.EnableFloodCoolant;
import replicatorg.drivers.commands.EnableMistCoolant;
import replicatorg.drivers.commands.EnableMotor;
import replicatorg.drivers.commands.EnableSpindle;
import replicatorg.drivers.commands.OpenCollet;
import replicatorg.drivers.commands.OpenValve;
import replicatorg.drivers.commands.SetMotorDirection;
import replicatorg.drivers.commands.SetMotorSpeedPWM;
import replicatorg.drivers.commands.SetMotorSpeedRPM;
import replicatorg.drivers.commands.SetPlatformTemperature;
import replicatorg.drivers.commands.SetTemperature;
import replicatorg.drivers.commands.ToggleAutomatedBuildPlatform;
import replicatorg.machine.MachineInterface;
import replicatorg.machine.model.ToolModel;

public class ExtruderPanel
extends JPanel
implements FocusListener,
ActionListener,
ItemListener {
    private ToolModel toolModel;
    private MachineInterface machine;
    protected JFormattedTextField currentTempField;
    protected JFormattedTextField platformCurrentTempField;
    protected double targetTemperature;
    protected double targetPlatformTemperature;
    private static final Color targetColor = Color.BLUE;
    private static final Color measuredColor = Color.RED;
    private static final Color targetPlatformColor = Color.YELLOW;
    private static final Color measuredPlatformColor = Color.WHITE;
    long startMillis = System.currentTimeMillis();
    private TimeTableXYDataset measuredDataset = new TimeTableXYDataset();
    private TimeTableXYDataset targetDataset = new TimeTableXYDataset();
    private TimeTableXYDataset measuredPlatformDataset = new TimeTableXYDataset();
    private TimeTableXYDataset targetPlatformDataset = new TimeTableXYDataset();
    protected Pattern extrudeTimePattern;
    protected String[] extrudeTimeStrings = new String[]{"1s", "2s", "5s", "10s", "30s", "60s", "300s"};
    protected boolean continuousJogMode = false;
    protected long extrudeTime;
    private final String EXTRUDE_TIME_PREF_NAME = "extruderpanel.extrudetime";
    private final Dimension labelMinimumSize = new Dimension(175, 25);

    public ToolModel getTool() {
        return this.toolModel;
    }

    private JLabel makeKeyLabel(String text, Color c) {
        BufferedImage image = new BufferedImage(10, 10, 1);
        Graphics g = image.getGraphics();
        g.setColor(c);
        g.fillRect(0, 0, 10, 10);
        ImageIcon icon = new ImageIcon(image);
        return new JLabel(text, icon, 2);
    }

    public ChartPanel makeChart(ToolModel t) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.measuredDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint(null);
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setLowerMargin(0.0);
        axis.setFixedAutoRange(180000.0);
        TickUnits unitSource = new TickUnits();
        unitSource.add((TickUnit)new NumberTickUnit(60000.0));
        unitSource.add((TickUnit)new NumberTickUnit(1000.0));
        axis.setStandardTickUnits((TickUnitSource)unitSource);
        axis.setTickLabelsVisible(false);
        axis = plot.getRangeAxis();
        axis.setRange(0.0, 300.0);
        XYStepRenderer renderer = new XYStepRenderer();
        plot.setDataset(1, (XYDataset)this.targetDataset);
        plot.setRenderer(1, (XYItemRenderer)renderer);
        plot.getRenderer(1).setSeriesPaint(0, (Paint)targetColor);
        plot.getRenderer(0).setSeriesPaint(0, (Paint)measuredColor);
        if (t.hasHeatedPlatform()) {
            plot.setDataset(2, (XYDataset)this.measuredPlatformDataset);
            plot.setRenderer(2, (XYItemRenderer)new XYLineAndShapeRenderer(true, false));
            plot.getRenderer(2).setSeriesPaint(0, (Paint)measuredPlatformColor);
            plot.setDataset(3, (XYDataset)this.targetPlatformDataset);
            plot.setRenderer(3, (XYItemRenderer)new XYStepRenderer());
            plot.getRenderer(3).setSeriesPaint(0, (Paint)targetPlatformColor);
        }
        plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        ChartPanel chartPanel = new ChartPanel(chart);
        chartPanel.setPreferredSize(new Dimension(400, 160));
        chartPanel.setOpaque(false);
        return chartPanel;
    }

    private JLabel makeLabel(String text) {
        JLabel label = new JLabel();
        label.setText(text);
        label.setMinimumSize(this.labelMinimumSize);
        label.setMaximumSize(this.labelMinimumSize);
        label.setPreferredSize(this.labelMinimumSize);
        label.setHorizontalAlignment(2);
        return label;
    }

    private void setExtrudeTime(String mode) {
        if ("Continuous Jog".equals(mode)) {
            this.continuousJogMode = true;
            this.extrudeTime = 0L;
        } else {
            if (this.continuousJogMode) {
                this.machine.stopMotion();
            }
            this.continuousJogMode = false;
            Matcher jogMatcher = this.extrudeTimePattern.matcher(mode);
            if (jogMatcher.find()) {
                this.extrudeTime = Long.parseLong(jogMatcher.group(1));
            }
        }
        if (mode != null && mode.length() > 0) {
            Base.preferences.put("extruderpanel.extrudetime", mode);
        }
    }

    public ExtruderPanel(MachineInterface machine, ToolModel t) {
        Element xml;
        String enableString;
        JLabel currentTempLabel;
        CallbackTextField targetTempField;
        JLabel targetTempLabel;
        this.machine = machine;
        this.toolModel = t;
        Dimension panelSize = new Dimension(420, 30);
        this.extrudeTimePattern = Pattern.compile("([.0-9]+)");
        this.setLayout((LayoutManager)new MigLayout());
        if (t.hasMotor()) {
            ButtonGroup motorControl;
            AbstractButton motorForwardButton;
            AbstractButton motorStoppedButton;
            AbstractButton motorReverseButton;
            CallbackTextField field;
            JLabel label;
            if (t.getMotorStepperAxis() == null && !t.motorHasEncoder() && !t.motorIsStepper()) {
                label = this.makeLabel("Motor Speed (PWM)");
                field = new CallbackTextField(this, "handleTextField", "motor-speed-pwm", 9, Base.getLocalFormat());
                field.setValue(Integer.toString(machine.getDriverQueryInterface().getMotorSpeedPWM()));
                this.add(label);
                this.add((Component)field, "wrap");
            }
            if (t.motorHasEncoder() || t.motorIsStepper()) {
                label = this.makeLabel("Motor Speed (RPM)");
                field = new CallbackTextField(this, "handleTextField", "motor-speed", 9, Base.getLocalFormat());
                field.setValue(machine.getDriverQueryInterface().getMotorRPM());
                this.add(label);
                this.add((Component)field, "wrap");
                if (this.toolModel.getMotorStepperAxis() != null) {
                    label = this.makeLabel("Extrude duration");
                    JComboBox<String> timeList = new JComboBox<String>(this.extrudeTimeStrings);
                    timeList.setSelectedItem(Base.preferences.get("extruderpanel.extrudetime", "5s"));
                    timeList.setActionCommand("Extrude-duration");
                    timeList.addActionListener(this);
                    this.setExtrudeTime((String)timeList.getSelectedItem());
                    this.add(label);
                    this.add(timeList, "wrap");
                }
            }
            JLabel motorEnabledLabel = this.makeLabel("Motor Control");
            if (t.motorHasEncoder() || t.motorIsStepper() && this.toolModel.getMotorStepperAxis() != null) {
                motorReverseButton = new JButton("reverse");
                motorReverseButton.setActionCommand("reverse");
                motorReverseButton.addActionListener(this);
                motorStoppedButton = new JButton("stop");
                motorStoppedButton.setActionCommand("stop");
                motorStoppedButton.addActionListener(this);
                motorForwardButton = new JButton("forward");
                motorForwardButton.setActionCommand("forward");
                motorForwardButton.addActionListener(this);
                motorControl = new ButtonGroup();
                motorControl.add(motorReverseButton);
                motorControl.add(motorStoppedButton);
                motorControl.add(motorForwardButton);
                this.add((Component)motorEnabledLabel, "split,spanx");
                this.add(motorReverseButton);
                this.add(motorStoppedButton);
                this.add((Component)motorForwardButton, "wrap");
            } else {
                motorReverseButton = new JRadioButton("reverse");
                motorReverseButton.setName("motor-reverse");
                motorReverseButton.setActionCommand("motor-reverse");
                motorReverseButton.addItemListener(this);
                motorStoppedButton = new JRadioButton("stop");
                motorStoppedButton.setName("motor-stop");
                motorStoppedButton.setActionCommand("motor-stop");
                motorStoppedButton.addItemListener(this);
                motorForwardButton = new JRadioButton("forward");
                motorForwardButton.setName("motor-forward");
                motorForwardButton.setActionCommand("motor-forward");
                motorForwardButton.addItemListener(this);
                motorControl = new ButtonGroup();
                motorControl.add(motorReverseButton);
                motorControl.add(motorStoppedButton);
                motorControl.add(motorForwardButton);
                this.add((Component)motorEnabledLabel, "split,spanx");
                this.add(motorReverseButton);
                this.add(motorStoppedButton);
                this.add((Component)motorForwardButton, "wrap");
            }
        }
        if (t.hasHeater()) {
            targetTempLabel = this.makeKeyLabel("Target Temperature (C)", targetColor);
            targetTempField = new CallbackTextField(this, "handleTextField", "target-temp", 9, Base.getLocalFormat());
            this.targetTemperature = machine.getDriverQueryInterface().getTemperatureSetting();
            targetTempField.setValue(this.targetTemperature);
            currentTempLabel = this.makeKeyLabel("Current Temperature (C)", measuredColor);
            this.currentTempField = new JFormattedTextField(Base.getLocalFormat());
            this.currentTempField.setColumns(9);
            this.currentTempField.setEnabled(false);
            this.add(targetTempLabel);
            this.add((Component)targetTempField, "wrap");
            this.add(currentTempLabel);
            this.add((Component)this.currentTempField, "wrap");
        }
        if (t.hasHeatedPlatform()) {
            targetTempLabel = this.makeKeyLabel("Platform Target Temp (C)", targetPlatformColor);
            targetTempField = new CallbackTextField(this, "handleTextField", "platform-target-temp", 9, Base.getLocalFormat());
            this.targetPlatformTemperature = machine.getDriverQueryInterface().getPlatformTemperatureSetting();
            targetTempField.setValue(this.targetPlatformTemperature);
            currentTempLabel = this.makeKeyLabel("Platform Current Temp (C)", measuredPlatformColor);
            this.platformCurrentTempField = new JFormattedTextField(Base.getLocalFormat());
            this.platformCurrentTempField.setColumns(9);
            this.platformCurrentTempField.setEnabled(false);
            this.add(targetTempLabel);
            this.add((Component)targetTempField, "wrap");
            this.add(currentTempLabel);
            this.add((Component)this.platformCurrentTempField, "wrap");
        }
        if (t.hasHeater() || t.hasHeatedPlatform()) {
            this.add((Component)new JLabel("Temperature Chart"), "growx,spanx,wrap");
            this.add((Component)this.makeChart(t), "growx,spanx,wrap");
        }
        if (t.hasFloodCoolant()) {
            JLabel floodCoolantLabel = this.makeLabel("Flood Coolant");
            JCheckBox floodCoolantCheck = new JCheckBox("enable");
            floodCoolantCheck.setName("flood-coolant");
            floodCoolantCheck.addItemListener(this);
            this.add(floodCoolantLabel);
            this.add((Component)floodCoolantCheck, "wrap");
        }
        if (t.hasMistCoolant()) {
            JLabel mistCoolantLabel = this.makeLabel("Mist Coolant");
            JCheckBox mistCoolantCheck = new JCheckBox("enable");
            mistCoolantCheck.setName("mist-coolant");
            mistCoolantCheck.addItemListener(this);
            this.add(mistCoolantLabel);
            this.add((Component)mistCoolantCheck, "wrap");
        }
        if (t.hasFan()) {
            String fanString = "Cooling Fan";
            enableString = "enable";
            xml = this.findMappingNode(t.getXml(), "fan");
            if (xml != null) {
                fanString = xml.getAttribute("name");
                enableString = xml.getAttribute("actuated");
            }
            JLabel fanLabel = this.makeLabel(fanString);
            JCheckBox fanCheck = new JCheckBox(enableString);
            fanCheck.setName("fan-check");
            fanCheck.addItemListener(this);
            this.add(fanLabel);
            this.add((Component)fanCheck, "wrap");
        }
        if (t.hasAutomatedPlatform()) {
            String abpString = "Build platform belt";
            enableString = "enable";
            JLabel abpLabel = this.makeLabel(abpString);
            JCheckBox abpCheck = new JCheckBox(enableString);
            abpCheck.setName("abp-check");
            abpCheck.addItemListener(this);
            this.add(abpLabel);
            this.add((Component)abpCheck, "wrap");
        }
        if (t.hasValve()) {
            String valveString = "Valve";
            enableString = "open";
            xml = this.findMappingNode(t.getXml(), "valve");
            if (xml != null) {
                valveString = xml.getAttribute("name");
                enableString = xml.getAttribute("actuated");
            }
            JLabel valveLabel = this.makeLabel(valveString);
            JCheckBox valveCheck = new JCheckBox(enableString);
            valveCheck.setName("valve-check");
            valveCheck.addItemListener(this);
            this.add(valveLabel);
            this.add((Component)valveCheck, "wrap");
        }
        if (t.hasCollet()) {
            JLabel colletLabel = this.makeLabel("Collet");
            JCheckBox colletCheck = new JCheckBox("open");
            colletCheck.setName("collet-check");
            colletCheck.addItemListener(this);
            JPanel colletPanel = new JPanel();
            colletPanel.setLayout(new BoxLayout(colletPanel, 2));
            colletPanel.setMaximumSize(panelSize);
            colletPanel.setMinimumSize(panelSize);
            colletPanel.setPreferredSize(panelSize);
            this.add(colletLabel);
            this.add((Component)colletCheck, "wrap");
        }
    }

    private Element findMappingNode(Node xml, String portName) {
        NodeList children = xml.getChildNodes();
        for (int j = 0; j < children.getLength(); ++j) {
            Element e;
            Node child = children.item(j);
            if (!child.getNodeName().equals("remap") || !(e = (Element)child).getAttribute("port").equals(portName)) continue;
            return e;
        }
        return null;
    }

    public void updateStatus() {
        double temperature;
        Second second = new Second(new Date(System.currentTimeMillis() - this.startMillis));
        if (this.machine.getModel().currentTool() == this.toolModel && this.toolModel.hasHeater()) {
            temperature = this.machine.getDriverQueryInterface().getTemperature();
            this.updateTemperature(second, temperature);
        }
        if (this.machine.getModel().currentTool() == this.toolModel && this.toolModel.hasHeatedPlatform()) {
            temperature = this.machine.getDriverQueryInterface().getPlatformTemperature();
            this.updatePlatformTemperature(second, temperature);
        }
    }

    public synchronized void updateTemperature(Second second, double temperature) {
        this.currentTempField.setValue(temperature);
        this.measuredDataset.add((TimePeriod)second, temperature, "a");
        this.targetDataset.add((TimePeriod)second, this.targetTemperature, "a");
    }

    public synchronized void updatePlatformTemperature(Second second, double temperature) {
        this.platformCurrentTempField.setValue(temperature);
        this.measuredPlatformDataset.add((TimePeriod)second, temperature, "a");
        this.targetPlatformDataset.add((TimePeriod)second, this.targetPlatformTemperature, "a");
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        JFormattedTextField source = (JFormattedTextField)e.getSource();
        try {
            this.handleChangedTextField(source);
        }
        catch (RetryException e1) {
            Base.logger.severe("Could not execute command; machine busy.");
        }
    }

    private double confirmTemperature(double target, String limitPrefName, double defaultLimit) {
        double limit = Base.preferences.getDouble("temperature.acceptedLimit", defaultLimit);
        if (target > limit) {
            int n = JOptionPane.showConfirmDialog(this, "<html>Setting the temperature to <b>" + Double.toString(target) + "\u00b0C</b> may<br>" + "involve health and/or safety risks or cause damage to your machine!<br>" + "The maximum recommended temperature is <b>" + Double.toString(limit) + "</b>.<br>" + "Do you accept the risk and still want to set this temperature?", "Danger", 0, 2);
            if (n == 0) {
                return target;
            }
            if (n == 1) {
                return Double.MIN_VALUE;
            }
            return Double.MIN_VALUE;
        }
        return target;
    }

    public void handleChangedTextField(JFormattedTextField source) throws RetryException {
        String name = source.getName();
        if (source.getText().length() > 0) {
            double target = ((Number)source.getValue()).doubleValue();
            if (name.equals("target-temp") || name.equals("platform-target-temp")) {
                if (name.equals("target-temp")) {
                    if ((target = this.confirmTemperature(target, "temperature.acceptedLimit", 260.0)) == Double.MIN_VALUE) {
                        return;
                    }
                    this.machine.runCommand(new SetTemperature(target));
                    this.targetTemperature = target;
                } else {
                    if ((target = this.confirmTemperature(target, "temperature.acceptedLimit.bed", 130.0)) == Double.MIN_VALUE) {
                        return;
                    }
                    this.machine.runCommand(new SetPlatformTemperature(target));
                    this.targetPlatformTemperature = target;
                }
                source.setValue(target);
            } else if (name.equals("motor-speed")) {
                this.machine.runCommand(new SetMotorSpeedRPM(target));
            } else if (name.equals("motor-speed-pwm")) {
                this.machine.runCommand(new SetMotorSpeedPWM((int)target));
            } else {
                Base.logger.warning("Unhandled text field: " + name);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Component source = (Component)((Object)e.getItemSelectable());
        String name = source.getName();
        if (e.getStateChange() == 1) {
            if (name.equals("motor-forward")) {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.CLOCKWISE));
                if (this.toolModel.motorHasEncoder() || this.toolModel.motorIsStepper()) {
                    this.machine.runCommand(new SetMotorSpeedRPM(this.machine.getDriver().getMotorRPM()));
                }
                this.machine.runCommand(new EnableMotor());
            } else if (name.equals("motor-reverse")) {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                if (this.toolModel.motorHasEncoder() || this.toolModel.motorIsStepper()) {
                    this.machine.runCommand(new SetMotorSpeedRPM(this.machine.getDriver().getMotorRPM()));
                }
                this.machine.runCommand(new EnableMotor());
            } else if (name.equals("motor-stop")) {
                this.machine.runCommand(new DisableMotor());
            } else if (name.equals("spindle-enabled")) {
                this.machine.runCommand(new EnableSpindle());
            } else if (name.equals("flood-coolant")) {
                this.machine.runCommand(new EnableFloodCoolant());
            } else if (name.equals("mist-coolant")) {
                this.machine.runCommand(new EnableMistCoolant());
            } else if (name.equals("fan-check")) {
                this.machine.runCommand(new EnableFan());
            } else if (name.equals("abp-check")) {
                this.machine.runCommand(new ToggleAutomatedBuildPlatform(true));
                this.machine.runCommand(new EnableFan());
            } else if (name.equals("valve-check")) {
                this.machine.runCommand(new OpenValve());
            } else if (name.equals("collet-check")) {
                this.machine.runCommand(new OpenCollet());
            } else {
                Base.logger.warning("checkbox selected: " + source.getName());
            }
        } else if (name.equals("motor-enabled")) {
            this.machine.runCommand(new DisableMotor());
        } else if (name.equals("spindle-enabled")) {
            this.machine.runCommand(new DisableSpindle());
        } else if (name.equals("flood-coolant")) {
            this.machine.runCommand(new DisableFloodCoolant());
        } else if (name.equals("mist-coolant")) {
            this.machine.runCommand(new DisableMistCoolant());
        } else if (name.equals("fan-check")) {
            this.machine.runCommand(new DisableFan());
        } else if (name.equals("abp-check")) {
            this.machine.runCommand(new ToggleAutomatedBuildPlatform(false));
            this.machine.runCommand(new DisableFan());
        } else if (name.equals("valve-check")) {
            this.machine.runCommand(new CloseValve());
        } else if (name.equals("collet-check")) {
            this.machine.runCommand(new CloseCollet());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String s = e.getActionCommand();
        if (s.equals("handleTextField")) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            try {
                this.handleChangedTextField(source);
            }
            catch (RetryException e1) {
                Base.logger.severe("Could not execute command; machine busy.");
            }
            source.selectAll();
        } else if (s.equals("Extrude-duration")) {
            JComboBox cb = (JComboBox)e.getSource();
            String timeText = (String)cb.getSelectedItem();
            this.setExtrudeTime(timeText);
        }
        if (s.equals("forward")) {
            if (this.toolModel.getMotorStepperAxis() != null) {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.CLOCKWISE));
                if (this.machine.getDriver().getDriverName().equals("RepRap5D")) {
                    this.machine.runCommand(new EnableMotor(this.extrudeTime * 1000L));
                } else {
                    this.machine.runCommand(new EnableMotor());
                    this.machine.runCommand(new Delay(this.extrudeTime * 1000L));
                    this.machine.runCommand(new DisableMotor());
                }
            }
        } else if (s.equals("reverse")) {
            if (this.toolModel.getMotorStepperAxis() != null) {
                this.machine.runCommand(new SetMotorDirection(DriverCommand.AxialDirection.COUNTERCLOCKWISE));
                if (this.machine.getDriver().getDriverName().equals("RepRap5D")) {
                    this.machine.runCommand(new EnableMotor(this.extrudeTime * 1000L));
                } else {
                    this.machine.runCommand(new EnableMotor());
                    this.machine.runCommand(new Delay(this.extrudeTime * 1000L));
                    this.machine.runCommand(new DisableMotor());
                }
            }
        } else if (s.equals("stop")) {
            this.machine.runCommand(new DisableMotor());
            if (this.toolModel.getMotorStepperAxis() != null) {
                this.machine.stopMotion();
            }
        }
    }
}

