/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.drivers.Driver;
import replicatorg.drivers.MultiTool;

public class ToolheadIndexer
extends JDialog {
    static final String instructions = "<html>Set the Toolhead Index of *all attached extruders*.\nIf you have multiple extruder boards attached, this will case an error.\nSee documentaiton at: http://www.makerbot.com/docs/dualstrusion for details. </html>";

    public ToolheadIndexer(Frame parent, final Driver d) {
        super(parent, "Set Toolhead Index", true);
        Container c = this.getContentPane();
        c.setLayout((LayoutManager)new MigLayout("fillx,pack pref pref"));
        c.add((Component)new JLabel(instructions), "wrap,wmax 500px");
        c.add((Component)new JLabel("Tool index:"), "split");
        NumberFormat.getNumberInstance();
        final JFormattedTextField toolIndexField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        toolIndexField.setColumns(4);
        toolIndexField.setValue(new Integer(0));
        c.add(toolIndexField);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ToolheadIndexer.this.setVisible(false);
            }
        });
        JButton indexButton = new JButton("Set Index");
        indexButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                int value = ((Number)toolIndexField.getValue()).intValue();
                Base.logger.info("Setting toolhead index to " + Integer.toString(value));
                ((MultiTool)((Object)d)).setConnectedToolIndex(value);
                ToolheadIndexer.this.setVisible(false);
            }
        });
        c.add(indexButton);
        c.add(cancelButton);
        this.pack();
    }
}

