/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.AdvancedPrefs;
import replicatorg.app.ui.GuiConstants;
import replicatorg.app.ui.MainWindow;
import replicatorg.app.util.PythonUtils;
import replicatorg.app.util.SwingPythonSelector;
import replicatorg.uploader.FirmwareUploader;

public class PreferencesWindow
extends JFrame
implements GuiConstants {
    MainWindow editor;
    JFormattedTextField fontSizeField;
    JTextField firmwareUpdateUrlField;
    JTextField logPathField;

    private void showCurrentSettings() {
        Font editorFont = Base.getFontPref("editor.font", "Monospaced,plain,12");
        this.fontSizeField.setText(String.valueOf(editorFont.getSize()));
        String firmwareUrl = Base.preferences.get("replicatorg.updates.url", "http://firmware.makerbot.com/firmware.xml");
        this.firmwareUpdateUrlField.setText(firmwareUrl);
        String logPath = Base.preferences.get("replicatorg.logpath", "");
        this.logPathField.setText(logPath);
    }

    private JCheckBox addCheckboxForPref(Container c, String text, final String pref, boolean defaultVal) {
        JCheckBox cb = new JCheckBox(text);
        cb.setSelected(Base.preferences.getBoolean(pref, defaultVal));
        c.add((Component)cb, "wrap");
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                Base.preferences.putBoolean(pref, box.isSelected());
            }
        });
        return cb;
    }

    private void addInitialFilePrefs(Container c) {
        String prefName = "replicatorg.initialopenbehavior";
        int defaultBehavior = Base.InitialOpenBehavior.OPEN_LAST.ordinal();
        int ordinal = Base.preferences.getInt("replicatorg.initialopenbehavior", defaultBehavior);
        if (ordinal >= Base.InitialOpenBehavior.values().length) {
            ordinal = defaultBehavior;
        }
        Base.InitialOpenBehavior openBehavior = Base.InitialOpenBehavior.values()[ordinal];
        ButtonGroup bg = new ButtonGroup();
        c.add((Component)new JLabel("On ReplicatorG launch:"), "split");
        class RadioAction
        extends AbstractAction {
            private Base.InitialOpenBehavior behavior;

            public RadioAction(String text, Base.InitialOpenBehavior behavior) {
                super(text);
                this.behavior = behavior;
            }

            public void actionPerformed(ActionEvent e) {
                Base.preferences.putInt("replicatorg.initialopenbehavior", this.behavior.ordinal());
            }
        }
        JRadioButton b = new JRadioButton(new RadioAction("Open last opened or save file", Base.InitialOpenBehavior.OPEN_LAST));
        if (Base.InitialOpenBehavior.OPEN_LAST == openBehavior) {
            b.setSelected(true);
        }
        bg.add(b);
        c.add((Component)b, "split");
        b = new JRadioButton(new RadioAction("Open new file", Base.InitialOpenBehavior.OPEN_NEW));
        if (Base.InitialOpenBehavior.OPEN_NEW == openBehavior) {
            b.setSelected(true);
        }
        bg.add(b);
        c.add((Component)b, "wrap 10px");
    }

    JComboBox makeDebugLevelDropdown() {
        String levelName = Base.preferences.get("replicatorg.debuglevel", Level.INFO.getName());
        Level l = Level.parse(levelName);
        if (l == null) {
            l = Level.INFO;
        }
        Vector<Level> levels = new Vector<Level>();
        levels.add(Level.ALL);
        levels.add(Level.FINEST);
        levels.add(Level.FINER);
        levels.add(Level.FINE);
        levels.add(Level.INFO);
        levels.add(Level.WARNING);
        final DefaultComboBoxModel model = new DefaultComboBoxModel(levels);
        model.setSelectedItem(l);
        JComboBox cb = new JComboBox(model);
        cb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Level level = (Level)model.getSelectedItem();
                Base.preferences.put("replicatorg.debuglevel", level.getName());
                Base.logger.setLevel(level);
            }
        });
        return cb;
    }

    private double confirmTemperature(double target, String limitPrefName, double defaultLimit) {
        double limit = Base.preferences.getDouble("temperature.acceptedLimit", defaultLimit);
        if (target > limit) {
            int n = JOptionPane.showConfirmDialog(this, "<html>Setting the temperature to <b>" + Double.toString(target) + "\u00b0C</b> may<br>" + "involve health and/or safety risks or cause damage to your machine!<br>" + "The maximum recommended temperature is <b>" + Double.toString(limit) + "</b>.<br>" + "Do you accept the risk and still want to set this temperature?", "Danger", 0, 2);
            if (n == 0) {
                return target;
            }
            if (n == 1) {
                return Double.MIN_VALUE;
            }
            return Double.MIN_VALUE;
        }
        return target;
    }

    public PreferencesWindow() {
        super("Preferences");
        JPanel advanced;
        JPanel basic;
        this.setResizable(true);
        BufferedImage icon = Base.getImage("images/icon.gif", this);
        this.setIconImage(icon);
        JTabbedPane basicVSadvanced = new JTabbedPane();
        JPanel content = basic = new JPanel();
        content.setLayout((LayoutManager)new MigLayout("fill"));
        content.add((Component)new JLabel("MainWindow font size: "), "split");
        this.fontSizeField = new JFormattedTextField(Base.getLocalFormat());
        this.fontSizeField.setColumns(4);
        content.add(this.fontSizeField);
        content.add((Component)new JLabel("  (requires restart of ReplicatorG)"), "wrap");
        this.addCheckboxForPref(content, "Monitor temperature during builds", "build.monitor_temp", false);
        this.addCheckboxForPref(content, "Automatically connect to machine at startup", "replicatorg.autoconnect", true);
        this.addCheckboxForPref(content, "Show experimental machine profiles", "machine.showExperimental", false);
        this.addCheckboxForPref(content, "Review GCode for potential toolhead problems before building", "build.safetyChecks", true);
        this.addCheckboxForPref(content, "Break Z motion into seperate moves (normally false)", "replicatorg.parser.breakzmoves", false);
        this.addCheckboxForPref(content, "Show starfield in model preview window", "ui.show_starfield", false);
        this.addCheckboxForPref(content, "Notifications in System tray", "ui.preferSystemTrayNotifications", false);
        this.addCheckboxForPref(content, "Show warning when building from model w/ existing gcode", "build.showRegenCheck", true);
        content = advanced = new JPanel();
        content.setLayout((LayoutManager)new MigLayout("fill"));
        JButton modelColorButton = new JButton("Choose model color");
        modelColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color modelColor = new Color(Base.preferences.getInt("ui.modelColor", -19635));
                if ((modelColor = JColorChooser.showDialog(null, "Choose Model Color", modelColor)) == null) {
                    return;
                }
                Base.preferences.putInt("ui.modelColor", modelColor.getRGB());
                Base.getEditor().refreshPreviewPanel();
            }
        });
        modelColorButton.setVisible(true);
        content.add((Component)modelColorButton, "split");
        JButton backgroundColorButton = new JButton("Choose background color");
        backgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color backgroundColor = new Color(Base.preferences.getInt("ui.backgroundColor", 0));
                if ((backgroundColor = JColorChooser.showDialog(null, "Choose Background Color", backgroundColor)) == null) {
                    return;
                }
                Base.preferences.putInt("ui.backgroundColor", backgroundColor.getRGB());
                Base.getEditor().refreshPreviewPanel();
            }
        });
        backgroundColorButton.setVisible(true);
        content.add((Component)backgroundColorButton, "wrap");
        content.add((Component)new JLabel("Firmware update URL: "), "split");
        this.firmwareUpdateUrlField = new JTextField(34);
        content.add((Component)this.firmwareUpdateUrlField, "growx, wrap");
        JLabel arcResolutionLabel = new JLabel("Arc resolution (in mm): ");
        content.add((Component)arcResolutionLabel, "split");
        double value = Base.preferences.getDouble("replicatorg.parser.curve_segment_mm", 1.0);
        JFormattedTextField arcResolutionField = new JFormattedTextField(Base.getLocalFormat());
        arcResolutionField.setValue(new Double(value));
        content.add(arcResolutionField);
        String arcResolutionHelp = "<html><small><em>The arc resolution is the default segment length that the gcode parser will break arc codes <br>like G2 and G3 into.  Drivers that natively handle arcs will ignore this setting.</em></small></html>";
        arcResolutionField.setToolTipText(arcResolutionHelp);
        arcResolutionLabel.setToolTipText(arcResolutionHelp);
        arcResolutionField.setColumns(10);
        arcResolutionField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "value") {
                    try {
                        Double v = (Double)evt.getNewValue();
                        if (v == null) {
                            return;
                        }
                        Base.preferences.putDouble("replicatorg.parser.curve_segment_mm", v);
                    }
                    catch (ClassCastException cce) {
                        Base.logger.warning("Unexpected value type: " + evt.getNewValue().getClass().toString());
                    }
                }
            }
        });
        JLabel sfTimeoutLabel = new JLabel("Skeinforge timeout: ");
        content.add((Component)sfTimeoutLabel, "split, gap unrelated");
        int value2 = Base.preferences.getInt("replicatorg.skeinforge.timeout", -1);
        JFormattedTextField sfTimeoutField = new JFormattedTextField(Base.getLocalFormat());
        sfTimeoutField.setValue(new Integer(value2));
        content.add((Component)sfTimeoutField, "wrap 10px, growx");
        String sfTimeoutHelp = "<html><small><em>The Skeinforge timeout is the number of seconds that replicatorg will wait while the<br>Skeinforge preferences window is open. If you find that RepG freezes after editing profiles<br>you can set this number greater than -1 (-1 means no timeout).</em></small></html>";
        sfTimeoutField.setToolTipText(sfTimeoutHelp);
        sfTimeoutLabel.setToolTipText(sfTimeoutHelp);
        sfTimeoutField.setColumns(10);
        sfTimeoutField.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "value") {
                    try {
                        Integer v = (Integer)evt.getNewValue();
                        if (v == null) {
                            return;
                        }
                        Base.preferences.putInt("replicatorg.skeinforge.timeout", v);
                    }
                    catch (ClassCastException cce) {
                        Base.logger.warning("Unexpected value type: " + evt.getNewValue().getClass().toString());
                    }
                }
            }
        });
        content.add((Component)new JLabel("Debugging level (default INFO):"), "split");
        content.add((Component)this.makeDebugLevelDropdown(), "wrap");
        final JCheckBox logCb = new JCheckBox("Log to file");
        logCb.setSelected(Base.preferences.getBoolean("replicatorg.useLogFile", false));
        content.add((Component)logCb, "split");
        logCb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Base.preferences.putBoolean("replicatorg.useLogFile", logCb.isSelected());
            }
        });
        final JLabel logPathLabel = new JLabel("Log file name: ");
        content.add((Component)logPathLabel, "split");
        this.logPathField = new JTextField(34);
        content.add((Component)this.logPathField, "growx, wrap 10px");
        this.logPathField.setEnabled(logCb.isSelected());
        logPathLabel.setEnabled(logCb.isSelected());
        logCb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBox box = (JCheckBox)e.getSource();
                PreferencesWindow.this.logPathField.setEnabled(box.isSelected());
                logPathLabel.setEnabled(box.isSelected());
            }
        });
        final JCheckBox preheatCb = new JCheckBox("Preheat builds");
        content.add((Component)preheatCb, "split");
        preheatCb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                Base.preferences.putBoolean("build.doPreheat", preheatCb.isSelected());
            }
        });
        preheatCb.setSelected(Base.preferences.getBoolean("build.doPreheat", false));
        JLabel t0Label = new JLabel("Toolhead0:");
        JLabel t1Label = new JLabel("Toolhead1:");
        JLabel pLabel = new JLabel("Platform:");
        Integer t0Value = Base.preferences.getInt("build.preheatTool0", 75);
        Integer t1Value = Base.preferences.getInt("build.preheatTool1", 75);
        Integer pValue = Base.preferences.getInt("build.preheatPlatform", 75);
        final JFormattedTextField t0Field = new JFormattedTextField(Base.getLocalFormat());
        final JFormattedTextField t1Field = new JFormattedTextField(Base.getLocalFormat());
        final JFormattedTextField pField = new JFormattedTextField(Base.getLocalFormat());
        t0Field.setValue(t0Value);
        t1Field.setValue(t1Value);
        pField.setValue(pValue);
        ActionListener a = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == t0Field) {
                    double target = ((Number)t0Field.getValue()).doubleValue();
                    if ((target = PreferencesWindow.this.confirmTemperature(target, "temperature.acceptedLimit", 200.0)) == Double.MIN_VALUE) {
                        return;
                    }
                    Base.preferences.putInt("build.preheatTool0", (int)target);
                } else if (ae.getSource() == t1Field) {
                    double target = ((Number)t1Field.getValue()).doubleValue();
                    if ((target = PreferencesWindow.this.confirmTemperature(target, "temperature.acceptedLimit", 200.0)) == Double.MIN_VALUE) {
                        return;
                    }
                    Base.preferences.putInt("build.preheatTool1", (int)target);
                } else if (ae.getSource() == pField) {
                    double target = ((Number)pField.getValue()).doubleValue();
                    if ((target = PreferencesWindow.this.confirmTemperature(target, "temperature.acceptedLimit.bed", 90.0)) == Double.MIN_VALUE) {
                        return;
                    }
                    Base.preferences.putInt("build.preheatPlatform", (int)target);
                }
            }
        };
        t0Field.addActionListener(a);
        t1Field.addActionListener(a);
        pField.addActionListener(a);
        content.add((Component)t0Label, "split, gap 20px");
        content.add((Component)t0Field, "split, growx");
        content.add((Component)t1Label, "split, gap unrelated");
        content.add((Component)t1Field, "split, growx");
        content.add((Component)pLabel, "split, gap unrelated");
        content.add((Component)pField, "split, growx, wrap 10px");
        JButton b = new JButton("Select Python interpreter...");
        content.add((Component)b, "spanx,wrap 10px");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SwingPythonSelector sps = new SwingPythonSelector(PreferencesWindow.this);
                String path = sps.selectFreeformPath();
                if (path != null) {
                    PythonUtils.setPythonPath(path);
                }
            }
        });
        this.addInitialFilePrefs(content);
        JButton allPrefs = new JButton("View All Prefs");
        content.add((Component)allPrefs, "split");
        allPrefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedPrefs advancedPrefs = new AdvancedPrefs();
                advancedPrefs.setVisible(true);
            }
        });
        JButton delPrefs = new JButton("Restore all defaults (includes driver choice, etc.)");
        content.add(delPrefs);
        delPrefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Base.resetPreferences();
                PreferencesWindow.this.showCurrentSettings();
            }
        });
        JButton button = new JButton("Close");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesWindow.this.applyFrame();
                PreferencesWindow.this.dispose();
            }
        });
        content.add((Component)button, "tag ok");
        basicVSadvanced.add((Component)basic, "Basic");
        basicVSadvanced.add((Component)advanced, "Advanced");
        this.getContentPane().add(basicVSadvanced);
        this.showCurrentSettings();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                PreferencesWindow.this.dispose();
            }
        });
        ActionListener disposer = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferencesWindow.this.dispose();
            }
        };
        Base.registerWindowCloseKeys(this.getRootPane(), disposer);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
        this.getContentPane().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                KeyStroke wc = MainWindow.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    PreferencesWindow.this.dispose();
                }
            }
        });
    }

    public void applyFrame() {
        String newSizeText = this.fontSizeField.getText();
        try {
            int newSize = Integer.parseInt(newSizeText.trim());
            String fontName = Base.preferences.get("editor.font", "Monospaced,plain,12");
            if (fontName != null) {
                String[] pieces = fontName.split(",");
                pieces[2] = String.valueOf(newSize);
                StringBuffer buf = new StringBuffer();
                for (String piece : pieces) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append(piece);
                }
                Base.preferences.put("editor.font", buf.toString());
            }
        }
        catch (Exception e) {
            Base.logger.warning("ignoring invalid font size " + newSizeText);
        }
        String origUpdateUrl = Base.preferences.get("replicatorg.updates.url", "");
        if (!origUpdateUrl.equals(this.firmwareUpdateUrlField.getText())) {
            FirmwareUploader.invalidateFirmware();
            Base.preferences.put("replicatorg.updates.url", this.firmwareUpdateUrlField.getText());
            FirmwareUploader.checkFirmware();
        }
        String logPath = this.logPathField.getText();
        Base.preferences.put("replicatorg.logpath", logPath);
        Base.setLogFile(logPath);
        this.editor.applyPreferences();
    }

    public void showFrame(MainWindow editor) {
        this.editor = editor;
        this.setVisible(true);
    }
}

