/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.BGPanel;
import replicatorg.drivers.EstimationDriver;
import replicatorg.machine.MachineListener;
import replicatorg.machine.MachineProgressEvent;
import replicatorg.machine.MachineState;
import replicatorg.machine.MachineStateChangeEvent;
import replicatorg.machine.MachineToolStatusEvent;
import replicatorg.machine.model.ToolModel;

public class MachineStatusPanel
extends BGPanel
implements MachineListener {
    private static final long serialVersionUID = -6944931245041870574L;
    protected JLabel mainLabel = new JLabel();
    protected JLabel smallLabel = new JLabel();
    protected JLabel tempLabel = new JLabel();
    protected JLabel machineLabel = new JLabel();
    private boolean isBuilding = false;
    private static final Color BG_ERROR = new Color(255, 128, 96);
    private static final Color BG_READY = new Color(128, 255, 96);
    private static final Color BG_BUILDING = new Color(255, 239, 0);

    MachineStatusPanel() {
        Font statusFont = Base.getFontPref("status.font", "SansSerif,plain,12");
        Font smallFont = statusFont.deriveFont(10.0f);
        this.smallLabel.setFont(smallFont);
        this.tempLabel.setFont(smallFont);
        this.machineLabel.setFont(smallFont);
        this.mainLabel.setFont(statusFont);
        this.mainLabel.setText("Not Connected");
        this.setLayout((LayoutManager)new MigLayout("fill,novisualpadding, ins 5 10 5 10"));
        this.add((Component)this.mainLabel, "top, left, growx, split");
        this.add((Component)this.machineLabel, "top, right, wrap");
        this.add((Component)this.smallLabel, "bottom, left, growx, split");
        this.add((Component)this.tempLabel, "bottom, right");
        FontMetrics smallMetrics = this.getFontMetrics(smallFont);
        FontMetrics bigMetrics = this.getFontMetrics(statusFont);
        int height = (smallMetrics.getAscent() + smallMetrics.getDescent()) * 2 + bigMetrics.getAscent() + smallMetrics.getDescent();
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
        this.setMinimumSize(new Dimension(0, height));
        int prefWidth = 80 * smallMetrics.charWidth('n');
        this.setPreferredSize(new Dimension(prefWidth, height));
        this.setBackground(BG_ERROR);
    }

    private void updatePanel(Color panelColor, String text, String smallText, String machineText) {
        this.setBackground(panelColor);
        this.mainLabel.setText(text);
        this.smallLabel.setText(smallText);
        this.machineLabel.setText(machineText);
    }

    private String machineStatusString(String machineId, boolean connected) {
        String machineText = Base.preferences.get("machine.name", machineId);
        if (connected) {
            String connection = Base.preferences.get("serial.last_selected", "Unknown Connection");
            machineText = machineText + " on " + connection;
        } else {
            machineText = machineText + " Not Connected";
        }
        return machineText;
    }

    public void updateMachineStatus(MachineStateChangeEvent evt) {
        MachineState.State state = evt.getState().getState();
        Color bgColor = null;
        switch (state) {
            case READY: {
                bgColor = BG_READY;
                break;
            }
            case BUILDING: 
            case BUILDING_OFFLINE: 
            case PAUSED: {
                bgColor = BG_BUILDING;
                break;
            }
            default: {
                bgColor = BG_ERROR;
            }
        }
        String text = evt.getMessage();
        if (text == null) {
            text = state.toString();
        }
        String machineText = this.machineStatusString(evt.getSource().getMachineName(), evt.getState().isConnected());
        if (!evt.getState().isConnected()) {
            this.tempLabel.setText("");
        }
        if (evt.getState().isBuilding() && !Base.preferences.getBoolean("build.monitor_temp", false)) {
            this.tempLabel.setText("Monitor build temp.: off");
        }
        switch (state) {
            case BUILDING: 
            case BUILDING_OFFLINE: 
            case PAUSED: {
                this.isBuilding = true;
                break;
            }
            default: {
                this.isBuilding = false;
            }
        }
        this.updatePanel(bgColor, text, null, machineText);
    }

    public void updateBuildStatus(MachineProgressEvent event) {
        if (this.isBuilding) {
            double proportion = (double)event.getLines() / (double)event.getTotalLines();
            double percentComplete = (double)Math.round(proportion * 10000.0) / 100.0;
            double remaining = event.getEstimated() * (1.0 - proportion);
            if (event.getTotalLines() == 0) {
                remaining = 0.0;
            }
            String s = String.format("Commands:  %1$7d / %2$7d  (%3$3.2f%%)   |   Elapsed:  %4$s  |  Estimated Remaining:  %5$s", event.getLines(), event.getTotalLines(), percentComplete, EstimationDriver.getBuildTimeString(event.getElapsed(), true), EstimationDriver.getBuildTimeString(remaining, true));
            this.smallLabel.setText(s);
        }
    }

    public void machineStateChanged(MachineStateChangeEvent evt) {
        final MachineStateChangeEvent e = evt;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MachineStatusPanel.this.updateMachineStatus(e);
            }
        });
    }

    public void machineProgress(MachineProgressEvent event) {
        final MachineProgressEvent e = event;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MachineStatusPanel.this.updateBuildStatus(e);
            }
        });
    }

    public void toolStatusChanged(MachineToolStatusEvent event) {
        final MachineToolStatusEvent e = event;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Vector<ToolModel> tools = e.getSource().getModel().getTools();
                String tempString = "";
                e.getSource().getDriver().readPlatformTemperature();
                for (ToolModel t : tools) {
                    double temp = t.getCurrentTemperature();
                    tempString = tempString + String.format("Toolhead " + t.getIndex() + ": %1$3.1f\u00b0C  ", temp);
                    if (!t.hasHeatedPlatform()) continue;
                    double ptemp = t.getPlatformCurrentTemperature();
                    tempString = tempString + String.format("Platform: %1$3.1f\u00b0C", ptemp);
                }
                MachineStatusPanel.this.tempLabel.setText(tempString);
            }
        });
    }
}

