/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import replicatorg.app.Base;
import replicatorg.app.ui.MainWindow;

public class FindReplace
extends JFrame
implements ActionListener {
    static final int BIG = 13;
    static final int SMALL = 6;
    MainWindow editor;
    JTextField findField;
    JTextField replaceField;
    static String findString;
    static String replaceString;
    JButton replaceButton;
    JButton replaceAllButton;
    JButton replaceFindButton;
    JButton findButton;
    JCheckBox ignoreCaseBox;
    static boolean ignoreCase;
    boolean found;

    public FindReplace(MainWindow editor) {
        super("Find");
        this.setResizable(false);
        this.editor = editor;
        Container pain = this.getContentPane();
        pain.setLayout(null);
        JLabel findLabel = new JLabel("Find:");
        Dimension d0 = findLabel.getPreferredSize();
        JLabel replaceLabel = new JLabel("Replace with:");
        Dimension d1 = replaceLabel.getPreferredSize();
        pain.add(findLabel);
        pain.add(replaceLabel);
        this.findField = new JTextField(20);
        pain.add(this.findField);
        this.replaceField = new JTextField(20);
        pain.add(this.replaceField);
        Dimension d2 = this.findField.getPreferredSize();
        if (findString != null) {
            this.findField.setText(findString);
        }
        if (replaceString != null) {
            this.replaceField.setText(replaceString);
        }
        int yoff = (1 + d2.height - d1.height) / 2;
        findLabel.setBounds(13 + (d1.width - d0.width) + yoff, 13, d1.width, d1.height);
        replaceLabel.setBounds(13, 13 + d2.height + 6 + yoff, d1.width, d1.height);
        this.ignoreCaseBox = new JCheckBox("Ignore Case");
        this.ignoreCaseBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ignoreCase = FindReplace.this.ignoreCaseBox.isSelected();
            }
        });
        this.ignoreCaseBox.setSelected(ignoreCase);
        pain.add(this.ignoreCaseBox);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        if (Base.isMacOS()) {
            this.replaceAllButton = new JButton("Replace All");
            buttons.add(this.replaceAllButton);
            this.replaceButton = new JButton("Replace");
            buttons.add(this.replaceButton);
            this.replaceFindButton = new JButton("Replace & Find");
            buttons.add(this.replaceFindButton);
            this.findButton = new JButton("Find");
            buttons.add(this.findButton);
        } else {
            this.findButton = new JButton("Find");
            buttons.add(this.findButton);
            this.replaceFindButton = new JButton("Replace & Find");
            buttons.add(this.replaceFindButton);
            this.replaceButton = new JButton("Replace");
            buttons.add(this.replaceButton);
            this.replaceAllButton = new JButton("Replace All");
            buttons.add(this.replaceAllButton);
        }
        pain.add(buttons);
        if (Base.isMacOS()) {
            buttons.setBorder(null);
        }
        Dimension d3 = buttons.getPreferredSize();
        buttons.setBounds(13, 13 + d2.height * 3 + 12 + 13, d3.width, d3.height);
        this.findField.setBounds(13 + d1.width + 6, 13, d3.width - (d1.width + 6), d2.height);
        this.replaceField.setBounds(13 + d1.width + 6, 13 + d2.height + 6, d3.width - (d1.width + 6), d2.height);
        this.ignoreCaseBox.setBounds(13 + d1.width + 6, 13 + d2.height * 2 + 12, d3.width, d2.height);
        this.replaceButton.addActionListener(this);
        this.replaceAllButton.addActionListener(this);
        this.replaceFindButton.addActionListener(this);
        this.findButton.addActionListener(this);
        this.replaceButton.setEnabled(false);
        this.replaceFindButton.setEnabled(false);
        this.getRootPane().setDefaultButton(this.findButton);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int wide = d3.width + 26;
        Rectangle butt = buttons.getBounds();
        int high = butt.y + butt.height + 26 + 6;
        this.setBounds((screen.width - wide) / 2, (screen.height - high) / 2, wide, high);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                FindReplace.this.handleClose();
            }
        });
        Base.registerWindowCloseKeys(this.getRootPane(), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FindReplace.this.handleClose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                FindReplace.this.findField.requestFocusInWindow();
                FindReplace.this.findField.selectAll();
            }
        });
    }

    public void handleClose() {
        findString = this.findField.getText();
        replaceString = this.replaceField.getText();
        this.setVisible(false);
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.findButton) {
            this.find(true);
        } else if (source == this.replaceFindButton) {
            this.replace();
            this.find(true);
        } else if (source == this.replaceButton) {
            this.replace();
        } else if (source == this.replaceAllButton) {
            this.replaceAll();
        }
    }

    public void find(boolean wrap) {
        int selectionEnd;
        int nextIndex;
        this.found = false;
        String search = this.findField.getText();
        if (search.length() == 0) {
            return;
        }
        String text = this.editor.textarea.getText();
        if (ignoreCase) {
            search = search.toLowerCase();
            text = text.toLowerCase();
        }
        if ((nextIndex = text.indexOf(search, selectionEnd = this.editor.textarea.getSelectionEnd())) == -1) {
            if (wrap) {
                nextIndex = text.indexOf(search, 0);
            }
            if (nextIndex == -1) {
                this.found = false;
                this.replaceButton.setEnabled(false);
                this.replaceFindButton.setEnabled(false);
                return;
            }
        }
        this.found = true;
        this.replaceButton.setEnabled(true);
        this.replaceFindButton.setEnabled(true);
        this.editor.textarea.select(nextIndex, nextIndex + search.length());
    }

    public void replace() {
        if (!this.found) {
            return;
        }
        String sel = this.editor.textarea.getSelectedText();
        if (sel.equals(this.replaceField.getText())) {
            this.found = false;
            this.replaceButton.setEnabled(false);
            this.replaceFindButton.setEnabled(false);
            return;
        }
        this.editor.textarea.setSelectedText(this.replaceField.getText());
        this.editor.build.getCode().setModified(true);
        this.replaceButton.setEnabled(false);
        this.replaceFindButton.setEnabled(false);
    }

    public void replaceAll() {
        this.editor.textarea.select(0, 0);
        do {
            this.find(false);
            this.replace();
        } while (this.found);
    }

    static {
        ignoreCase = true;
    }
}

