/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.drivers.OnboardParameters;
import replicatorg.drivers.Version;
import replicatorg.drivers.gen3.Sanguino3GDriver;

public class ExtruderOnboardParameters
extends JFrame {
    private static final long serialVersionUID = 6353987389397209816L;
    private OnboardParameters target;
    private static final NumberFormat threePlaces = (NumberFormat)Base.getLocalFormat().clone();
    final int FIELD_WIDTH = 10;
    Vector<Commitable> commitList;

    private boolean commit() {
        for (Commitable c : this.commitList) {
            if (c.isCommitable()) continue;
            return false;
        }
        for (Commitable c : this.commitList) {
            c.commit();
        }
        JOptionPane.showMessageDialog(this, "Changes will not take effect until the extruder board is reset.  You can \ndo this by turning your machine off and then on, or by disconnecting and \nreconnecting the extruder cable.  Make sure you don't still have a USB2TTL \ncable attached to the extruder controller, as the cable will keep the board \nfrom resetting.", "Extruder controller reminder", 1);
        return true;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel((LayoutManager)new MigLayout());
        JButton commitButton = new JButton("Commit Changes");
        panel.add(commitButton);
        commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (ExtruderOnboardParameters.this.commit()) {
                    ExtruderOnboardParameters.this.dispose();
                }
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                ExtruderOnboardParameters.this.dispose();
            }
        });
        panel.add(cancelButton);
        return panel;
    }

    public ExtruderOnboardParameters(OnboardParameters target) {
        super("Update onboard extruder options");
        threePlaces.setMaximumFractionDigits(3);
        this.FIELD_WIDTH = 10;
        this.commitList = new Vector();
        this.target = target;
        Version v = new Version(0, 0);
        if (target instanceof Sanguino3GDriver) {
            v = ((Sanguino3GDriver)target).getToolVersion();
        }
        this.setLayout((LayoutManager)new MigLayout());
        JTabbedPane extruders = new JTabbedPane();
        List<Integer> tools = target.toolheadsWithStoredData();
        for (int toolIndex : tools) {
            JPanel tab = new JPanel((LayoutManager)new MigLayout());
            ThermistorTablePanel ttp = new ThermistorTablePanel(0, "Extruder thermistor", toolIndex);
            tab.add(ttp);
            this.commitList.add(ttp);
            ttp = new ThermistorTablePanel(1, "Heated build platform thermistor", toolIndex);
            tab.add((Component)ttp, "wrap");
            this.commitList.add(ttp);
            if (!v.atLeast(new Version(2, 5))) {
                BackoffPanel backoffPanel = new BackoffPanel(toolIndex);
                tab.add((Component)backoffPanel, "span 2,growx,wrap");
                this.commitList.add(backoffPanel);
            }
            if (v.atLeast(new Version(2, 5))) {
                ExtraFeaturesPanel efp = new ExtraFeaturesPanel(toolIndex);
                tab.add((Component)efp, "span 2,growx,wrap");
                this.commitList.add(efp);
            }
            PIDPanel pidPanel = new PIDPanel(0, "Extruder", toolIndex);
            tab.add((Component)pidPanel, "growx");
            this.commitList.add(pidPanel);
            if (v.atLeast(new Version(2, 4))) {
                PIDPanel pp = new PIDPanel(1, "Heated build platform", toolIndex);
                tab.add((Component)pp, "growx,wrap");
                this.commitList.add(pp);
            }
            if (v.atLeast(new Version(2, 9))) {
                RegulatedCoolingFan rcf = new RegulatedCoolingFan(toolIndex);
                tab.add((Component)rcf, "span 2,growx,wrap");
                this.commitList.add(rcf);
            }
            extruders.addTab("Extruder " + toolIndex, tab);
        }
        this.add(extruders);
        this.add((Component)this.makeButtonPanel(), "span 2,newline");
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screen.width - this.getWidth()) / 2, (screen.height - this.getHeight()) / 2);
    }

    class RegulatedCoolingFan
    extends JPanel
    implements Commitable {
        private static final long serialVersionUID = 7765098486598830410L;
        private JCheckBox coolingFanEnabled;
        private JFormattedTextField coolingFanSetpoint;
        private final int toolIndex;

        RegulatedCoolingFan(int toolIndex) {
            super((LayoutManager)new MigLayout());
            this.coolingFanSetpoint = new JFormattedTextField(threePlaces);
            this.toolIndex = toolIndex;
            this.coolingFanEnabled = new JCheckBox("Enable regulated cooling fan (stepper extruders only)", ExtruderOnboardParameters.this.target.getCoolingFanEnabled(toolIndex));
            this.add((Component)this.coolingFanEnabled, "growx,wrap");
            this.coolingFanSetpoint.setColumns(10);
            this.coolingFanSetpoint.setValue(ExtruderOnboardParameters.this.target.getCoolingFanSetpoint(toolIndex));
            this.add(new JLabel("Setpoint (C)"));
            this.add((Component)this.coolingFanSetpoint, "wrap");
        }

        public void commit() {
            boolean enabled = this.coolingFanEnabled.isSelected();
            int setpoint = ((Number)this.coolingFanSetpoint.getValue()).intValue();
            ExtruderOnboardParameters.this.target.setCoolingFanParameters(enabled, setpoint, this.toolIndex);
        }

        public boolean isCommitable() {
            return true;
        }
    }

    private class PIDPanel
    extends JPanel
    implements Commitable {
        private NumberFormat eightPlaces = (NumberFormat)ExtruderOnboardParameters.access$000().clone();
        private JFormattedTextField pField;
        private JFormattedTextField iField;
        private JFormattedTextField dField;
        private final int which;
        private int toolIndex;

        PIDPanel(int which, String name, int toolIndex) {
            this.eightPlaces.setMaximumFractionDigits(8);
            this.pField = new JFormattedTextField(threePlaces);
            this.iField = new JFormattedTextField(this.eightPlaces);
            this.dField = new JFormattedTextField(threePlaces);
            this.which = which;
            this.toolIndex = toolIndex;
            this.setLayout((LayoutManager)new MigLayout());
            this.setBorder(BorderFactory.createTitledBorder(name + " PID parameters"));
            this.pField.setColumns(10);
            this.iField.setColumns(10);
            this.dField.setColumns(10);
            this.add(new JLabel("P parameter"));
            this.add((Component)this.pField, "wrap");
            this.add(new JLabel("I parameter"));
            this.add((Component)this.iField, "wrap");
            this.add(new JLabel("D parameter"));
            this.add((Component)this.dField, "wrap");
            OnboardParameters.PIDParameters pp = ExtruderOnboardParameters.this.target.getPIDParameters(which, toolIndex);
            this.pField.setValue(Float.valueOf(pp.p));
            this.iField.setValue(Float.valueOf(pp.i));
            this.dField.setValue(Float.valueOf(pp.d));
        }

        public void commit() {
            OnboardParameters.PIDParameters pp = new OnboardParameters.PIDParameters();
            pp.p = ((Number)this.pField.getValue()).floatValue();
            pp.i = ((Number)this.iField.getValue()).floatValue();
            pp.d = ((Number)this.dField.getValue()).floatValue();
            ExtruderOnboardParameters.this.target.setPIDParameters(this.which, pp, this.toolIndex);
        }

        public boolean isCommitable() {
            return true;
        }
    }

    private class ExtraFeaturesPanel
    extends JPanel
    implements Commitable {
        private JCheckBox swapMotors;
        private JComboBox extCh;
        private JComboBox hbpCh;
        private JComboBox abpCh;
        private OnboardParameters.ExtraFeatures ef;
        private int toolIndex;

        ExtraFeaturesPanel(int toolIndex) {
            this.toolIndex = toolIndex;
            this.setLayout((LayoutManager)new MigLayout());
            this.ef = ExtruderOnboardParameters.this.target.getExtraFeatures(toolIndex);
            this.swapMotors = new JCheckBox("Use 2A/2B to drive DC motor instead of 1A/1B", this.ef.swapMotorController);
            this.add((Component)this.swapMotors, "span 3,growx,wrap");
            Vector<String> choices = new Vector<String>();
            choices.add("Channel A");
            choices.add("Channel B");
            choices.add("Channel C");
            this.extCh = new JComboBox(choices);
            this.extCh.setSelectedIndex(this.ef.heaterChannel);
            this.add(new JLabel("Extruder heater uses:"));
            this.add(this.extCh);
            this.add((Component)new JLabel("(default ch. B)"), "wrap");
            this.hbpCh = new JComboBox(choices);
            this.hbpCh.setSelectedIndex(this.ef.hbpChannel);
            this.add(new JLabel("Platform heater uses:"));
            this.add(this.hbpCh);
            this.add((Component)new JLabel("(default ch. A)"), "wrap");
            this.abpCh = new JComboBox(choices);
            this.abpCh.setSelectedIndex(this.ef.abpChannel);
            this.add(new JLabel("ABP motor uses:"));
            this.add(this.abpCh);
            this.add((Component)new JLabel("(default ch. C)"), "wrap");
        }

        public void commit() {
            this.ef.swapMotorController = this.swapMotors.isSelected();
            this.ef.heaterChannel = this.extCh.getSelectedIndex();
            this.ef.hbpChannel = this.hbpCh.getSelectedIndex();
            this.ef.abpChannel = this.abpCh.getSelectedIndex();
            ExtruderOnboardParameters.this.target.setExtraFeatures(this.ef, this.toolIndex);
        }

        public boolean isCommitable() {
            int a = this.extCh.getSelectedIndex();
            int b = this.hbpCh.getSelectedIndex();
            int c = this.abpCh.getSelectedIndex();
            if (a == b || b == c || a == c) {
                JOptionPane.showMessageDialog(this, "Two or more features are using the same mosfet channel!", "Channel conflict", 0);
                return false;
            }
            return true;
        }
    }

    private class BackoffPanel
    extends JPanel
    implements Commitable {
        private static final long serialVersionUID = 6593800743174557032L;
        private JFormattedTextField stopMsField = new JFormattedTextField(ExtruderOnboardParameters.access$000());
        private JFormattedTextField reverseMsField = new JFormattedTextField(ExtruderOnboardParameters.access$000());
        private JFormattedTextField forwardMsField = new JFormattedTextField(ExtruderOnboardParameters.access$000());
        private JFormattedTextField triggerMsField = new JFormattedTextField(ExtruderOnboardParameters.access$000());
        private int toolIndex;

        BackoffPanel(int toolIndex) {
            this.toolIndex = toolIndex;
            this.setLayout((LayoutManager)new MigLayout());
            this.setBorder(BorderFactory.createTitledBorder("Reversal parameters"));
            this.stopMsField.setColumns(10);
            this.reverseMsField.setColumns(10);
            this.forwardMsField.setColumns(10);
            this.triggerMsField.setColumns(10);
            this.add(new JLabel("Time to pause (ms)"));
            this.add((Component)this.stopMsField, "wrap");
            this.add(new JLabel("Time to reverse (ms)"));
            this.add((Component)this.reverseMsField, "wrap");
            this.add(new JLabel("Time to advance (ms)"));
            this.add((Component)this.forwardMsField, "wrap");
            this.add(new JLabel("Min. extrusion time before reversal (ms)"));
            this.add((Component)this.triggerMsField, "wrap");
            OnboardParameters.BackoffParameters bp = ExtruderOnboardParameters.this.target.getBackoffParameters(toolIndex);
            this.stopMsField.setValue(bp.stopMs);
            this.reverseMsField.setValue(bp.reverseMs);
            this.forwardMsField.setValue(bp.forwardMs);
            this.triggerMsField.setValue(bp.triggerMs);
        }

        public void commit() {
            OnboardParameters.BackoffParameters bp = new OnboardParameters.BackoffParameters();
            bp.forwardMs = ((Number)this.forwardMsField.getValue()).intValue();
            bp.reverseMs = ((Number)this.reverseMsField.getValue()).intValue();
            bp.stopMs = ((Number)this.stopMsField.getValue()).intValue();
            bp.triggerMs = ((Number)this.triggerMsField.getValue()).intValue();
            ExtruderOnboardParameters.this.target.setBackoffParameters(bp, this.toolIndex);
        }

        public boolean isCommitable() {
            return true;
        }
    }

    class ThermistorTablePanel
    extends JPanel
    implements Commitable {
        private static final long serialVersionUID = 7765098486598830410L;
        private JFormattedTextField betaField;
        private JFormattedTextField r0Field;
        private JFormattedTextField t0Field;
        private final int which;
        private final int toolIndex;

        ThermistorTablePanel(int which, String titleText, int toolIndex) {
            super((LayoutManager)new MigLayout());
            this.betaField = new JFormattedTextField(threePlaces);
            this.r0Field = new JFormattedTextField(threePlaces);
            this.t0Field = new JFormattedTextField(threePlaces);
            this.which = which;
            this.toolIndex = toolIndex;
            this.setBorder(BorderFactory.createTitledBorder(titleText));
            this.betaField.setColumns(10);
            this.r0Field.setColumns(10);
            this.t0Field.setColumns(10);
            double beta = ExtruderOnboardParameters.this.target.getBeta(which, this.toolIndex);
            if (beta == -1.0) {
                beta = 4066.0;
            }
            this.betaField.setValue((int)beta);
            this.add(new JLabel("Beta"));
            this.add((Component)this.betaField, "wrap");
            double r0 = ExtruderOnboardParameters.this.target.getR0(which, this.toolIndex);
            if (r0 == -1.0) {
                r0 = 100000.0;
            }
            this.r0Field.setValue((int)r0);
            this.add(new JLabel("Thermistor Resistance"));
            this.add((Component)this.r0Field, "wrap");
            double t0 = ExtruderOnboardParameters.this.target.getT0(which, this.toolIndex);
            if (t0 == -1.0) {
                t0 = 25.0;
            }
            this.t0Field.setValue((int)t0);
            this.add(new JLabel("Base Temperature"));
            this.add((Component)this.t0Field, "wrap");
        }

        public void commit() {
            int beta = ((Number)this.betaField.getValue()).intValue();
            int r0 = ((Number)this.r0Field.getValue()).intValue();
            int t0 = ((Number)this.t0Field.getValue()).intValue();
            ExtruderOnboardParameters.this.target.createThermistorTable(this.which, r0, t0, beta, this.toolIndex);
        }

        public boolean isCommitable() {
            return true;
        }
    }

    static interface Commitable {
        public void commit();

        public boolean isCommitable();
    }
}

