/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.app.ui.GcodeSaveWindow;
import replicatorg.app.ui.GcodeSelectWindow;
import replicatorg.dualstrusion.DualStrusionConstruction;
import replicatorg.model.Build;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.ToolpathGeneratorFactory;
import replicatorg.plugin.toolpath.ToolpathGeneratorThread;

public class DualStrusionWindow
extends JFrame {
    private static final long serialVersionUID = 2548421042732389328L;
    File dest;
    File result;
    boolean repStart;
    boolean repEnd;
    boolean uWipe;
    Queue<File> stls;
    Queue<File> gcodes;
    CountDownLatch numStls;
    CountDownLatch numGcodes;

    public DualStrusionWindow() {
        this((String)null);
    }

    public DualStrusionWindow(String path) {
        super("DualStrusion Window (EXPERIMENTAL functionality)");
        Base.logger.log(Level.FINE, "Dualstrusion window booting up...");
        this.setResizable(true);
        this.setLocation(400, 0);
        Container cont = this.getContentPane();
        cont.setLayout((LayoutManager)new MigLayout("fill"));
        cont.setVisible(true);
        JTextArea explanation = new JTextArea();
        explanation.setText("This window is used to combine two Gcode files generated by SkeinForge. This allows for multiple objects in one print job or multiple materials or colors in one printed object. The resulting gcode assumes that Toolhead1 is on the left and Toolhead0 is on the right");
        explanation.setOpaque(false);
        explanation.setEditable(false);
        explanation.setWrapStyleWord(true);
        explanation.setSize(700, 200);
        explanation.setLineWrap(true);
        cont.add((Component)new JLabel("Extruder A (Left)"), "split");
        final JTextField Toolhead1 = new JTextField(60);
        String loadFileName = Base.preferences.get("dualstrusionwindow.1file", path);
        if (loadFileName != null) {
            Toolhead1.setText(loadFileName);
        } else {
            Toolhead1.setText("");
        }
        JButton Toolhead1ChooserButton = new JButton("Browse...");
        Toolhead1ChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                s = !Toolhead1.getText().equals("") ? GcodeSelectWindow.goString(new File(Toolhead1.getText())) : GcodeSelectWindow.goString();
                if (s != null) {
                    Toolhead1.setText(s);
                }
            }
        });
        cont.add((Component)Toolhead1, "split");
        cont.add((Component)Toolhead1ChooserButton, "wrap");
        final JTextField Toolhead0 = new JTextField(60);
        loadFileName = Base.preferences.get("dualstrusionwindow.0file", path);
        if (loadFileName != null) {
            Toolhead0.setText(loadFileName);
        } else {
            Toolhead0.setText("");
        }
        JButton Toolhead0ChooserButton = new JButton("Browse...");
        Toolhead0ChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                s = !Toolhead0.getText().equals("") ? GcodeSelectWindow.goString(new File(Toolhead0.getText())) : GcodeSelectWindow.goString();
                if (s != null) {
                    Toolhead0.setText(s);
                }
            }
        });
        JButton switchItem = new JButton("Switch Toolheads");
        switchItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String temp = Toolhead1.getText();
                Toolhead1.setText(Toolhead0.getText());
                Toolhead0.setText(temp);
            }
        });
        cont.add((Component)switchItem, "wrap");
        cont.add((Component)new JLabel("Extruder B (Right)"), "split");
        cont.add((Component)Toolhead0, "split");
        cont.add((Component)Toolhead0ChooserButton, "wrap");
        final JTextField DestinationTextField = new JTextField(60);
        loadFileName = Base.preferences.get("dualstrusionwindow.destfile", "");
        DestinationTextField.setText(loadFileName);
        JButton DestinationChooserButton = new JButton("Browse...");
        DestinationChooserButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                if (!DestinationTextField.getText().equals("")) {
                    s = GcodeSaveWindow.goString(new File(DestinationTextField.getText()));
                } else if (!Toolhead1.getText().equals("")) {
                    int i = Toolhead1.getText().lastIndexOf("/");
                    String a = Toolhead1.getText().substring(0, i + 1) + "untitled.gcode";
                    File untitled = new File(a);
                    System.out.println(a);
                    s = GcodeSaveWindow.goString(untitled);
                } else {
                    s = GcodeSaveWindow.goString();
                }
                if (s != null) {
                    if (s.contains(".")) {
                        int lastp = s.lastIndexOf(".");
                        if (!s.substring(lastp + 1, s.length()).equals("gcode")) {
                            s = s.substring(0, lastp) + ".gcode";
                        }
                    } else {
                        s = s + ".gcode";
                    }
                    DestinationTextField.setText(s);
                }
            }
        });
        cont.add((Component)new JLabel("Save As: "), "split");
        cont.add((Component)DestinationTextField, "split");
        cont.add((Component)DestinationChooserButton, "wrap");
        final JCheckBox replaceStart = new JCheckBox();
        replaceStart.setSelected(true);
        cont.add((Component)new JLabel("Use default start.gcode: "), "split");
        cont.add((Component)replaceStart, "wrap");
        final JCheckBox replaceEnd = new JCheckBox();
        replaceEnd.setSelected(true);
        cont.add((Component)new JLabel("Use default end.gcode: "), "split");
        cont.add((Component)replaceEnd, "wrap");
        final JCheckBox useWipes = new JCheckBox();
        useWipes.setSelected(true);
        cont.add((Component)new JLabel("Use wipes defined in machines.xml"), "split");
        cont.add((Component)useWipes, "wrap");
        JButton merge = new JButton("Merge");
        merge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String ext;
                if (Toolhead1.getText().equals(Toolhead0.getText())) {
                    int option = JOptionPane.showConfirmDialog(null, "You are trying to combine two of the same file. Are you sure you want to do this?", "Continue?", 0, 2);
                    System.out.println(option);
                    if (option == 1) {
                        return;
                    }
                }
                Base.logger.log(Level.FINE, "Building lists of files to combine");
                DualStrusionWindow.this.stls = new LinkedList<File>();
                DualStrusionWindow.this.gcodes = new LinkedList<File>();
                File test = new File(Toolhead1.getText());
                if (test.exists()) {
                    ext = DualStrusionWindow.getExtension(test.getName());
                    if ("stl".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.stls.add(test);
                    } else if ("gcode".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.gcodes.add(test);
                    } else {
                        JOptionPane.showConfirmDialog(null, "File for Extruder A not an stl or gcode. Please select something I can understand.", "Select a different file.", -1, 2);
                        return;
                    }
                }
                if ((test = new File(Toolhead0.getText())).exists()) {
                    ext = DualStrusionWindow.getExtension(test.getName());
                    if ("stl".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.stls.add(test);
                    } else if ("gcode".equalsIgnoreCase(ext)) {
                        DualStrusionWindow.this.gcodes.add(test);
                    } else {
                        JOptionPane.showConfirmDialog(null, "File for Extruder B not an stl or gcode. Please select something I can understand.", "Select a different file.", -1, 2);
                        return;
                    }
                }
                Base.preferences.put("dualstrusionwindow.1file", Toolhead1.getText());
                Base.preferences.put("dualstrusionwindow.0file", Toolhead0.getText());
                Base.preferences.put("dualstrusionwindow.destfile", DestinationTextField.getText());
                DualStrusionWindow.this.dest = new File(DestinationTextField.getText());
                DualStrusionWindow.this.repStart = replaceStart.isSelected();
                DualStrusionWindow.this.repEnd = replaceEnd.isSelected();
                DualStrusionWindow.this.uWipe = useWipes.isSelected();
                if (!DualStrusionWindow.this.stls.isEmpty()) {
                    Base.logger.log(Level.FINE, "stls is not empty, converting STL files to gcode");
                    DualStrusionWindow.this.numStls = new CountDownLatch(DualStrusionWindow.this.stls.size());
                    DualStrusionWindow.this.stlsToGcode();
                } else {
                    Base.logger.log(Level.FINE, "stls is empty, combining gcode files");
                    DualStrusionWindow.this.numGcodes = new CountDownLatch(DualStrusionWindow.this.gcodes.size());
                    DualStrusionWindow.this.combineGcodes();
                }
            }
        });
        cont.add((Component)merge, "split");
        JButton help = new JButton("Help");
        help.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                try {
                    Desktop.getDesktop().browse(new URI("http://goo.gl/DV5vn"));
                }
                catch (Exception e) {
                    Base.logger.log(Level.WARNING, "Could not load online help! See log level FINEST for more details");
                    Base.logger.log(Level.FINEST, "" + e);
                }
            }
        });
        cont.add(help);
        this.pack();
        this.setVisible(true);
        Base.logger.log(Level.FINE, "Finishing construction of Dualstrusion window");
    }

    private void stlsToGcode() {
        try {
            File toBuild = this.stls.poll();
            final File buildDest = new File(DualStrusionWindow.replaceExtension(toBuild.getAbsolutePath(), "gcode"));
            Base.logger.log(Level.FINE, "Initializing stl -> gcode " + toBuild.getAbsolutePath());
            if (!buildDest.exists()) {
                buildDest.createNewFile();
            }
            this.gcodes.add(buildDest);
            JFrame progress = new JFrame("STL to GCode Progress");
            ToolpathGenerator gen = ToolpathGeneratorFactory.createSelectedGenerator();
            Build b = new Build(toBuild.getAbsolutePath());
            ToolpathGeneratorThread tgt = new ToolpathGeneratorThread(progress, gen, b);
            tgt.addListener(new ToolpathGenerator.GeneratorListener(){

                public void updateGenerator(String message) {
                    if (message.equals("Config Done") && !DualStrusionWindow.this.stls.isEmpty()) {
                        Base.logger.log(Level.FINE, "Starting next stl > gcode: " + DualStrusionWindow.this.stls.peek().getName());
                        DualStrusionWindow.this.stlsToGcode();
                    }
                }

                public void generationComplete(ToolpathGenerator.GeneratorListener.Completion completion, Object details) {
                    DualStrusionWindow.this.numStls.countDown();
                    if (DualStrusionWindow.this.numStls.getCount() == 0L) {
                        Base.logger.log(Level.FINE, "done converting stl files, on to gcode combination! " + DualStrusionWindow.this.numStls.getCount() + "==0?  " + buildDest.getName());
                        DualStrusionWindow.this.numGcodes = new CountDownLatch(DualStrusionWindow.this.gcodes.size());
                        DualStrusionWindow.this.combineGcodes();
                    }
                }
            });
            tgt.setDualStrusionSupportFlag(true, 200, 300, toBuild.getName());
            Base.logger.log(Level.FINE, "Init finished, starting conversion");
            tgt.start();
        }
        catch (IOException e) {
            Base.logger.log(Level.SEVERE, "cannot read stl! Aborting dualstrusion generation, see log level FINEST for more details.");
            Base.logger.log(Level.FINEST, "" + e);
        }
    }

    private static String getExtension(String path) {
        int i = path.lastIndexOf(".");
        String ext = path.substring(i + 1, path.length());
        return ext;
    }

    private static String replaceExtension(String s, String newExtension) {
        int i = s.lastIndexOf(".");
        s = s.substring(0, i + 1);
        s = s + newExtension;
        return s;
    }

    private void combineGcodes() {
        if (this.numGcodes.getCount() != 2L) {
            Base.logger.log(Level.SEVERE, "Expected two gcode files, found " + this.numGcodes.getCount() + " cancelling Dualstrusion combination");
            return;
        }
        Base.logger.log(Level.FINE, "pre pause");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Base.logger.log(Level.FINE, "post pause");
        DualStrusionConstruction dcs = new DualStrusionConstruction(this.gcodes.poll(), this.gcodes.poll(), this.dest, this.repStart, this.repEnd, this.uWipe);
        dcs.run();
        this.result = dcs.getCombinedFile();
        Base.logger.log(Level.FINE, "Finished DualStrusionWindow's part");
        this.removeAll();
        this.dispose();
    }

    public File getCombined() {
        return this.result;
    }
}

