/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.vecmath.Point3d;
import replicatorg.app.ui.GcodeSelectWindow;
import replicatorg.app.ui.MainWindow;
import replicatorg.app.ui.modeling.EditingModel;
import replicatorg.dualstrusion.CodeCombination;
import replicatorg.model.Build;
import replicatorg.model.BuildModel;
import replicatorg.plugin.toolpath.ToolpathGenerator;
import replicatorg.plugin.toolpath.ToolpathGeneratorFactory;
import replicatorg.plugin.toolpath.ToolpathGeneratorThread;

public class CombineWindow
extends JFrame {
    private File sourceFile;
    private File destFile;
    private int numRepetitions = 2;
    private double availableSpace = 100.0;
    private List<File> combineFiles;
    private JLabel fileLabel;
    private JLabel saveLabel;
    private JLabel numLabel;
    private JLabel spaceLabel;
    private JTextField fileInput;
    private JTextField saveInput;
    private JTextField numInput;
    private JTextField spaceInput;
    private JButton fileBrowseButton;
    private JButton saveBrowseButton;
    private JButton mergeButton;
    private JButton cancelButton;
    private final MainWindow theMainWindow;

    public CombineWindow(MainWindow mw) {
        this(null, mw);
    }

    public CombineWindow(String path, MainWindow mw) {
        super("Row Combination (EXPERIMENTAL functionality)");
        this.theMainWindow = mw;
        this.fileLabel = new JLabel("File:");
        this.fileInput = new JTextField();
        this.fileBrowseButton = new JButton("Browse...");
        this.fileBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                s = !CombineWindow.this.fileInput.getText().equals("") ? GcodeSelectWindow.goString(new File(CombineWindow.this.fileInput.getText())) : GcodeSelectWindow.goString();
                if (s != null) {
                    CombineWindow.this.fileInput.setText(s);
                }
            }
        });
        this.saveLabel = new JLabel("Save as:");
        this.saveInput = new JTextField();
        this.saveBrowseButton = new JButton("Browse...");
        this.saveBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                String s = null;
                s = !CombineWindow.this.saveInput.getText().equals("") ? GcodeSelectWindow.goString(new File(CombineWindow.this.saveInput.getText())) : GcodeSelectWindow.goString();
                if (s != null) {
                    CombineWindow.this.saveInput.setText(s);
                }
            }
        });
        if (path != null) {
            this.fileInput.setText(path);
            this.saveInput.setText(path.replace(".stl", ".gcode"));
        }
        this.numLabel = new JLabel("Rows of copies:");
        this.numInput = new JTextField();
        this.numInput.setText("2");
        this.numLabel.setToolTipText("Number of rows of copies, 1 per row");
        this.spaceLabel = new JLabel("Build Depth(mm):");
        this.spaceInput = new JTextField();
        this.spaceInput.setText("100");
        this.spaceLabel.setToolTipText("Depth of your build platform");
        this.mergeButton = new JButton("Merge");
        this.mergeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (CombineWindow.this.fileInput.getText().equals("") || CombineWindow.this.saveInput.getText().equals("") || CombineWindow.this.numInput.getText().equals("") || CombineWindow.this.spaceInput.getText().equals("")) {
                    JOptionPane.showConfirmDialog(CombineWindow.this, "Please fill in all fields.", "Oops!", -1, 0);
                    return;
                }
                CombineWindow.this.sourceFile = new File(CombineWindow.this.fileInput.getText());
                CombineWindow.this.destFile = new File(CombineWindow.this.saveInput.getText());
                CombineWindow.this.numRepetitions = Integer.parseInt(CombineWindow.this.numInput.getText());
                CombineWindow.this.availableSpace = Double.parseDouble(CombineWindow.this.spaceInput.getText());
                if (CombineWindow.this.numRepetitions < 2) {
                    JOptionPane.showConfirmDialog(CombineWindow.this, "Number of copies must be greater than 2.", "Oops!", -1, 0);
                    return;
                }
                CombineWindow.this.theMainWindow.handleOpenUnchecked(CombineWindow.this.sourceFile.getAbsolutePath(), 0, 0, 0, 0);
                if (!CombineWindow.this.sourceFile.getName().endsWith(".stl")) {
                    String message = "I know the file browser let you choose gcode, but this function only supports .stl at the moment. Sorry about that.";
                    JOptionPane.showConfirmDialog(CombineWindow.this, "I know the file browser let you choose gcode, but this function only supports .stl at the moment. Sorry about that.", "Oops!", -1, 0);
                    return;
                }
                CombineWindow.this.createGcode();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                CombineWindow.this.close();
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        int fsLabelWidth = 45;
        int fsInputMinW = 10;
        int fsInputPrefW = 200;
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.fileLabel, fsLabelWidth, fsLabelWidth, fsLabelWidth).addComponent(this.fileInput, fsInputMinW, fsInputPrefW, Short.MAX_VALUE).addComponent(this.fileBrowseButton)).addGroup(layout.createSequentialGroup().addComponent(this.saveLabel, fsLabelWidth, fsLabelWidth, fsLabelWidth).addComponent(this.saveInput, fsInputMinW, fsInputPrefW, Short.MAX_VALUE).addComponent(this.saveBrowseButton))).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.numLabel).addComponent(this.numInput)).addGroup(layout.createSequentialGroup().addComponent(this.spaceLabel).addComponent(this.spaceInput))).addGroup(layout.createSequentialGroup().addComponent(this.cancelButton).addComponent(this.mergeButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.fileLabel).addComponent(this.fileInput).addComponent(this.fileBrowseButton)).addGroup(layout.createParallelGroup().addComponent(this.saveLabel).addComponent(this.saveInput).addComponent(this.saveBrowseButton))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.numLabel).addComponent(this.numInput)).addGroup(layout.createParallelGroup().addComponent(this.spaceLabel).addComponent(this.spaceInput))).addGroup(layout.createParallelGroup().addComponent(this.cancelButton).addComponent(this.mergeButton)));
        this.setResizable(true);
        this.setLocation(400, 0);
        this.pack();
        this.setVisible(true);
    }

    private void createGcode() {
        EditingModel em = this.theMainWindow.previewPanel.getModel();
        em.center();
        Point3d bbUp = new Point3d();
        em.getBoundingBox().getUpper(bbUp);
        double halfDepth = bbUp.y;
        double halfSpace = this.availableSpace / 2.0;
        em.translateObject(0.0, halfDepth - halfSpace, 0.0);
        double objDepth = halfDepth * 2.0;
        double spaceNeeded = objDepth * (double)this.numRepetitions;
        if (spaceNeeded > this.availableSpace) {
            JOptionPane.showConfirmDialog(this, "Not enough space for that many objects.", "Oops!", -1, 0);
            return;
        }
        double offset = this.availableSpace - spaceNeeded;
        offset /= (double)(this.numRepetitions - 1);
        offset += objDepth;
        BuildModel bm = em.getBuildModel();
        String fileNameBase = this.sourceFile.getAbsolutePath();
        fileNameBase = fileNameBase.substring(0, fileNameBase.lastIndexOf("."));
        final LinkedList<ToolpathGeneratorThread> generatorQueue = new LinkedList<ToolpathGeneratorThread>();
        final CountDownLatch numLeft = new CountDownLatch(this.numRepetitions);
        this.combineFiles = new ArrayList<File>();
        for (int i = 0; i < this.numRepetitions; ++i) {
            try {
                File tmpFile = new File(fileNameBase + "_tmp_" + i + ".stl");
                bm.saveAs(tmpFile);
                this.combineFiles.add(new File(fileNameBase + "_tmp_" + i + ".gcode"));
                Build readFile = new Build(tmpFile.getAbsolutePath());
                ToolpathGenerator generator = ToolpathGeneratorFactory.createSelectedGenerator();
                JFrame progressFrame = new JFrame("File " + i);
                ToolpathGeneratorThread genThread = new ToolpathGeneratorThread(progressFrame, generator, readFile);
                genThread.setDualStrusionSupportFlag(true, 200, 200, "File " + i);
                genThread.addListener(new ToolpathGenerator.GeneratorListener(){
                    private final Queue<ToolpathGeneratorThread> genQueue;
                    {
                        this.genQueue = generatorQueue;
                    }

                    public void updateGenerator(String message) {
                        if (message.equals("Config Done") && !this.genQueue.isEmpty()) {
                            this.genQueue.poll().start();
                        }
                    }

                    public void generationComplete(ToolpathGenerator.GeneratorListener.Completion completion, Object details) {
                        if (completion == ToolpathGenerator.GeneratorListener.Completion.SUCCESS) {
                            numLeft.countDown();
                            if (numLeft.getCount() == 0L) {
                                CombineWindow.this.combineGcode();
                            }
                        }
                    }
                });
                generatorQueue.add(genThread);
                em.translateObject(0.0, offset, 0.0);
                continue;
            }
            catch (IOException e) {
                System.err.println("cannot read stl");
                this.close();
            }
        }
        ((ToolpathGeneratorThread)generatorQueue.poll()).start();
    }

    private void combineGcode() {
        CodeCombination.mergeGCodes(this.destFile, this.combineFiles);
        this.theMainWindow.handleOpenUnchecked(this.destFile.getAbsolutePath(), 0, 0, 0, 0);
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

