/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.app;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GCode {
    protected static char[] codes = new char[]{'A', 'B', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'P', 'Q', 'R', 'S', 'T', 'X', 'Y', 'Z'};
    static Pattern parenPattern = Pattern.compile("\\((.*)\\)");
    static Pattern semiPattern = Pattern.compile(";(.*)");
    static Pattern deleteBlockPattern = Pattern.compile("^(\\.*)");
    private String command;
    private String comment = new String();
    private List<gCodeParameter> parameters;

    public GCode(String command) {
        this.command = new String(command);
        this.parameters = new ArrayList<gCodeParameter>();
        this.parseComments();
        this.parseCodes();
    }

    private void parseComments() {
        Matcher parenMatcher = parenPattern.matcher(this.command);
        Matcher semiMatcher = semiPattern.matcher(this.command);
        if (parenMatcher.find()) {
            this.comment = parenMatcher.group(1);
        }
        if (semiMatcher.find()) {
            this.comment = semiMatcher.group(1);
        }
        this.comment = this.comment.trim();
        this.comment = this.comment.replace('|', '\n');
        this.command = parenMatcher.replaceAll("");
        semiMatcher = semiPattern.matcher(this.command);
        this.command = semiMatcher.replaceAll("");
    }

    private void parseCodes() {
        for (char code : codes) {
            Pattern myPattern = Pattern.compile(code + "([0-9.+-]+)");
            Matcher myMatcher = myPattern.matcher(this.command);
            if (this.command.indexOf(code) < 0) continue;
            double value = 0.0;
            if (myMatcher.find()) {
                String match = myMatcher.group(1);
                value = Double.parseDouble(match);
            }
            this.parameters.add(new gCodeParameter(code, value));
        }
    }

    public String getCommand() {
        return new String(this.command);
    }

    public String getComment() {
        return new String(this.comment);
    }

    public boolean hasCode(char searchCode) {
        for (gCodeParameter parameter : this.parameters) {
            if (parameter.code != searchCode) continue;
            return true;
        }
        return false;
    }

    public double getCodeValue(char searchCode) {
        for (gCodeParameter parameter : this.parameters) {
            if (parameter.code != searchCode) continue;
            return parameter.value;
        }
        return -1.0;
    }

    private class gCodeParameter {
        public final char code;
        public final Double value;

        gCodeParameter(char code, Double value) {
            this.code = code;
            this.value = value;
        }
    }
}

