/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.stl;

import java.awt.Component;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.ProgressMonitorInputStream;
import org.j3d.loaders.stl.LittleEndianConverter;
import org.j3d.loaders.stl.STLParser;

class STLBinaryParser
extends STLParser {
    private static final int HEADER_SIZE = 84;
    private static final int RECORD_SIZE = 50;
    private static final int COMMENT_SIZE = 80;
    private BufferedInputStream itsStream;
    private final byte[] itsReadBuffer = new byte[48];
    private final int[] itsDataBuffer = new int[12];

    public void close() throws IOException {
        if (this.itsStream != null) {
            this.itsStream.close();
        }
    }

    public boolean parse(URL url) throws IOException {
        int length;
        InputStream stream;
        block6: {
            stream = null;
            length = -1;
            try {
                URLConnection connection = url.openConnection();
                stream = connection.getInputStream();
                length = connection.getContentLength();
            }
            catch (IOException e) {
                if (stream == null) break block6;
                stream.close();
            }
        }
        this.itsStream = new BufferedInputStream(stream);
        try {
            for (int i = 0; i < 80; ++i) {
                this.itsStream.read();
            }
            this.itsNumOfObjects = 1;
            this.itsNumOfFacets = new int[]{LittleEndianConverter.read4ByteBlock(this.itsStream)};
            this.itsNames = new String[1];
            if (length != -1 && length != this.itsNumOfFacets[0] * 50 + 84) {
                throw new IOException("File size does not match.");
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return false;
    }

    public boolean parse(URL url, Component parentComponent) throws InterruptedIOException, IOException {
        int length;
        InputStream stream;
        block6: {
            stream = null;
            length = -1;
            try {
                URLConnection connection = url.openConnection();
                stream = connection.getInputStream();
                length = connection.getContentLength();
            }
            catch (IOException e) {
                if (stream == null) break block6;
                stream.close();
            }
        }
        stream = new ProgressMonitorInputStream(parentComponent, "parsing " + url.toString(), stream);
        this.itsStream = new BufferedInputStream(stream);
        try {
            for (int i = 0; i < 80; ++i) {
                this.itsStream.read();
            }
            this.itsNumOfObjects = 1;
            this.itsNumOfFacets = new int[]{LittleEndianConverter.read4ByteBlock(this.itsStream)};
            this.itsNames = new String[1];
            if (length != -1 && length != this.itsNumOfFacets[0] * 50 + 84) {
                throw new IOException("File size does not match.");
            }
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        return false;
    }

    public boolean getNextFacet(double[] normal, double[][] vertices) throws InterruptedIOException, IOException {
        int i;
        LittleEndianConverter.read(this.itsReadBuffer, this.itsDataBuffer, 0, 12, (InputStream)this.itsStream);
        for (i = 0; i < 3; ++i) {
            normal[i] = Float.intBitsToFloat(this.itsDataBuffer[i]);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                vertices[i][j] = Float.intBitsToFloat(this.itsDataBuffer[i * 3 + j + 3]);
            }
        }
        this.itsStream.read();
        this.itsStream.read();
        return true;
    }
}

