//-------------------------------------------------------------------------
//-- Taller OpenScad.   OSHWDEM, Coruña, Nov-2012  
//--  By Obijuan  (Juan Gonzalez, juan@iearobotics.com)
//-------------------------------------------------------------------------
// GPL LICENSE
//-------------------------------------------------------------------------
//-- Ejemplo de uso de todo lo aprendido
//-- Nuestra propia pieza de mecano
//-- Biblioteca Mecano


//-- Unidad elemental: un cuadrado de lado l con grosor, con un taladro en el centro
module mecano_unit( l = 10, grosor = 3, taladro = 4)
{

  difference() {
    cube([l, l, grosor], center = true);
    cylinder(r = taladro /2, h = grosor + 10, center = true, $fn = 10);
  }

}

//-- Pieza lineal de mecano. n indica el numero de unidades de la pieza
//-- Es una pieza parametrica, de tamaño variable
module mecano_lineal(n = 2, l = 10, grosor = 3, taladro = 4)
{

  for (i = [0:n-1]) {
    translate([i*10, 0, 0])
      mecano_unit(l = l, grosor = grosor, taladro = taladro);
  }
}

//-- Ejemplos de uso 

//-- Pieza de 3 unidades
mecano_lineal(n=2);

//-- Pieza de 3 unidades
translate([0, 15, 0])
  mecano_lineal(n=3);

//-- Pieza de 5 unidades, con taladro de metrica 3
translate([0, 30, 0])
mecano_lineal(n=5, taladro = 3);


