//-------------------------------------------------------------------------
//-- Taller OpenScad.   OSHWDEM, Coruña, Nov-2012  
//--  By Obijuan  (Juan Gonzalez, juan@iearobotics.com)
//-------------------------------------------------------------------------
// GPL LICENSE
//-------------------------------------------------------------------------
//-- Operadores booleanos (I): Union

//-- Enseñar como funciona la union
//-- Se usa una union "implicita". No hace falta declararlo explicitamente
//-- Todo lo que va entre llaves al aplicar las transformaciones se considera
//-- como una union
//-- Se utiliza union de 2 cubos rotados para generar una estrella de 8 puntas
//-- con un tercer "cubo" como base


//-- Base de la figura
color("Blue")
  cube([50, 50, 3],center=true);


//-- Figura: Estrella de 8 puntas
//-- formada por 2 cubos, uno rotado 45 grados con respecto al otro
translate([0, 0, 10/2 + 3/2]) {

  //-- Todo lo que esta entre llaves se considera una "union"
  //-- Se omite el comando union() porque somos vagos y queremos
  //-- escribir lo minimo posible ;-)
  cube([30, 30, 10], center=true);

  rotate([0 ,0, 45])
    cube([30, 30, 10], center=true);
}


//--  La union de los dos cubos anteriores se puede hacer de una manrea 
//--  explicita con el comando union() :

/*
union() {
  cube([30, 30, 10], center=true);

  rotate([0 ,0, 45])
    cube([30, 30, 10], center=true);
}

*/