#ifndef LANGUAGE_H
#define LANGUAGE_H

// NOTE: IF YOU CHANGE THIS FILE / MERGE THIS FILE WITH CHANGES
//
//   ==> ALWAYS TRY TO COMPILE MARLIN WITH/WITHOUT "ULTIPANEL" / "ULTRALCD" / "SDSUPPORT" #define IN "Configuration.h" 
//   ==> ALSO TRY ALL AVAILABLE "LANGUAGE_CHOICE" OPTIONS

// Languages
// 1  English
// 2  Polish
// 3  French	(awaiting translation!)
// 4  German
// 5  Spanish
// 6  Russian
// 7  Italian
// 8  Portuguese
// 9  Finnish

#ifndef LANGUAGE_CHOICE
#define LANGUAGE_CHOICE 1  // Pick your language from the list above
#endif

#define PROTOCOL_VERSION "1.0"

#if MOTHERBOARD == 7 || MOTHERBOARD == 71
	#define MACHINE_NAME "Ultimaker"
	#define FIRMWARE_URL "http://firmware.ultimaker.com"
#else
	#define MACHINE_NAME "Mendel"
	#define FIRMWARE_URL "http://www.mendel-parts.com"
#endif

#define STRINGIFY_(n) #n
#define STRINGIFY(n) STRINGIFY_(n)

#if LANGUAGE_CHOICE == 1

// LCD Menu Messages
	#define WELCOME_MSG MACHINE_NAME " Ready."
	#define MSG_SD_INSERTED "Card inserted"
	#define MSG_SD_REMOVED "Card removed"
	#define MSG_MAIN "Main"
	#define MSG_AUTOSTART "Autostart"
	#define MSG_DISABLE_STEPPERS "Disable Steppers"
	#define MSG_AUTO_HOME "Auto Home"
	#define MSG_SET_ORIGIN "Set Origin"
	#define MSG_PREHEAT_PLA "Preheat PLA"
	#define MSG_PREHEAT_PLA_SETTINGS "Preheat PLA Conf"
	#define MSG_PREHEAT_ABS "Preheat ABS"
	#define MSG_PREHEAT_ABS_SETTINGS "Preheat ABS Conf"
	#define MSG_COOLDOWN "Cooldown"
	#define MSG_EXTRUDE "Extrude"
	#define MSG_RETRACT "Retract"
	#define MSG_MOVE_AXIS "Move Axis"
	#define MSG_SPEED "Speed"
	#define MSG_NOZZLE "Nozzle"
	#define MSG_NOZZLE1 "Nozzle2"
	#define MSG_NOZZLE2 "Nozzle3"
	#define MSG_BED "Bed"
	#define MSG_FAN_SPEED "Fan speed"
	#define MSG_FLOW "Flow"
	#define MSG_CONTROL "Control"
	#define MSG_MIN " \002 Min"
	#define MSG_MAX " \002 Max"
	#define MSG_FACTOR " \002 Fact"
	#define MSG_AUTOTEMP "Autotemp"
	#define MSG_ON "On "
	#define MSG_OFF "Off"
	#define MSG_PID_P "PID-P"
	#define MSG_PID_I "PID-I"
	#define MSG_PID_D "PID-D"
	#define MSG_PID_C "PID-C"
	#define MSG_ACC  "Accel"
	#define MSG_VXY_JERK "Vxy-jerk"
	#define MSG_VMAX "Vmax "
	#define MSG_X "x"
	#define MSG_Y "y"
	#define MSG_Z "z"
	#define MSG_E "e"
	#define MSG_VMIN "Vmin"
	#define MSG_VTRAV_MIN "VTrav min"
	#define MSG_AMAX "Amax "
	#define MSG_A_RETRACT "A-retract"
	#define MSG_XSTEPS "Xsteps/mm"
	#define MSG_YSTEPS "Ysteps/mm"
	#define MSG_ZSTEPS "Zsteps/mm"
	#define MSG_ESTEPS "Esteps/mm"
	#define MSG_RECTRACT "Rectract"
	#define MSG_TEMPERATURE "Temperature"
	#define MSG_MOTION "Motion"
	#define MSG_STORE_EPROM "Store memory"
	#define MSG_LOAD_EPROM "Load memory"
	#define MSG_RESTORE_FAILSAFE "Restore Failsafe"
	#define MSG_REFRESH "Refresh"
	#define MSG_WATCH "Watch"
	#define MSG_PREPARE "Prepare"
	#define MSG_TUNE "Tune"
	#define MSG_PAUSE_PRINT "Pause Print"
	#define MSG_RESUME_PRINT "Resume Print"
	#define MSG_STOP_PRINT "Stop Print"
	#define MSG_CARD_MENU "Card Menu"
	#define MSG_NO_CARD "No Card"
	#define MSG_DWELL "Sleep..."
	#define MSG_USERWAIT "Wait for user..."
	#define MSG_RESUMING "Resuming print"
	#define MSG_NO_MOVE "No move."
	#define MSG_KILLED "KILLED. "
	#define MSG_STOPPED "STOPPED. "
	#define MSG_CONTROL_RETRACT  "Retract mm"
	#define MSG_CONTROL_RETRACTF "Retract  F"
	#define MSG_CONTROL_RETRACT_ZLIFT "Hop mm"
	#define MSG_CONTROL_RETRACT_RECOVER "UnRet +mm"
	#define MSG_CONTROL_RETRACT_RECOVERF "UnRet  F"
	#define MSG_AUTORETRACT "AutoRetr."
	#define MSG_FILAMENTCHANGE "Change filament"
	#define MSG_INIT_SDCARD "Init. SD-Card"	
	#define MSG_CNG_SDCARD "Change SD-Card"

// Serial Console Messages

	#define MSG_Enqueing "enqueing \""
	#define MSG_POWERUP "PowerUp"
	#define MSG_EXTERNAL_RESET " External Reset"
	#define MSG_BROWNOUT_RESET " Brown out Reset"
	#define MSG_WATCHDOG_RESET " Watchdog Reset"
	#define MSG_SOFTWARE_RESET " Software Reset"
	#define MSG_MARLIN "Marlin "
	#define MSG_AUTHOR " | Author: "
	#define MSG_CONFIGURATION_VER " Last Updated: "
	#define MSG_FREE_MEMORY " Free Memory: "
	#define MSG_PLANNER_BUFFER_BYTES "  PlannerBufferBytes: "
	#define MSG_OK "ok"
	#define MSG_FILE_SAVED "Done saving file."
	#define MSG_ERR_LINE_NO "Line Number is not Last Line Number+1, Last Line: "
	#define MSG_ERR_CHECKSUM_MISMATCH "checksum mismatch, Last Line: "
	#define MSG_ERR_NO_CHECKSUM "No Checksum with line number, Last Line: "
	#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "No Line Number with checksum, Last Line: "
	#define MSG_FILE_PRINTED "Done printing file"
	#define MSG_BEGIN_FILE_LIST "Begin file list"
	#define MSG_END_FILE_LIST "End file list"
	#define MSG_M104_INVALID_EXTRUDER "M104 Invalid extruder "
	#define MSG_M105_INVALID_EXTRUDER "M105 Invalid extruder "
	#define MSG_M218_INVALID_EXTRUDER "M218 Invalid extruder "
	#define MSG_ERR_NO_THERMISTORS "No thermistors - no temperature"
	#define MSG_M109_INVALID_EXTRUDER "M109 Invalid extruder "
	#define MSG_HEATING "Heating..."
	#define MSG_HEATING_COMPLETE "Heating done."
	#define MSG_BED_HEATING "Bed Heating."
	#define MSG_BED_DONE "Bed done."
	#define MSG_M115_REPORT "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
	#define MSG_COUNT_X " Count X: "
	#define MSG_ERR_KILLED "Printer halted. kill() called!"
	#define MSG_ERR_STOPPED "Printer stopped due to errors. Fix the error and use M999 to restart. (Temperature is reset. Set it after restarting)"
	#define MSG_RESEND "Resend: "
	#define MSG_UNKNOWN_COMMAND "Unknown command: \""
	#define MSG_ACTIVE_EXTRUDER "Active Extruder: "
	#define MSG_INVALID_EXTRUDER "Invalid extruder"
	#define MSG_X_MIN "x_min: "
	#define MSG_X_MAX "x_max: "
	#define MSG_Y_MIN "y_min: "
	#define MSG_Y_MAX "y_max: "
	#define MSG_Z_MIN "z_min: "
	#define MSG_Z_MAX "z_max: "
	#define MSG_M119_REPORT "Reporting endstop status"
	#define MSG_ENDSTOP_HIT "TRIGGERED"
	#define MSG_ENDSTOP_OPEN "open"
	#define MSG_HOTEND_OFFSET "Hotend offsets:"

	#define MSG_SD_CANT_OPEN_SUBDIR "Cannot open subdir"
	#define MSG_SD_INIT_FAIL "SD init fail"
	#define MSG_SD_VOL_INIT_FAIL "volume.init failed"
	#define MSG_SD_OPENROOT_FAIL "openRoot failed"
	#define MSG_SD_CARD_OK "SD card ok"
	#define MSG_SD_WORKDIR_FAIL "workDir open failed"
	#define MSG_SD_OPEN_FILE_FAIL "open failed, File: "
	#define MSG_SD_FILE_OPENED "File opened: "
	#define MSG_SD_SIZE " Size: "
	#define MSG_SD_FILE_SELECTED "File selected"
	#define MSG_SD_WRITE_TO_FILE "Writing to file: "
	#define MSG_SD_PRINTING_BYTE "SD printing byte "
	#define MSG_SD_NOT_PRINTING "Not SD printing"
	#define MSG_SD_ERR_WRITE_TO_FILE "error writing to file"
	#define MSG_SD_CANT_ENTER_SUBDIR "Cannot enter subdir: "

	#define MSG_STEPPER_TO_HIGH "Steprate to high: "
	#define MSG_ENDSTOPS_HIT "endstops hit: "
	#define MSG_ERR_COLD_EXTRUDE_STOP " cold extrusion prevented"
	#define MSG_ERR_LONG_EXTRUDE_STOP " too long extrusion prevented"

#endif


#if LANGUAGE_CHOICE == 2

// LCD Menu Messages
	#define WELCOME_MSG MACHINE_NAME " Gotowe."
	#define MSG_SD_INSERTED "Karta wlozona"
	#define MSG_SD_REMOVED "Karta usunieta"
	#define MSG_MAIN "Main"
	#define MSG_AUTOSTART "Autostart"
	#define MSG_DISABLE_STEPPERS "Wylacz silniki"
	#define MSG_AUTO_HOME "Auto. poz. zerowa"
	#define MSG_SET_ORIGIN "Ustaw punkt zerowy"
	#define MSG_PREHEAT_PLA "Rozgrzej PLA"
	#define MSG_PREHEAT_PLA_SETTINGS "Ustawienia roz. PLA"
	#define MSG_PREHEAT_ABS "Rozgrzej ABS"
	#define MSG_PREHEAT_ABS_SETTINGS "Ustawienia roz. ABS"
	#define MSG_COOLDOWN "Chlodzenie"
	#define MSG_EXTRUDE "Ekstruzja"
	#define MSG_RETRACT "Cofanie"
	#define MSG_MOVE_AXIS "Ruch osi"
	#define MSG_SPEED "Predkosc"
	#define MSG_NOZZLE "Dysza"
	#define MSG_NOZZLE1 "Dysza2"
	#define MSG_NOZZLE2 "Dysza3"
	#define MSG_BED "Loze"
	#define MSG_FAN_SPEED "Obroty wiatraka"
	#define MSG_FLOW "Przeplyw"
	#define MSG_CONTROL "Kontrola"
	#define MSG_MIN " \002 Min"
	#define MSG_MAX " \002 Max"
	#define MSG_FACTOR " \002 Mnoznik"
	#define MSG_AUTOTEMP "Auto. temp."
	#define MSG_ON "Wl. "
	#define MSG_OFF "Wyl."
	#define MSG_PID_P "PID-P"
	#define MSG_PID_I "PID-I"
	#define MSG_PID_D "PID-D"
	#define MSG_PID_C "PID-C"
	#define MSG_ACC  "Acc"
	#define MSG_VXY_JERK "Zryw Vxy"
	#define MSG_VMAX "Vmax"
	#define MSG_X "x"
	#define MSG_Y "y"
	#define MSG_Z "z"
	#define MSG_E "e"
	#define MSG_VMIN "Vmin"
	#define MSG_VTRAV_MIN "Vskok min"
	#define MSG_AMAX "Amax"
	#define MSG_A_RETRACT "A-wycofanie"
	#define MSG_XSTEPS "krokiX/mm"
	#define MSG_YSTEPS "krokiY/mm"
	#define MSG_ZSTEPS "krokiZ/mm"
	#define MSG_ESTEPS "krokiE/mm"
	#define MSG_RECTRACT "Wycofanie"
	#define MSG_TEMPERATURE "Temperatura"
	#define MSG_MOTION "Ruch"
	#define MSG_STORE_EPROM "Zapisz w pamieci"
	#define MSG_LOAD_EPROM "Wczytaj z pamieci"
	#define MSG_RESTORE_FAILSAFE " Ustawienia fabryczne"
	#define MSG_REFRESH "\004Odswiez"
	#define MSG_WATCH "Obserwuj"
	#define MSG_PREPARE "Przygotuj"
	#define MSG_CONTROL "Kontroluj"
	#define MSG_TUNE "Strojenie"
	#define MSG_PAUSE_PRINT "Pauza"
	#define MSG_RESUME_PRINT "Wznowienie"
	#define MSG_STOP_PRINT "Stop"
	#define MSG_CARD_MENU "Menu SDCard"
	#define MSG_NO_CARD "Brak karty"
	#define MSG_DWELL "Uspij..."
	#define MSG_USERWAIT "Czekaj na uzytkownika..."
	#define MSG_RESUMING "Wznawiam drukowanie"
	#define MSG_NO_MOVE "Brak ruchu."
	#define MSG_PART_RELEASE "Czesciowe zwolnienie"
	#define MSG_KILLED "Ubity. "
	#define MSG_STOPPED "Zatrzymany. "
	#define MSG_STEPPER_RELEASED "Zwolniony."
	#define MSG_CONTROL_RETRACT  "Wycofaj mm"
	#define MSG_CONTROL_RETRACTF "Wycofaj  F"
	#define MSG_CONTROL_RETRACT_ZLIFT "Skok Z mm:"
	#define MSG_CONTROL_RETRACT_RECOVER "Cof. wycof. +mm"
	#define MSG_CONTROL_RETRACT_RECOVERF "Cof. wycof.  F"
	#define MSG_AUTORETRACT "Auto. wycofanie"
	#define MSG_FILAMENTCHANGE "Change filament"

// Serial Console Messages

	#define MSG_Enqueing "Kolejkowanie \""
	#define MSG_POWERUP "Zasilanie wlaczone"
	#define MSG_EXTERNAL_RESET " Reset (zewnetrzny)"
	#define MSG_BROWNOUT_RESET " Reset (spadek napiecia)"
	#define MSG_WATCHDOG_RESET " Reset (watchdog)"
	#define MSG_SOFTWARE_RESET " Reset (programowy)"
	#define MSG_MARLIN "Marlin "
	#define MSG_AUTHOR " | Autor: "
	#define MSG_CONFIGURATION_VER " Ostatnia aktualizacja: "
	#define MSG_FREE_MEMORY " Wolna pamiec: "
	#define MSG_PLANNER_BUFFER_BYTES "  Bufor planisty krokow (w bajtach): "
	#define MSG_OK "ok"
	#define MSG_FILE_SAVED "Plik zapisany."
	#define MSG_ERR_LINE_NO "Numer linijki nie jest ostatnim numerem linijki+1; ostatnia linijka:"
	#define MSG_ERR_CHECKSUM_MISMATCH "Niezgodna suma kontrolna; ostatnia linijka: "
	#define MSG_ERR_NO_CHECKSUM "Brak sumy kontrolnej w linijce; ostatnia linijka:"
	#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "Brak numery linijki przy sumie kontrolnej; ostatnia linijka:"
	#define MSG_FILE_PRINTED "Ukonczono wydruk z pliku"
	#define MSG_BEGIN_FILE_LIST "Start listy plikow"
	#define MSG_END_FILE_LIST "Koniec listy plikow"
	#define MSG_M104_INVALID_EXTRUDER "M104 Niepoprawny ekstruder "
	#define MSG_M105_INVALID_EXTRUDER "M105 Niepoprawny ekstruder "
	#define MSG_M218_INVALID_EXTRUDER "M218 Niepoprawny ekstruder "
	#define MSG_ERR_NO_THERMISTORS "Brak termistorow - brak temperatury :("
	#define MSG_M109_INVALID_EXTRUDER "M109 Niepoprawny ekstruder "
	#define MSG_HEATING "Nagrzewanie ekstrudera..."
	#define MSG_HEATING_COMPLETE "Nagrzewanie ekstrudera zakonczone."
	#define MSG_BED_HEATING "Nagrzewanie loza..."
	#define MSG_BED_DONE "Nagrzewanie loza zakonczone."
	#define MSG_M115_REPORT "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
	#define MSG_COUNT_X " Liczenie X: "
	#define MSG_ERR_KILLED "Drukarka zatrzymana. Wywolano kill()"
	#define MSG_ERR_STOPPED "Drukarka zatrzymana z powodu bledu. Usun problem i zrestartuj drukartke komenda M999. (temperatura zostala zresetowana; ustaw temperature po restarcie)"
	#define MSG_RESEND "Wyslij ponownie: "
	#define MSG_UNKNOWN_COMMAND "Nieznane polecenie: \""
	#define MSG_ACTIVE_EXTRUDER "Aktywny ekstruder: "
	#define MSG_INVALID_EXTRUDER "Niepoprawny ekstruder"
	#define MSG_X_MIN "x_min: "
	#define MSG_X_MAX "x_max: "
	#define MSG_Y_MIN "y_min: "
	#define MSG_Y_MAX "y_max: "
	#define MSG_Z_MIN "z_min: "
	#define MSG_Z_MAX "z_max: "
	#define MSG_M119_REPORT "Zgloszenie statusu wylacznikow krancowych"
	#define MSG_ENDSTOP_HIT "WYZWOLONY"
	#define MSG_ENDSTOP_OPEN "otwarty"
	#define MSG_HOTEND_OFFSET "Hotend offsets:"

	#define MSG_SD_CANT_OPEN_SUBDIR "Nie mozna otworzyc podkatalogu"
	#define MSG_SD_INIT_FAIL "Blad inicjalizacji karty SD"
	#define MSG_SD_VOL_INIT_FAIL "Blad inizjalizacji wolumenu"
	#define MSG_SD_OPENROOT_FAIL "Blad odczytywania katalogu glownego"
	#define MSG_SD_CARD_OK "Karta SD zainicjalizowana"
	#define MSG_SD_WORKDIR_FAIL "Blad odczytywania katalogu roboczego"
	#define MSG_SD_OPEN_FILE_FAIL "Nie mozna otworzyc pliku: "
	#define MSG_SD_FILE_OPENED "Otwarto plik:"
	#define MSG_SD_SIZE " Rozmiar:"
	#define MSG_SD_FILE_SELECTED "Wybrano plik"
	#define MSG_SD_WRITE_TO_FILE "Zapisywanie do pliku: "
	#define MSG_SD_PRINTING_BYTE "Drukowanie z karty SD, bajt "
	#define MSG_SD_NOT_PRINTING "Nie trwa drukowanie z karty SD"
	#define MSG_SD_ERR_WRITE_TO_FILE "blad podczas zapisu do pliku"
	#define MSG_SD_CANT_ENTER_SUBDIR "Nie mozna odczytac podkatalogu: "

	#define MSG_STEPPER_TO_HIGH "Za duza czestotliwosc krokow: "
	#define MSG_ENDSTOPS_HIT "Wylacznik krancowy zostal wyzwolony na pozycji: "
	#define MSG_ERR_COLD_EXTRUDE_STOP " uniemozliwiono zimna ekstruzje"
	#define MSG_ERR_LONG_EXTRUDE_STOP " uniemozliwiono zbyt dluga ekstruzje"

#endif


#if LANGUAGE_CHOICE == 3

#define WELCOME_MSG MACHINE_NAME " Pret."
#define MSG_SD_INSERTED "Carte inseree"
#define MSG_SD_REMOVED "Carte retiree"
#define MSG_MAIN " Principal \003"
#define MSG_AUTOSTART " Demarrage auto."
#define MSG_DISABLE_STEPPERS " Desactiver moteurs"
#define MSG_AUTO_HOME " Home auto."
#define MSG_SET_ORIGIN " Regler origine"
#define MSG_PREHEAT_PLA " Prechauffage PLA"
#define MSG_PREHEAT_PLA_SETTINGS " Regl. prechauffe PLA"
#define MSG_PREHEAT_ABS " Prechauffage ABS"
#define MSG_PREHEAT_ABS_SETTINGS " Regl. prechauffe ABS"
#define MSG_COOLDOWN " Refroidissement"
#define MSG_EXTRUDE " Extrusion"
#define MSG_RETRACT " Retractation"
#define MSG_PREHEAT_PLA " Prechauffage PLA"
#define MSG_PREHEAT_ABS " Prechauffage ABS"
#define MSG_MOVE_AXIS " Deplacer axe \x7E"
#define MSG_SPEED " Vitesse:"
#define MSG_NOZZLE " \002Buse:"
#define MSG_NOZZLE1 " \002Buse2:"
#define MSG_NOZZLE2 " \002Buse3:"
#define MSG_BED " \002Lit:"
#define MSG_FAN_SPEED " Vitesse ventilateur:"
#define MSG_FLOW " Flux:"
#define MSG_CONTROL " Controle \003"
#define MSG_MIN " \002 Min:"
#define MSG_MAX " \002 Max:"
#define MSG_FACTOR " \002 Facteur:"
#define MSG_AUTOTEMP " Temp. Auto.:"
#define MSG_ON "Marche "
#define MSG_OFF "Arret"
#define MSG_PID_P " PID-P: "
#define MSG_PID_I " PID-I: "
#define MSG_PID_D " PID-D: "
#define MSG_PID_C " PID-C: "
#define MSG_ACC " Acc:"
#define MSG_VXY_JERK " Vxy-jerk: "
#define MSG_VMAX " Vmax "
#define MSG_X "x:"
#define MSG_Y "y:"
#define MSG_Z "z:"
#define MSG_E "e:"
#define MSG_VMIN " Vmin:"
#define MSG_VTRAV_MIN " Vdepl min:"
#define MSG_AMAX " Amax "
#define MSG_A_RETRACT " A-retract:"
#define MSG_XSTEPS " Xpas/mm:"
#define MSG_YSTEPS " Ypas/mm:"
#define MSG_ZSTEPS " Zpas/mm:"
#define MSG_ESTEPS " Epas/mm:"
#define MSG_MAIN_WIDE " Principal \003"
#define MSG_RECTRACT_WIDE " Rectractater \x7E"
#define MSG_TEMPERATURE_WIDE " Temperature \x7E"
#define MSG_TEMPERATURE_RTN " Temperature \003"
#define MSG_MOTION_WIDE " Mouvement \x7E"
#define MSG_STORE_EPROM " Sauvegarder memoire"
#define MSG_LOAD_EPROM " Lire memoire"
#define MSG_RESTORE_FAILSAFE " Restaurer memoire"
#define MSG_REFRESH "\004Actualiser"
#define MSG_WATCH " Surveiller \003"
#define MSG_PREPARE " Preparer \x7E"
#define MSG_PREPARE_ALT " Prepare \003"
#define MSG_CONTROL_ARROW " Controle \x7E"
#define MSG_RETRACT_ARROW " Retracter \x7E"
#define MSG_TUNE " Regler \x7E"
#define MSG_PAUSE_PRINT " Pause impression \x7E"
#define MSG_RESUME_PRINT " Reprendre impression \x7E"
#define MSG_STOP_PRINT " Arreter impression \x7E"
#define MSG_CARD_MENU " Menu carte \x7E"
#define MSG_NO_CARD " Pas de carte"
#define MSG_DWELL "Repos..."
#define MSG_USERWAIT "Attente de l'utilisateur..."
#define MSG_NO_MOVE "Aucun mouvement."
#define MSG_PART_RELEASE "Relache partielle"
#define MSG_KILLED "TUE."
#define MSG_STOPPED "STOPPE."
#define MSG_STEPPER_RELEASED "RELACHE."
#define MSG_CONTROL_RETRACT " Retractation mm:"
#define MSG_CONTROL_RETRACTF " Retractation F:"
#define MSG_CONTROL_RETRACT_ZLIFT " Hop mm:"
#define MSG_CONTROL_RETRACT_RECOVER " UnRet +mm:"
#define MSG_CONTROL_RETRACT_RECOVERF " UnRet F:"
#define MSG_AUTORETRACT " Retract. Auto.:"
#define MSG_FILAMENTCHANGE "Change filament"

// Serial Console Messages

#define MSG_Enqueing "Mise en tampon \""
#define MSG_POWERUP "Allumage"
#define MSG_EXTERNAL_RESET " RAZ Externe"
#define MSG_BROWNOUT_RESET " RAZ defaut alim."
#define MSG_WATCHDOG_RESET " RAZ Watchdog"
#define MSG_SOFTWARE_RESET " RAZ logicielle"
#define MSG_MARLIN "Marlin "
#define MSG_AUTHOR " | Auteur: "
#define MSG_CONFIGURATION_VER " Derniere MaJ: "
#define MSG_FREE_MEMORY " Memoire libre: "
#define MSG_PLANNER_BUFFER_BYTES " PlannerBufferBytes: "
#define MSG_OK "ok"
#define MSG_FILE_SAVED "Fichier enregistre."
#define MSG_ERR_LINE_NO "Le numero de ligne n'est pas la derniere ligne + 1, derniere ligne: "
#define MSG_ERR_CHECKSUM_MISMATCH "Erreur somme de controle, derniere ligne: "
#define MSG_ERR_NO_CHECKSUM "Pas de somme de controle avec le numero de ligne, derniere ligne: "
#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "Pas de numero de ligne avec somme de controle, derniere ligne: "
#define MSG_FILE_PRINTED "Impression terminee"
#define MSG_BEGIN_FILE_LIST "Debut de la liste de fichiers"
#define MSG_END_FILE_LIST "Fin de la liste de fichiers"
#define MSG_M104_INVALID_EXTRUDER "M104 Extruder invalide"
#define MSG_M105_INVALID_EXTRUDER "M105 Extruder invalide"
#define MSG_M218_INVALID_EXTRUDER "M218 Extruder invalide"
#define MSG_ERR_NO_THERMISTORS "Pas de thermistor, pas de temperature"
#define MSG_M109_INVALID_EXTRUDER "M109 Extruder invalide "
#define MSG_HEATING "En chauffe..."
#define MSG_HEATING_COMPLETE "Chauffe terminee."
#define MSG_BED_HEATING "Chauffe du lit."
#define MSG_BED_DONE "Chauffe du lit terminee."
#define MSG_M115_REPORT "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
#define MSG_COUNT_X " Compteur X: "
#define MSG_ERR_KILLED "Impression arretee. kill() appelee!"
#define MSG_ERR_STOPPED "Impression arretee a cause d'erreurs. Corriger les erreurs et utiliser M999 pour la reprendre. (Temperature remise a zero. Reactivez la apres redemarrage)"
#define MSG_RESEND "Renvoie: "
#define MSG_UNKNOWN_COMMAND "Commande inconnue: \""
#define MSG_ACTIVE_EXTRUDER "Extrudeur actif: "
#define MSG_INVALID_EXTRUDER "Extrudeur invalide"
#define MSG_X_MIN "x_min: "
#define MSG_X_MAX "x_max: "
#define MSG_Y_MIN "y_min: "
#define MSG_Y_MAX "y_max: "
#define MSG_Z_MIN "z_min: "
#define MSG_Z_MAX "z_max: "
#define MSG_M119_REPORT "Affichage du status des fin de course"
#define MSG_ENDSTOP_HIT "DECLENCHE"
#define MSG_ENDSTOP_OPEN "OUVERT"
#define MSG_HOTEND_OFFSET "Hotend offsets:"

#define MSG_SD_CANT_OPEN_SUBDIR "Impossible d'ouvrir le sous-repertoire"
#define MSG_SD_INIT_FAIL "Echec de l'initialisation de la SD"
#define MSG_SD_VOL_INIT_FAIL "Echec de volume.init"
#define MSG_SD_OPENROOT_FAIL "Echec openRoot"
#define MSG_SD_CARD_OK "Carte SD Ok"
#define MSG_SD_WORKDIR_FAIL "Echec d'ouverture workDir"
#define MSG_SD_OPEN_FILE_FAIL "Echec d'ouverture, Fichier: "
#define MSG_SD_FILE_OPENED "Fichier ouvert: "
#define MSG_SD_SIZE " Taille: "
#define MSG_SD_FILE_SELECTED "Fichier selectionne"
#define MSG_SD_WRITE_TO_FILE "Ecriture dans le fichier: "
#define MSG_SD_PRINTING_BYTE "Octet impression SD "
#define MSG_SD_NOT_PRINTING "Pas d'impression SD"
#define MSG_SD_ERR_WRITE_TO_FILE "Erreur d'ecriture dans le fichier"
#define MSG_SD_CANT_ENTER_SUBDIR "Impossible d'entrer dans le sous-repertoire: "

#define MSG_STEPPER_TO_HIGH "Steprate trop eleve: "
#define MSG_ENDSTOPS_HIT "Fin de course atteint: "
#define MSG_ERR_COLD_EXTRUDE_STOP " Extrusion a froid evitee"
#define MSG_ERR_LONG_EXTRUDE_STOP " Extrusion longue evitee"
	
#endif


#if LANGUAGE_CHOICE == 4

// LCD Menu Messages

	#define WELCOME_MSG MACHINE_NAME " Bereit."

	#define MSG_SD_INSERTED      "SDKarte erkannt"
	#define MSG_SD_REMOVED       "SDKarte entfernt"
	#define MSG_MAIN             "Hauptmneü"
	#define MSG_AUTOSTART        "Autostart"
	#define MSG_DISABLE_STEPPERS "Stepper abschalten"
	#define MSG_AUTO_HOME        "Auto Nullpunkt"
	#define MSG_SET_ORIGIN       "Setze Nullpunkt"
	#define MSG_PREHEAT_PLA      "Vorwärmen PLA"
	#define MSG_PREHEAT_PLA_SETTINGS "Vorwärmen PLA Einstellungen"
	#define MSG_PREHEAT_ABS      "Vorwärmen ABS"
	#define MSG_PREHEAT_ABS_SETTINGS "Vorwärmen ABS Einstellungen"
	#define MSG_COOLDOWN         "Abkühlen"
	#define MSG_EXTRUDE          "Extrude"
	#define MSG_RETRACT          "Retract"
	#define MSG_MOVE_AXIS        "Achsen bewegen"
	#define MSG_SPEED            "Geschw"
	#define MSG_NOZZLE           "Düse"
	#define MSG_NOZZLE1          "Düse2"
	#define MSG_NOZZLE2          "Düse3"
	#define MSG_BED              "Bett"
	#define MSG_FAN_SPEED        "Lüftergeschw."
	#define MSG_FLOW             "Fluß"
	#define MSG_CONTROL          "Einstellungen"
	#define MSG_MIN              "\002 Min"
	#define MSG_MAX              "\002 Max"
	#define MSG_FACTOR           "\002 Faktor"
	#define MSG_AUTOTEMP         "AutoTemp"
	#define MSG_ON               "Ein"
	#define MSG_OFF              "Aus"
	#define MSG_PID_P            "PID-P"
	#define MSG_PID_I            "PID-I"
	#define MSG_PID_D            "PID-D"
	#define MSG_PID_C            "PID-C"
	#define MSG_ACC              "Acc"
	#define MSG_VXY_JERK         "Vxy-jerk"
	#define MSG_VMAX             "Vmax "
	#define MSG_X                "x"
	#define MSG_Y                "y"
	#define MSG_Z                "z"
	#define MSG_E                "e"
	#define MSG_VMIN             "Vmin"
	#define MSG_VTRAV_MIN        "VTrav min"
	#define MSG_AMAX             "Amax "
	#define MSG_A_RETRACT        "A-Retract"
	#define MSG_XSTEPS           "Xsteps/mm"
	#define MSG_YSTEPS           "Ysteps/mm"
	#define MSG_ZSTEPS           "Zsteps/mm"
	#define MSG_ESTEPS           "Esteps/mm"
	#define MSG_RECTRACT_WIDE    "Rectract"
	#define MSG_WATCH            "Beobachten"
	#define MSG_TEMPERATURE      "Temperatur"
	#define MSG_MOTION           "Bewegung"
	#define MSG_STORE_EPROM      "EPROM speichern"
	#define MSG_LOAD_EPROM       "EPROM laden"
	#define MSG_RESTORE_FAILSAFE "Standardkonfig."
	#define MSG_REFRESH          "Aktualisieren"
	#define MSG_PREPARE          "Vorbereitung"
	#define MSG_CONTROL          "Einstellungen"
	#define MSG_TUNE             "Justierung"
	#define MSG_PAUSE_PRINT      "Druck anhalten"
	#define MSG_RESUME_PRINT     "Druck fortsetz"
	#define MSG_STOP_PRINT       "Druck stoppen"
	#define MSG_CARD_MENU        "SDKarten Menü"
	#define MSG_NO_CARD          "Keine SDKarte"
	#define MSG_DWELL            "Warten..."		
	#define MSG_USERWAIT         "Warte auf Nutzer..."
    #define MSG_RESUMING         "Druck fortsetzung"
	#define MSG_NO_MOVE          "Kein Zug."
	#define MSG_PART_RELEASE     "Stepper tlw frei"
	#define MSG_KILLED           "KILLED"
	#define MSG_STOPPED          "GESTOPPT"
	#define MSG_STEPPER_RELEASED "Stepper frei"
    #define MSG_CONTROL_RETRACT  "Retract mm"
    #define MSG_CONTROL_RETRACTF "Retract  F"
    #define MSG_CONTROL_RETRACT_ZLIFT "Hop mm"
    #define MSG_CONTROL_RETRACT_RECOVER "UnRet +mm"
    #define MSG_CONTROL_RETRACT_RECOVERF "UnRet  F"
    #define MSG_AUTORETRACT      "AutoRetr."
    #define MSG_FILAMENTCHANGE "Filament wechseln"
	
// Serial Console Messages

	#define MSG_Enqueing "enqueing \""
	#define MSG_POWERUP "PowerUp"
	#define MSG_EXTERNAL_RESET " External Reset"
	#define MSG_BROWNOUT_RESET " Brown out Reset"
	#define MSG_WATCHDOG_RESET " Watchdog Reset"
	#define MSG_SOFTWARE_RESET " Software Reset"
	#define MSG_MARLIN "Marlin: "
	#define MSG_AUTHOR " | Author: "
	#define MSG_CONFIGURATION_VER " Last Updated: "
	#define MSG_FREE_MEMORY " Free Memory: "
	#define MSG_PLANNER_BUFFER_BYTES "  PlannerBufferBytes: "
	#define MSG_OK "ok"
	#define MSG_FILE_SAVED "Done saving file."
	#define MSG_ERR_LINE_NO "Line Number is not Last Line Number+1, Last Line:"
	#define MSG_ERR_CHECKSUM_MISMATCH "checksum mismatch, Last Line:"
	#define MSG_ERR_NO_CHECKSUM "No Checksum with line number, Last Line:"
	#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "No Line Number with checksum, Last Line:"
	#define MSG_FILE_PRINTED "Done printing file"
	#define MSG_BEGIN_FILE_LIST "Begin file list"
	#define MSG_END_FILE_LIST "End file list"
	#define MSG_M104_INVALID_EXTRUDER "M104 Invalid extruder "
	#define MSG_M105_INVALID_EXTRUDER "M105 Invalid extruder "
	#define MSG_M218_INVALID_EXTRUDER "M218 Invalid extruder "
	#define MSG_ERR_NO_THERMISTORS "No thermistors - no temp"
	#define MSG_M109_INVALID_EXTRUDER "M109 Invalid extruder "
	#define MSG_HEATING "Heating..."
	#define MSG_HEATING_COMPLETE "Heating done."
	#define MSG_BED_HEATING "Bed Heating."
	#define MSG_BED_DONE "Bed done."
	#define MSG_M115_REPORT "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
	#define MSG_COUNT_X " Count X:"
	#define MSG_ERR_KILLED "Printer halted. kill() called !!"
	#define MSG_ERR_STOPPED "Printer stopped due to errors. Fix the error and use M999 to restart!"
	#define MSG_RESEND "Resend:"
	#define MSG_UNKNOWN_COMMAND "Unknown command:\""
	#define MSG_ACTIVE_EXTRUDER "Active Extruder: "
	#define MSG_INVALID_EXTRUDER "Invalid extruder"
	#define MSG_X_MIN "x_min: "
	#define MSG_X_MAX "x_max: "
	#define MSG_Y_MIN "y_min: "
	#define MSG_Y_MAX "y_max: "
	#define MSG_Z_MIN "z_min: "
	#define MSG_Z_MAX "z_max: "
	#define MSG_M119_REPORT "Reporting endstop status"
	#define MSG_ENDSTOP_HIT "TRIGGERED"
	#define MSG_ENDSTOP_OPEN "open"
	#define MSG_HOTEND_OFFSET "Hotend offsets:"

	#define MSG_SD_CANT_OPEN_SUBDIR "Cannot open subdir"
	#define MSG_SD_INIT_FAIL "SD init fail"
	#define MSG_SD_VOL_INIT_FAIL "volume.init failed"
	#define MSG_SD_OPENROOT_FAIL "openRoot failed"
	#define MSG_SD_CARD_OK "SD card ok"
	#define MSG_SD_WORKDIR_FAIL "workDir open failed"
	#define MSG_SD_OPEN_FILE_FAIL "open failed, File: "
	#define MSG_SD_FILE_OPENED "File opened:"
	#define MSG_SD_SIZE " Size:"
	#define MSG_SD_FILE_SELECTED "File selected"
	#define MSG_SD_WRITE_TO_FILE "Writing to file: "
	#define MSG_SD_PRINTING_BYTE "SD printing byte "
	#define MSG_SD_NOT_PRINTING "Not SD printing"
	#define MSG_SD_ERR_WRITE_TO_FILE "error writing to file"
	#define MSG_SD_CANT_ENTER_SUBDIR "Cannot enter subdir:"

	#define MSG_STEPPER_TO_HIGH "Steprate to high : "
	#define MSG_ENDSTOPS_HIT "endstops hit: "
	#define MSG_ERR_COLD_EXTRUDE_STOP " cold extrusion prevented"
	#define MSG_ERR_LONG_EXTRUDE_STOP " too long extrusion prevented"

#endif


#if LANGUAGE_CHOICE == 5

// LCD Menu Messages
#define WELCOME_MSG MACHINE_NAME " Lista."
#define MSG_SD_INSERTED "Tarjeta SD Colocada"
#define MSG_SD_REMOVED "Tarjeta SD Retirada"
#define MSG_MAIN " Menu Principal \003"
#define MSG_AUTOSTART " Autostart"
#define MSG_DISABLE_STEPPERS " Apagar Motores"
#define MSG_AUTO_HOME " Llevar Ejes al Cero"
#define MSG_SET_ORIGIN " Establecer Cero"
#define MSG_COOLDOWN " Enfriar"
#define MSG_EXTRUDE " Extruir"
#define MSG_RETRACT " Retraer"
#define MSG_PREHEAT_PLA " Precalentar PLA"
#define MSG_PREHEAT_PLA_SETTINGS " Ajustar temp. PLA"
#define MSG_PREHEAT_ABS " Precalentar ABS"
#define MSG_PREHEAT_ABS_SETTINGS " Ajustar temp. ABS"
#define MSG_MOVE_AXIS " Mover Ejes      \x7E"
#define MSG_SPEED " Velocidad:"
#define MSG_NOZZLE " \002Nozzle:"
#define MSG_NOZZLE1 " \002Nozzle2:"
#define MSG_NOZZLE2 " \002Nozzle3:"
#define MSG_BED " \002Base:"
#define MSG_FAN_SPEED " Ventilador:"
#define MSG_FLOW " Flujo:"
#define MSG_CONTROL " Control \003"
#define MSG_MIN " \002 Min:"
#define MSG_MAX " \002 Max:"
#define MSG_FACTOR " \002 Fact:"
#define MSG_AUTOTEMP " Autotemp:"
#define MSG_ON "On "
#define MSG_OFF "Off"
#define MSG_PID_P " PID-P: "
#define MSG_PID_I " PID-I: "
#define MSG_PID_D " PID-D: "
#define MSG_PID_C " PID-C: "
#define MSG_ACC  " Acc:"
#define MSG_VXY_JERK " Vxy-jerk: "
#define MSG_VMAX " Vmax "
#define MSG_X "x:"
#define MSG_Y "y:"
#define MSG_Z "z:"
#define MSG_E "e:"
#define MSG_VMIN " Vmin:"
#define MSG_VTRAV_MIN " VTrav min:"
#define MSG_AMAX " Amax "
#define MSG_A_RETRACT " A-retrac.:"
#define MSG_XSTEPS " Xpasos/mm:"
#define MSG_YSTEPS " Ypasos/mm:"
#define MSG_ZSTEPS " Zpasos/mm:"
#define MSG_ESTEPS " Epasos/mm:"
#define MSG_MAIN_WIDE " Menu Principal  \003"
#define MSG_RECTRACT_WIDE " Retraer         \x7E"
#define MSG_TEMPERATURE_WIDE " Temperatura     \x7E"
#define MSG_TEMPERATURE_RTN  " Temperatura     \003"
#define MSG_MOTION_WIDE " Movimiento      \x7E"
#define MSG_STORE_EPROM " Guardar Memoria"
#define MSG_LOAD_EPROM " Cargar Memoria"
#define MSG_RESTORE_FAILSAFE " Rest. de emergencia"
#define MSG_REFRESH "\004Volver a cargar"
#define MSG_WATCH " Monitorizar \003"
#define MSG_PREPARE " Preparar \x7E"
#define MSG_PREPARE_ALT " Preparar \003"
#define MSG_CONTROL_ARROW " Control  \x7E"
#define MSG_RETRACT_ARROW " Retraer  \x7E"
#define MSG_TUNE " Ajustar \x7E"
#define MSG_PAUSE_PRINT " Pausar Impresion \x7E"
#define MSG_RESUME_PRINT " Reanudar Impresion \x7E"
#define MSG_STOP_PRINT " Detener Impresion \x7E"
#define MSG_CARD_MENU " Menu de SD    \x7E"
#define MSG_NO_CARD " No hay Tarjeta SD"
#define MSG_DWELL "Reposo..."
#define MSG_USERWAIT "Esperando Ordenes..."
#define MSG_NO_MOVE "Sin movimiento"
#define MSG_PART_RELEASE "Desacople Parcial"
#define MSG_KILLED "PARADA DE EMERGENCIA. "
#define MSG_STOPPED "PARADA. "
#define MSG_STEPPER_RELEASED "Desacoplada."
#define MSG_CONTROL_RETRACT  " Retraer mm:"
#define MSG_CONTROL_RETRACTF " Retraer  F:"
#define MSG_CONTROL_RETRACT_ZLIFT " Levantar mm:"
#define MSG_CONTROL_RETRACT_RECOVER " DesRet +mm:"
#define MSG_CONTROL_RETRACT_RECOVERF " DesRet F:"
#define MSG_AUTORETRACT " AutoRetr.:"
#define MSG_FILAMENTCHANGE "Change filament"
// Serial Console Messages

#define MSG_Enqueing "En cola \""
#define MSG_POWERUP "PowerUp"
#define MSG_EXTERNAL_RESET " Reset Externo"
#define MSG_BROWNOUT_RESET " Reset por Voltaje Incorrecto"
#define MSG_WATCHDOG_RESET " Reset por Bloqueo"
#define MSG_SOFTWARE_RESET " Reset por Software"
#define MSG_MARLIN "Marlin "
#define MSG_AUTHOR " | Autor: "
#define MSG_CONFIGURATION_VER " Ultima actualizacion: "
#define MSG_FREE_MEMORY " Memoria libre: "
#define MSG_PLANNER_BUFFER_BYTES "  PlannerBufferBytes: "
#define MSG_OK "ok"
#define MSG_FILE_SAVED "Guardado."
#define MSG_ERR_LINE_NO "El Numero de Linea no es igual al Ultimo Numero de Linea+1, Ultima Linea:"
#define MSG_ERR_CHECKSUM_MISMATCH "el checksum no coincide, Ultima Linea:"
#define MSG_ERR_NO_CHECKSUM "No se pudo hallar el Checksum con el numero de linea, Ultima Linea:"
#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "No se hallo el Numero de Linea con el Checksum, Ultima Linea:"
#define MSG_FILE_PRINTED "Impresion terminada"
#define MSG_BEGIN_FILE_LIST "Comienzo de la lista de archivos"
#define MSG_END_FILE_LIST "Fin de la lista de archivos"
#define MSG_M104_INVALID_EXTRUDER "M104 Extrusor Invalido "
#define MSG_M105_INVALID_EXTRUDER "M105 Extrusor Invalido "
#define MSG_M218_INVALID_EXTRUDER "M218 Extrusor Invalido "
#define MSG_ERR_NO_THERMISTORS "No hay termistores - no temp"
#define MSG_M109_INVALID_EXTRUDER "M109 Extrusor Invalido "
#define MSG_HEATING "Calentando..."
#define MSG_HEATING_COMPLETE "Calentamiento Hecho."
#define MSG_BED_HEATING "Calentando la base."
#define MSG_BED_DONE "Base Caliente."
#define MSG_M115_REPORT "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
#define MSG_COUNT_X " Cuenta X:"
#define MSG_ERR_KILLED "¡¡Impresora Parada con kill()!!"
#define MSG_ERR_STOPPED "¡Impresora parada por errores. Arregle el error y use M999 Para reiniciar!. (La temperatura se reestablece. Ajustela antes de continuar)"
#define MSG_RESEND "Reenviar:"
#define MSG_UNKNOWN_COMMAND "Comando Desconocido:\""
#define MSG_ACTIVE_EXTRUDER "Extrusor Activo: "
#define MSG_INVALID_EXTRUDER "Extrusor Invalido"
#define MSG_X_MIN "x_min: "
#define MSG_X_MAX "x_max: "
#define MSG_Y_MIN "y_min: "
#define MSG_Y_MAX "y_max: "
#define MSG_Z_MIN "z_min: "
#define MSG_M119_REPORT "Comprobando fines de carrera."
#define MSG_ENDSTOP_HIT "PULSADO"
#define MSG_ENDSTOP_OPEN "abierto"
#define MSG_HOTEND_OFFSET "Hotend offsets:"
        
#define MSG_SD_CANT_OPEN_SUBDIR "No se pudo abrir la subcarpeta."
#define MSG_SD_INIT_FAIL "Fallo al iniciar la SD"
#define MSG_SD_VOL_INIT_FAIL "Fallo al montar el volumen"
#define MSG_SD_OPENROOT_FAIL "Fallo al abrir la carpeta raiz"
#define MSG_SD_CARD_OK "Tarjeta SD OK"
#define MSG_SD_WORKDIR_FAIL "Fallo al abrir la carpeta de trabajo"
#define MSG_SD_OPEN_FILE_FAIL "Error al abrir, Archivo: "
#define MSG_SD_FILE_OPENED "Archivo abierto:"
#define MSG_SD_SIZE " Tamaño:"
#define MSG_SD_FILE_SELECTED "Archivo Seleccionado"
#define MSG_SD_WRITE_TO_FILE "Escribiendo en el archivo: "
#define MSG_SD_PRINTING_BYTE "SD imprimiendo el byte "
#define MSG_SD_NOT_PRINTING "No se esta imprimiendo con SD"
#define MSG_SD_ERR_WRITE_TO_FILE "Error al escribir en el archivo"
#define MSG_SD_CANT_ENTER_SUBDIR "No se puede abrir la carpeta:"

#define MSG_STEPPER_TO_HIGH "Steprate demasiado alto : "
#define MSG_ENDSTOPS_HIT "Se ha tocado el fin de carril: "
#define MSG_ERR_COLD_EXTRUDE_STOP " extrusion fria evitada"
#define MSG_ERR_LONG_EXTRUDE_STOP " extrusion demasiado larga evitada"

#endif

#if LANGUAGE_CHOICE == 6

// LCD Menu Messages
#define WELCOME_MSG MACHINE_NAME			" Готов"
#define MSG_SD_INSERTED						"Карта вставлена"
#define MSG_SD_REMOVED						"Карта извлечена"
#define MSG_MAIN							" Меню              \003"
#define MSG_AUTOSTART						" Автостарт          "
#define MSG_DISABLE_STEPPERS				" Выключить двигатели"
#define MSG_AUTO_HOME						" Парковка           "
#define MSG_SET_ORIGIN						" Запомнить ноль     "
#define MSG_PREHEAT_PLA						" Преднагрев PLA     "
#define MSG_PREHEAT_PLA_SETTINGS			" Настр. преднагр.PLA"
#define MSG_PREHEAT_ABS						" Преднагрев ABS     "
#define MSG_PREHEAT_ABS_SETTINGS			" Настр. преднагр.ABS"
#define MSG_COOLDOWN						" Охлаждение         "
#define MSG_EXTRUDE							" Экструзия          "
#define MSG_RETRACT							" Откат"
#define MSG_MOVE_AXIS						" Движение по осям  \x7E"
#define MSG_SPEED							" Скорость:"
#define MSG_NOZZLE							" \002 Фильера:"
#define MSG_NOZZLE1							" \002 Фильера2:"
#define MSG_NOZZLE2							" \002 Фильера3:"
#define MSG_BED								" \002 Кровать:"
#define MSG_FAN_SPEED						" Куллер:"
#define MSG_FLOW							" Поток:"
#define MSG_CONTROL							" Настройки \003"
#define MSG_MIN								" \002 Минимум:"
#define MSG_MAX								" \002 Максимум:"
#define MSG_FACTOR							" \002 Фактор:"
#define MSG_AUTOTEMP						" Autotemp:"
#define MSG_ON								"Вкл. "
#define MSG_OFF								"Выкл. "
#define MSG_PID_P							" PID-P: "
#define MSG_PID_I							" PID-I: "
#define MSG_PID_D							" PID-D: "
#define MSG_PID_C							" PID-C: "
#define MSG_ACC								" Acc:"
#define MSG_VXY_JERK						" Vxy-jerk: "
#define MSG_VMAX							" Vmax "
#define MSG_X								"x:"
#define MSG_Y								"y:"
#define MSG_Z								"z:"
#define MSG_E								"e:"
#define MSG_VMIN							" Vmin:"
#define MSG_VTRAV_MIN						" VTrav min:"
#define MSG_AMAX							" Amax "
#define MSG_A_RETRACT						" A-retract:"
#define MSG_XSTEPS							" X шаг/mm:"
#define MSG_YSTEPS							" Y шаг/mm:"
#define MSG_ZSTEPS							" Z шаг/mm:"
#define MSG_ESTEPS							" E шаг/mm:"
#define MSG_RECTRACT    					" Откат подачи      \x7E"
#define MSG_TEMPERATURE  				" Температура       \x7E"
#define MSG_MOTION						" Скорости          \x7E"
#define MSG_STORE_EPROM						" Сохранить настройки"
#define MSG_LOAD_EPROM						" Загрузить настройки"
#define MSG_RESTORE_FAILSAFE				" Сброс настроек     "
#define MSG_REFRESH							"\004Обновить           "
#define MSG_WATCH							" Обзор             \003"
#define MSG_PREPARE							" Действия          \x7E"
#define MSG_TUNE					" Настройки         \x7E"
#define MSG_PAUSE_PRINT						" Пауза печати      \x7E"
#define MSG_RESUME_PRINT					" Продолжить печать \x7E"
#define MSG_STOP_PRINT						" Остановить печать \x7E"
#define MSG_CARD_MENU						" Меню карты        \x7E"
#define MSG_NO_CARD							" Нет карты"
#define MSG_DWELL							"Сон..."
#define MSG_USERWAIT						"Нажмите для продолж."
#define MSG_NO_MOVE							"Нет движения.       "
#define MSG_PART_RELEASE					" Извлечение принта  "
#define MSG_KILLED							"УБИТО. "
#define MSG_STOPPED							"ОСТАНОВЛЕНО. "
#define MSG_CONTROL_RETRACT					" Откат mm:"
#define MSG_CONTROL_RETRACTF				" Откат  F:"
#define MSG_CONTROL_RETRACT_ZLIFT			" Прыжок mm:"
#define MSG_CONTROL_RETRACT_RECOVER			" Возврат +mm:"
#define MSG_CONTROL_RETRACT_RECOVERF		" Возврат  F:"
#define MSG_AUTORETRACT						" АвтоОткат:"
#define MSG_FILAMENTCHANGE "Change filament"

// Serial Console Messages

#define MSG_Enqueing						"Запланировано \""
#define MSG_POWERUP							"Включение питания"
#define MSG_EXTERNAL_RESET					" Внешний сброс"
#define MSG_BROWNOUT_RESET					" Brown out сброс"
#define MSG_WATCHDOG_RESET					" Watchdog сброс"
#define MSG_SOFTWARE_RESET					" программный сброс"
#define MSG_MARLIN							"Marlin "
#define MSG_AUTHOR							" | Автор: "
#define MSG_CONFIGURATION_VER				" Последнее обновление: "
#define MSG_FREE_MEMORY						" Памяти свободно: "
#define MSG_PLANNER_BUFFER_BYTES			"  Буффер очереди команд Bytes: "
#define MSG_OK								"ok"
#define MSG_FILE_SAVED						"Файл записан."
#define MSG_ERR_LINE_NO						"Номен строки это не последняя строка+1, последняя строка:"
#define MSG_ERR_CHECKSUM_MISMATCH			"контрольная сумма не совпадает, последняя строка:"
#define MSG_ERR_NO_CHECKSUM					"нет контрольной суммы для строки, последняя строка:"
#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM	"нет строки для контрольной суммы, последняя строка:"
#define MSG_FILE_PRINTED					"Печать файла завершена"
#define MSG_BEGIN_FILE_LIST					"Список файлов"
#define MSG_END_FILE_LIST					"Конец списка файлов"
#define MSG_M104_INVALID_EXTRUDER			"M104 ошибка экструдера "
#define MSG_M105_INVALID_EXTRUDER			"M105 ошибка экструдера "
#define MSG_M218_INVALID_EXTRUDER			"M218 ошибка экструдера "
#define MSG_ERR_NO_THERMISTORS				"Нет термистра - нет температуры"
#define MSG_M109_INVALID_EXTRUDER			"M109 ошибка экструдера "
#define MSG_HEATING							"Нагрев...  "
#define MSG_HEATING_COMPLETE				"Наргето.    "
#define MSG_BED_HEATING						"Нагрев стола...     "
#define MSG_BED_DONE						"Стол нагрет.        "
#define MSG_M115_REPORT						"FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
#define MSG_COUNT_X							" Count X:"
#define MSG_ERR_KILLED						"Принтер остановлен. вызов kill() !!"
#define MSG_ERR_STOPPED						"Ошибка принтера, останов. Устраните неисправность и используйте M999 для перезагрузки!. (Температура недоступна. Проверьте датчики)"
#define MSG_RESEND							"Переотправка:"
#define MSG_UNKNOWN_COMMAND					"Неизвестная команда:\""
#define MSG_ACTIVE_EXTRUDER					"Активный экструдер: "
#define MSG_INVALID_EXTRUDER				"Ошибка экструдера"
#define MSG_X_MIN							"x_min:"
#define MSG_X_MAX							"x_max:"
#define MSG_Y_MIN							"y_min:"
#define MSG_Y_MAX							"y_max:"
#define MSG_Z_MIN							"z_min:"
#define MSG_Z_MAX							"z_max:"
#define MSG_M119_REPORT						"Статус концевиков"
#define MSG_ENDSTOP_HIT						"Срабатывание концевика"
#define MSG_ENDSTOP_OPEN					"Концевик освобожден"
#define MSG_HOTEND_OFFSET					"Hotend offsets:"
#define MSG_SD_CANT_OPEN_SUBDIR				"Не открыть папку"
#define MSG_SD_INIT_FAIL					"Ошибка инициализации SD"
#define MSG_SD_VOL_INIT_FAIL				"Ошибка инициализации раздела"
#define MSG_SD_OPENROOT_FAIL				"Не прочесть содержимое корня"
#define MSG_SD_CARD_OK						"SD карта в порядке"
#define MSG_SD_WORKDIR_FAIL					"не открыть рабочую папку"
#define MSG_SD_OPEN_FILE_FAIL				"Ошибка чтения, файл: "
#define MSG_SD_FILE_OPENED					"Файл открыт:"
#define MSG_SD_SIZE							" Размер:"
#define MSG_SD_FILE_SELECTED				"Файл выбран"
#define MSG_SD_WRITE_TO_FILE				"Запись в файл: "
#define MSG_SD_PRINTING_BYTE				"SD печать byte "
#define MSG_SD_NOT_PRINTING					"нет SD печати"
#define MSG_SD_ERR_WRITE_TO_FILE			"ошибка записи в файл"
#define MSG_SD_CANT_ENTER_SUBDIR			"Не зайти в папку:"
#define MSG_STEPPER_TO_HIGH					"Частота шагов очень высока : "
#define MSG_ENDSTOPS_HIT					"концевик сработал: "
#define MSG_ERR_COLD_EXTRUDE_STOP			" защита холодной экструзии"
#define MSG_ERR_LONG_EXTRUDE_STOP			" защита превышения длинны экструзии"

#endif


#if LANGUAGE_CHOICE == 7

	// LCD Menu Messages
	#define WELCOME_MSG MACHINE_NAME " Pronto."
	#define MSG_SD_INSERTED          "SD Card inserita"
	#define MSG_SD_REMOVED           "SD Card rimossa"
	#define MSG_MAIN                 "Menu principale"
	#define MSG_AUTOSTART            "Autostart"
	#define MSG_DISABLE_STEPPERS     "Disabilita Motori"
	#define MSG_AUTO_HOME            "Auto Home"
	#define MSG_SET_ORIGIN           "Imposta Origine"
	#define MSG_PREHEAT_PLA          "Preriscalda PLA"
	#define MSG_PREHEAT_PLA_SETTINGS "Preris. PLA Conf"
	#define MSG_PREHEAT_ABS          "Preriscalda ABS"
	#define MSG_PREHEAT_ABS_SETTINGS "Preris. ABS Conf"
	#define MSG_COOLDOWN             "Rafredda"
	#define MSG_EXTRUDE              "Estrudi"
	#define MSG_RETRACT              "Ritrai"
	#define MSG_MOVE_AXIS            "Muovi Asse"
	#define MSG_SPEED                "Velcità"
	#define MSG_NOZZLE               "Ugello"
	#define MSG_NOZZLE1              "Ugello2"
	#define MSG_NOZZLE2              "Ugello3"
	#define MSG_BED                  "Piatto"
	#define MSG_FAN_SPEED            "Ventola"
	#define MSG_FLOW                 "Flusso"
	#define MSG_CONTROL              "Controllo"
	#define MSG_MIN                  " \002 Min:"
	#define MSG_MAX                  " \002 Max:"
	#define MSG_FACTOR               " \002 Fact:"
	#define MSG_AUTOTEMP             "Autotemp"
	#define MSG_ON                   "On "
	#define MSG_OFF                  "Off"
	#define MSG_PID_P                "PID-P"
	#define MSG_PID_I                "PID-I"
	#define MSG_PID_D                "PID-D"
	#define MSG_PID_C                "PID-C"
	#define MSG_ACC                  "Accel"
	#define MSG_VXY_JERK             "Vxy-jerk"
	#define MSG_VMAX                 "Vmax"
	#define MSG_X                    "x"
	#define MSG_Y                    "y"
	#define MSG_Z                    "z"
	#define MSG_E                    "e"
	#define MSG_VMIN                 "Vmin"
	#define MSG_VTRAV_MIN            "VTrav min"
	#define MSG_AMAX                 "Amax"
	#define MSG_A_RETRACT            "A-retract"
	#define MSG_XSTEPS               "Xpassi/mm"
	#define MSG_YSTEPS               "Ypassi/mm"
	#define MSG_ZSTEPS               "Zpassi/mm"
	#define MSG_ESTEPS               "Epassi/mm"
	#define MSG_RECTRACT             "Ritrai"
	#define MSG_TEMPERATURE          "Temperatura"
	#define MSG_MOTION               "Movimento"
	#define MSG_STORE_EPROM          "Salva in EEPROM"
	#define MSG_LOAD_EPROM           "Carica da EEPROM"
	#define MSG_RESTORE_FAILSAFE     "Impostaz. default"
	#define MSG_REFRESH              "Aggiorna"
	#define MSG_WATCH                "Guarda"
	#define MSG_PREPARE              "Prepara"
	#define MSG_TUNE                 "Adatta"
	#define MSG_PAUSE_PRINT          "Pausa"
	#define MSG_RESUME_PRINT         "Riprendi Stampa"
	#define MSG_STOP_PRINT           "Arresta Stampa"
	#define MSG_CARD_MENU            "SD Card Menu"
	#define MSG_NO_CARD              "No SD Card"
	#define MSG_DWELL                "Sospensione..."
	#define MSG_USERWAIT             "Attendi Utente..."
	#define MSG_RESUMING             "Riprendi Stampa"
	#define MSG_NO_MOVE              "Nessun Movimento."
	#define MSG_KILLED               "UCCISO. "
	#define MSG_STOPPED              "ARRESTATO. "
	#define MSG_CONTROL_RETRACT      "Ritrai mm"
	#define MSG_CONTROL_RETRACTF     "Ritrai  F"
	#define MSG_CONTROL_RETRACT_ZLIFT "Salta mm"
	#define MSG_CONTROL_RETRACT_RECOVER "UnRet +mm"
	#define MSG_CONTROL_RETRACT_RECOVERF "UnRet  F"
	#define MSG_AUTORETRACT          "AutoArretramento"
	#define MSG_SERIAL_ERROR_MENU_STRUCTURE "Qualcosa non va in MenuStructure."
	#define MSG_FILAMENTCHANGE       "Cambia filamento"
	#define MSG_INIT_SDCARD          "Iniz. SD-Card"
	#define MSG_CNG_SDCARD           "Cambia SD-Card"

	// Serial Console Messages

	#define MSG_Enqueing             "accodamento \""
	#define MSG_POWERUP              "Accensione"
	#define MSG_EXTERNAL_RESET       " Reset Esterno"
	#define MSG_BROWNOUT_RESET       " Brown out Reset"
	#define MSG_WATCHDOG_RESET       " Watchdog Reset"
	#define MSG_SOFTWARE_RESET       " Software Reset"
	#define MSG_MARLIN               "Marlin "
	#define MSG_AUTHOR               " | Autore: "
	#define MSG_CONFIGURATION_VER    " Ultimo Aggiornamento: "
	#define MSG_FREE_MEMORY          " Memoria Libera: "
	#define MSG_PLANNER_BUFFER_BYTES "  PlannerBufferBytes: "
	#define MSG_OK                   "ok"
	#define MSG_FILE_SAVED           "File Salvato."
	#define MSG_ERR_LINE_NO          "Il Numero della Linea non corrisponde al Numero dell'Ultima Linea+1, Ultima Linea: "
	#define MSG_ERR_CHECKSUM_MISMATCH "checksum non corrispondente, Ultima Linea: "
	#define MSG_ERR_NO_CHECKSUM      "Nessun Checksum con Numero di Linea, Ultima Linea: "
	#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "Nessun Numero di Linea con Checksum, Ultima Linea: "
	#define MSG_FILE_PRINTED         "File stampato"
	#define MSG_BEGIN_FILE_LIST      "Inizio Lista File"
	#define MSG_END_FILE_LIST        "Fine Lista File"
	#define MSG_M104_INVALID_EXTRUDER "M104 Estrusore non valido "
	#define MSG_M105_INVALID_EXTRUDER "M105 Estrusore non valido "
	#define MSG_M218_INVALID_EXTRUDER "M218 Estrusore non valido "
	#define MSG_ERR_NO_THERMISTORS   "Nessun Termistore - nessuna temperatura"
	#define MSG_M109_INVALID_EXTRUDER "M109 Estrusore non valido "
	#define MSG_HEATING              "Riscaldamento..."
	#define MSG_HEATING_COMPLETE     "Stampante Calda."
	#define MSG_BED_HEATING          "Riscaldamento Piatto."
	#define MSG_BED_DONE             "Piatto Pronto."
	#define MSG_M115_REPORT          "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
	#define MSG_COUNT_X              " Calcola X: "
	#define MSG_ERR_KILLED           "Stampante Calda. kill() chiamata !!"
	#define MSG_ERR_STOPPED          "Stampante fermata a causa di errori. Risolvi l'errore e usa M999 per ripartire!. (Reset temperatura. Impostala prima di ripartire)"
	#define MSG_RESEND               "Reinviato:"
	#define MSG_UNKNOWN_COMMAND      "Comando sconosciuto: \""
	#define MSG_ACTIVE_EXTRUDER      "Attiva Estrusore: "
	#define MSG_INVALID_EXTRUDER     "Estrusore non valido"
	#define MSG_X_MIN                "x_min: "
	#define MSG_X_MAX                "x_max: "
	#define MSG_Y_MIN                "y_min: "
	#define MSG_Y_MAX                "y_max: "
	#define MSG_Z_MIN                "z_min: "
	#define MSG_Z_MAX                "z_max: "
	#define MSG_M119_REPORT          "Segnalazione stato degli endstop"
	#define MSG_ENDSTOP_HIT          "INNESCATO"
	#define MSG_ENDSTOP_OPEN         "aperto"
	#define MSG_HOTEND_OFFSET        "Hotend offsets:"

	#define MSG_SD_CANT_OPEN_SUBDIR  "Impossibile aprire sottocartella"
	#define MSG_SD_INIT_FAIL         "Fallita Inizializzazione SD"
	#define MSG_SD_VOL_INIT_FAIL     "Fallito il montaggio del Volume"
	#define MSG_SD_OPENROOT_FAIL     "Fallita l'apertura Cartella Principale"
	#define MSG_SD_CARD_OK           "SD card ok"
	#define MSG_SD_WORKDIR_FAIL      "Fallita l'apertura Cartella di Lavoro"
	#define MSG_SD_OPEN_FILE_FAIL    "Fallita l'apertura del File: "
	#define MSG_SD_FILE_OPENED       "File aperto: "
	#define MSG_SD_SIZE              " Dimensione: "
	#define MSG_SD_FILE_SELECTED     "File selezionato"
	#define MSG_SD_WRITE_TO_FILE     "Scrittura su file: "
	#define MSG_SD_PRINTING_BYTE     "Si sta scrivendo il byte su SD "
	#define MSG_SD_NOT_PRINTING      "Non si sta scrivendo su SD"
	#define MSG_SD_ERR_WRITE_TO_FILE "Errore nella scrittura su file"
	#define MSG_SD_CANT_ENTER_SUBDIR "Impossibile entrare nella sottocartella: "

	#define MSG_STEPPER_TO_HIGH      "Steprate troppo alto: "
	#define MSG_ENDSTOPS_HIT         "Raggiunto il fondo carrello: "
	#define MSG_ERR_COLD_EXTRUDE_STOP " prevenuta estrusione fredda"
	#define MSG_ERR_LONG_EXTRUDE_STOP " prevenuta estrusione troppo lunga"

#endif


#if LANGUAGE_CHOICE == 8

// LCD Menu Messages
	#define WELCOME_MSG MACHINE_NAME " Pronta."
	#define MSG_SD_INSERTED "Cartao SD inserido"
	#define MSG_SD_REMOVED "Cartao SD removido"
	#define MSG_MAIN " Menu Principal \003"
	#define MSG_AUTOSTART " Autostart"
	#define MSG_DISABLE_STEPPERS " Apagar Motores"
	#define MSG_AUTO_HOME " Ir para Origen"
	#define MSG_SET_ORIGIN " Estabelecer Origen"
	#define MSG_PREHEAT_PLA " pre-aquecer PLA"
	#define MSG_PREHEAT_PLA_SETTINGS " pre-aquecer PLA Setting"
	#define MSG_PREHEAT_ABS " pre-aquecer ABS"
	#define MSG_PREHEAT_ABS_SETTINGS " pre-aquecer ABS Setting"
	#define MSG_COOLDOWN " Esfriar"
	#define MSG_EXTRUDE " Extrudar"
	#define MSG_RETRACT " Retrair"
	#define MSG_PREHEAT_PLA " pre-aquecer PLA"
	#define MSG_PREHEAT_ABS " pre-aquecer ABS"
	#define MSG_MOVE_AXIS " Mover eixo      \x7E"
	#define MSG_SPEED " Velocidade:"
	#define MSG_NOZZLE " \002Nozzle:"
	#define MSG_NOZZLE1 " \002Nozzle2:"
	#define MSG_NOZZLE2 " \002Nozzle3:"
	#define MSG_BED " \002Base:"
	#define MSG_FAN_SPEED " Velocidade Ventoinha:"
	#define MSG_FLOW " Fluxo:"
	#define MSG_CONTROL " Controle \003"
	#define MSG_MIN " \002 Min:"
	#define MSG_MAX " \002 Max:"
	#define MSG_FACTOR " \002 Fact:"
	#define MSG_AUTOTEMP " Autotemp:"
	#define MSG_ON "On "
	#define MSG_OFF "Off"
	#define MSG_PID_P " PID-P: "
	#define MSG_PID_I " PID-I: "
	#define MSG_PID_D " PID-D: "
	#define MSG_PID_C " PID-C: "
	#define MSG_ACC  " Acc:"
	#define MSG_VXY_JERK " Vxy-jerk: "
	#define MSG_VMAX " Vmax "
	#define MSG_X "x:"
	#define MSG_Y "y:"
	#define MSG_Z "z:"
	#define MSG_E "e:"
	#define MSG_VMIN " Vmin:"
	#define MSG_VTRAV_MIN " VTrav min:"
	#define MSG_AMAX " Amax "
	#define MSG_A_RETRACT " A-retract:"
	#define MSG_XSTEPS " Xpasso/mm:"
	#define MSG_YSTEPS " Ypasso/mm:"
	#define MSG_ZSTEPS " Zpasso/mm:"
	#define MSG_ESTEPS " Epasso/mm:"
	#define MSG_MAIN_WIDE " Menu Principal  \003"
	#define MSG_RECTRACT_WIDE " Retrair    \x7E"
	#define MSG_TEMPERATURE_WIDE " Temperatura \x7E"
	#define MSG_TEMPERATURE_RTN " Temperatura  \003"
	#define MSG_MOTION_WIDE " Movimento     \x7E"
	#define MSG_STORE_EPROM " Guardar memoria"
	#define MSG_LOAD_EPROM " Carregar memoria"
	#define MSG_RESTORE_FAILSAFE " Rest. de emergencia"
	#define MSG_REFRESH "\004Recarregar"
	#define MSG_WATCH " Monitorar   \003"
	#define MSG_PREPARE " Preparar \x7E"
	#define MSG_PREPARE_ALT " Preparar \003"
	#define MSG_CONTROL_ARROW " Controle \x7E"
	#define MSG_RETRACT_ARROW " Retrair \x7E"
	#define MSG_TUNE " Tune    \x7E"
	#define MSG_PAUSE_PRINT " Pausar Impressao \x7E"
	#define MSG_RESUME_PRINT " Resumir Impressao \x7E"
	#define MSG_STOP_PRINT " Parar Impressao   \x7E"
	#define MSG_CARD_MENU " Menu cartao SD    \x7E"
	#define MSG_NO_CARD " Sem cartao SD"
	#define MSG_DWELL "Repouso..."
	#define MSG_USERWAIT "Esperando Ordem..."
	#define MSG_NO_MOVE "Sem movimento."
	#define MSG_PART_RELEASE "Lancamento Parcial"
	#define MSG_KILLED "PARADA DE EMERGENCIA. "
	#define MSG_STOPPED "PARADA. "
	#define MSG_STEPPER_RELEASED "Lancado."
	#define MSG_CONTROL_RETRACT  " Retrair mm:"
	#define MSG_CONTROL_RETRACTF " Retrair  F:"
	#define MSG_CONTROL_RETRACT_ZLIFT " Levantar mm:"
	#define MSG_CONTROL_RETRACT_RECOVER " DesRet +mm:"
	#define MSG_CONTROL_RETRACT_RECOVERF " DesRet  F:"
	#define MSG_AUTORETRACT " AutoRetr.:"
        #define MSG_SERIAL_ERROR_MENU_STRUCTURE "Algo esta errado na estrutura do Menu."
        #define MSG_FILAMENTCHANGE "Change filament"

// Serial Console Messages

	#define MSG_Enqueing "enqueing \""
	#define MSG_POWERUP "PowerUp"
	#define MSG_EXTERNAL_RESET " Reset Externo"
	#define MSG_BROWNOUT_RESET " Reset por voltagem incorreta"
	#define MSG_WATCHDOG_RESET " Reset por Bloqueio"
	#define MSG_SOFTWARE_RESET " Reset por Software"
	#define MSG_MARLIN "Marlin "
	#define MSG_AUTHOR " | Author: "
	#define MSG_CONFIGURATION_VER " Ultima atualizacao: "
	#define MSG_FREE_MEMORY " memoria Livre: "
	#define MSG_PLANNER_BUFFER_BYTES "  PlannerBufferBytes: "
	#define MSG_OK "ok"
	#define MSG_FILE_SAVED "Guardado."
	#define MSG_ERR_LINE_NO "O Numero da linha Nao e igual ao ultimo Numero da linha+1, Ultima linha:"
	#define MSG_ERR_CHECKSUM_MISMATCH "O checksum Nao coincide, Ultima linha:"
	#define MSG_ERR_NO_CHECKSUM "Nao foi possivel encontrar o checksum com o numero da linha, Ultima linha :"
	#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "Nao ha o numero da linha com o checksum, Ultima linha:"
	#define MSG_FILE_PRINTED "Impressao terminada"
	#define MSG_BEGIN_FILE_LIST "Começo da lista de arquivos"
	#define MSG_END_FILE_LIST "Fim da lista de arquivos"
	#define MSG_M104_INVALID_EXTRUDER "M104 Extrusor inválido "
	#define MSG_M105_INVALID_EXTRUDER "M105 Extrusor inválido "
	#define MSG_M218_INVALID_EXTRUDER "M218 Extrusor inválido "
	#define MSG_ERR_NO_THERMISTORS "Nao ha termistor - no temp"
	#define MSG_M109_INVALID_EXTRUDER "M109 Extrusor inválido "
	#define MSG_HEATING "Aquecendo..."
	#define MSG_HEATING_COMPLETE "Aquecido."
	#define MSG_BED_HEATING "Aquecendo a Base."
	#define MSG_BED_DONE "Base quente."
	#define MSG_M115_REPORT "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
	#define MSG_COUNT_X " Conta X:"
	#define MSG_ERR_KILLED "Impressora parada com kill() !!"
	#define MSG_ERR_STOPPED "Impressora parada por erros. Coserte o erro e use M999 para recomeçar!. (Temperatura reiniciada. Ajuste antes de recomeçar)"
	#define MSG_RESEND "Reenviar:"
	#define MSG_UNKNOWN_COMMAND "Comando desconhecido:\""
	#define MSG_ACTIVE_EXTRUDER "Extrusor ativo: "
	#define MSG_INVALID_EXTRUDER "Extrusor invalido"
	#define MSG_X_MIN "x_min: "
	#define MSG_X_MAX "x_max: "
	#define MSG_Y_MIN "y_min: "
	#define MSG_Y_MAX "y_max: "
	#define MSG_Z_MIN "z_min: "
	#define MSG_Z_MAX "z_max: "
	#define MSG_M119_REPORT "Relatando estado do ponto final"
	#define MSG_ENDSTOP_HIT "PULSADO"
	#define MSG_ENDSTOP_OPEN "Aberto"
	#define MSG_HOTEND_OFFSET "Hotend offsets:"

	#define MSG_SD_CANT_OPEN_SUBDIR "Nao pode abrir sub diretorio"
	#define MSG_SD_INIT_FAIL "Falha ao iniciar SD"
	#define MSG_SD_VOL_INIT_FAIL "Falha ao montar volume"
	#define MSG_SD_OPENROOT_FAIL "Falha ao abrir diretorio raiz"
	#define MSG_SD_CARD_OK "cartao SD ok"
	#define MSG_SD_WORKDIR_FAIL "Falha ao abrir diretorio de trabalho"
	#define MSG_SD_OPEN_FILE_FAIL "Erro ao abrir, Arquivo: "
	#define MSG_SD_FILE_OPENED "Arquivo aberto:"
	#define MSG_SD_SIZE " Size:"
	#define MSG_SD_FILE_SELECTED "Arquivo selecionado"
	#define MSG_SD_WRITE_TO_FILE "Escrevendo no arquivo: "
	#define MSG_SD_PRINTING_BYTE "SD imprimindo o byte "
	#define MSG_SD_NOT_PRINTING "Nao esta se imprimindo com o SD"
	#define MSG_SD_ERR_WRITE_TO_FILE "Erro ao escrever no arquivo"
	#define MSG_SD_CANT_ENTER_SUBDIR "Nao pode abrir o sub diretorio:"

	#define MSG_STEPPER_TO_HIGH "Steprate muito alto : "
	#define MSG_ENDSTOPS_HIT "O ponto final foi tocado: "
	#define MSG_ERR_COLD_EXTRUDE_STOP " Extrusao a frio evitada"
	#define MSG_ERR_LONG_EXTRUDE_STOP " Extrusao muito larga evitada"


#endif



#if LANGUAGE_CHOICE == 9

// Finnish

// LCD Menu Messages
	#define WELCOME_MSG MACHINE_NAME " valmis"
	#define MSG_SD_INSERTED "Kortti asetettu"
	#define MSG_SD_REMOVED "Kortti poistettu"
	#define MSG_MAIN "Palaa"
	#define MSG_AUTOSTART "Automaatti"
	#define MSG_DISABLE_STEPPERS "Vapauta moottorit"
	#define MSG_AUTO_HOME "Aja referenssiin"
	#define MSG_SET_ORIGIN "Aseta origo"
	#define MSG_PREHEAT_PLA "Esilammita PLA"
	#define MSG_PREHEAT_PLA_SETTINGS "Esilammita PLA konf"
	#define MSG_PREHEAT_ABS "Esilammita ABS"
	#define MSG_PREHEAT_ABS_SETTINGS "Esilammita ABS konf"
	#define MSG_COOLDOWN "Jaahdyta"
	#define MSG_EXTRUDE "Pursota"
	#define MSG_RETRACT "Veda takaisin"
	#define MSG_MOVE_AXIS "Liikuta akseleita"
	#define MSG_SPEED "Nopeus"
	#define MSG_NOZZLE "Suutin"
	#define MSG_NOZZLE1 "Suutin2"
	#define MSG_NOZZLE2 "Suutin3"
	#define MSG_BED "Alusta"
	#define MSG_FAN_SPEED "Tuul. nopeus"
	#define MSG_FLOW "Virtaus"
	#define MSG_CONTROL "Kontrolli"
	#define MSG_MIN " \002 Min"
	#define MSG_MAX " \002 Max"
	#define MSG_FACTOR " \002 Kerr"
	#define MSG_AUTOTEMP "Autotemp"
	#define MSG_ON "On "
	#define MSG_OFF "Off"
	#define MSG_PID_P "PID-P"
	#define MSG_PID_I "PID-I"
	#define MSG_PID_D "PID-D"
	#define MSG_PID_C "PID-C"
	#define MSG_ACC  "Kiihtyv"
	#define MSG_VXY_JERK "Vxy-jerk"
	#define MSG_VMAX "Vmax "
	#define MSG_X "x"
	#define MSG_Y "y"
	#define MSG_Z "z"
	#define MSG_E "e"
	#define MSG_VMIN "Vmin"
	#define MSG_VTRAV_MIN "VLiike min"
	#define MSG_AMAX "Amax "
	#define MSG_A_RETRACT "A-peruuta"
	#define MSG_XSTEPS "Xsteps/mm"
	#define MSG_YSTEPS "Ysteps/mm"
	#define MSG_ZSTEPS "Zsteps/mm"
	#define MSG_ESTEPS "Esteps/mm"
	#define MSG_RECTRACT "Veda takaisin"
	#define MSG_TEMPERATURE "Lampotila"
	#define MSG_MOTION "Liike"
	#define MSG_STORE_EPROM "Tallenna muistiin"
	#define MSG_LOAD_EPROM "Lataa muistista"
	#define MSG_RESTORE_FAILSAFE "Palauta oletus"
	#define MSG_REFRESH "Paivita"
	#define MSG_WATCH "Seuraa"
	#define MSG_PREPARE "Valmistele"
	#define MSG_TUNE "Saada"
	#define MSG_PAUSE_PRINT "Keskeyta tulostus"
	#define MSG_RESUME_PRINT "Jatka tulostusta"
	#define MSG_STOP_PRINT "Pysayta tulostus"
	#define MSG_CARD_MENU "Korttivalikko"
	#define MSG_NO_CARD "Ei korttia"
	#define MSG_DWELL "Nukkumassa..."
	#define MSG_USERWAIT "Odotetaan valintaa..."
	#define MSG_RESUMING "Jatketaan tulostusta"
	#define MSG_NO_MOVE "Ei liiketta."
	#define MSG_KILLED "KILLED. "
	#define MSG_STOPPED "STOPPED. "
	#define MSG_CONTROL_RETRACT  "Veda mm"
	#define MSG_CONTROL_RETRACTF "Veda F"
	#define MSG_CONTROL_RETRACT_ZLIFT "Z mm"
	#define MSG_CONTROL_RETRACT_RECOVER "UnRet +mm"
	#define MSG_CONTROL_RETRACT_RECOVERF "UnRet  F"
	#define MSG_AUTORETRACT "AutoVeto."
	#define MSG_FILAMENTCHANGE "Change filament"

// Serial Console Messages

	#define MSG_Enqueing "jonoon \""
	#define MSG_POWERUP "Kaynnistys"
	#define MSG_EXTERNAL_RESET " Ulkoinen Reset"
	#define MSG_BROWNOUT_RESET " Alajannite Reset"
	#define MSG_WATCHDOG_RESET " Vahtikoira Reset"
	#define MSG_SOFTWARE_RESET " Ohjelmisto Reset"
	#define MSG_MARLIN "Marlin "
	#define MSG_AUTHOR " | Author: "
	#define MSG_CONFIGURATION_VER " Paivitetty viimeksi: "
	#define MSG_FREE_MEMORY " Vapaata muistia: "
	#define MSG_PLANNER_BUFFER_BYTES "  PlannerBufferBytes: "
	#define MSG_OK "ok"
	#define MSG_FILE_SAVED "Tiedosto tallennettu."
	#define MSG_ERR_LINE_NO "Rivinumero ei ole Viimeisin rivi+1, Viimeisin rivi: "
	#define MSG_ERR_CHECKSUM_MISMATCH "Tarkistesummassa virhe, Viimeisin rivi: "
	#define MSG_ERR_NO_CHECKSUM "Rivilla ei tarkistesummaa, Viimeisin rivi: "
	#define MSG_ERR_NO_LINENUMBER_WITH_CHECKSUM "Ei rivinumeroa tarkistesumman kanssa, Viimeisin rivi: "
	#define MSG_FILE_PRINTED "Tiedoston tulostus valmis"
	#define MSG_BEGIN_FILE_LIST "Tiedostolistauksen alku"
	#define MSG_END_FILE_LIST "Tiedostolistauksen loppu"
	#define MSG_M104_INVALID_EXTRUDER "M104 Virheellinen suutin "
	#define MSG_M105_INVALID_EXTRUDER "M105 Virheellinen suutin "
	#define MSG_M218_INVALID_EXTRUDER "M218 Virheellinen suutin "
	#define MSG_ERR_NO_THERMISTORS "Ei termistoreja - ei lampotiloja"
	#define MSG_M109_INVALID_EXTRUDER "M109 Virheellinen suutin "
	#define MSG_HEATING "Lammitan..."
	#define MSG_HEATING_COMPLETE "Lammitys valmis."
	#define MSG_BED_HEATING "Alusta lampiaa."
	#define MSG_BED_DONE "Alusta valmis."
	#define MSG_M115_REPORT "FIRMWARE_NAME:Marlin V1; Sprinter/grbl mashup for gen6 FIRMWARE_URL:" FIRMWARE_URL " PROTOCOL_VERSION:" PROTOCOL_VERSION " MACHINE_TYPE:" MACHINE_NAME " EXTRUDER_COUNT:" STRINGIFY(EXTRUDERS) "\n"
	#define MSG_COUNT_X " Laskuri X: "
	#define MSG_ERR_KILLED "Tulostin pysaytetty. kill():ia kutsuttu!"
	#define MSG_ERR_STOPPED "Tulostin pysaytetty virheiden vuoksi. Korjaa virheet ja kayta M999 kaynnistaaksesi uudelleen. (Lampotila nollattiin. Aseta lampotila sen jalkeen kun jatkat.)"
	#define MSG_RESEND "Uudelleenlahetys: "
	#define MSG_UNKNOWN_COMMAND "Tuntematon komento: \""
	#define MSG_ACTIVE_EXTRUDER "Aktiivinen suutin: "
	#define MSG_INVALID_EXTRUDER "Virheellinen suutin"
	#define MSG_X_MIN "x_min: "
	#define MSG_X_MAX "x_max: "
	#define MSG_Y_MIN "y_min: "
	#define MSG_Y_MAX "y_max: "
	#define MSG_Z_MIN "z_min: "
	#define MSG_Z_MAX "z_max: "
	#define MSG_M119_REPORT "Rajakytkimien tilaraportti"
	#define MSG_ENDSTOP_HIT "AKTIIVISENA"
	#define MSG_ENDSTOP_OPEN "avoinna"
	#define MSG_HOTEND_OFFSET "Hotend offsets:"

	#define MSG_SD_CANT_OPEN_SUBDIR "Alihakemistoa ei voitu avata"
	#define MSG_SD_INIT_FAIL "SD alustus epaonnistui"
	#define MSG_SD_VOL_INIT_FAIL "volume.init epaonnistui"
	#define MSG_SD_OPENROOT_FAIL "openRoot epaonnistui"
	#define MSG_SD_CARD_OK "SD kortti ok"
	#define MSG_SD_WORKDIR_FAIL "workDir open epaonnistui"
	#define MSG_SD_OPEN_FILE_FAIL "avaus epaonnistui, Tiedosto: "
	#define MSG_SD_FILE_OPENED "Tiedosto avattu: "
	#define MSG_SD_SIZE " Koko: "
	#define MSG_SD_FILE_SELECTED "Tiedosto valittu"
	#define MSG_SD_WRITE_TO_FILE "Kirjoitetaan tiedostoon: "
	#define MSG_SD_PRINTING_BYTE "SD tulostus byte "
	#define MSG_SD_NOT_PRINTING "Ei SD tulostus"
	#define MSG_SD_ERR_WRITE_TO_FILE "virhe kirjoitettaessa tiedostoon"
	#define MSG_SD_CANT_ENTER_SUBDIR "Alihakemistoon ei voitu siirtya: "

	#define MSG_STEPPER_TO_HIGH "Askellustaajuus liian suuri: "
	#define MSG_ENDSTOPS_HIT "paatyrajat aktivoitu: "
	#define MSG_ERR_COLD_EXTRUDE_STOP " kylmana pursotus estetty"
	#define MSG_ERR_LONG_EXTRUDE_STOP " liian pitka pursotus estetty"

#endif
#endif // ifndef LANGUAGE_H
