#define MODULE_NAME "gamepadReaderModule"

#include "gamepadreadermodule.h"
#include "gamepadreadermodule_names.h"

#include <rdkcore/robot/robotmodule.h>
#include <rdkcore/logging/logging.h>
#include <rdkcore/ns.h>
#define LOGGING_MODULE MODULE_NAME

namespace RDK2 { namespace RAgent {

bool gamepadReaderModule::initConfigurationProperties()
{
	SESSION_TRY_START(session)
		// put false in the second parameter if you want the module disabled for default
		// add a third parameter valued false if you don't want the state property
		Common::createDefaultProperties(session, true);
		// here you declare the properties of your module
		// in the repository they have the name of this module as prefix, e.g. /yourModuleName/maxSpeed
		
		session->createBool(PROPERTY_BUTTON1, "Value of button 1 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON1);
		session->createBool(PROPERTY_BUTTON2, "Value of button 2 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON2);
		session->createBool(PROPERTY_BUTTON3, "Value of button 3 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON3);
		session->createBool(PROPERTY_BUTTON4, "Value of button 4 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON4);
		session->createBool(PROPERTY_BUTTON5, "Value of button 5 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON5);
		session->createBool(PROPERTY_BUTTON6, "Value of button 6 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON6);
		session->createBool(PROPERTY_BUTTON7, "Value of button 7 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON7);
		session->createBool(PROPERTY_BUTTON8, "Value of button 8 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON8);
		session->createBool(PROPERTY_BUTTON9, "Value of button 9 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON9);
		session->createBool(PROPERTY_BUTTON10, "Value of button 10 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON10);
		session->createBool(PROPERTY_BUTTON11, "Value of button 11 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON11);
		session->createBool(PROPERTY_BUTTON12, "Value of button 12 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON12);
		
		session->createDouble(PROPERTY_AXIS1, "Value of axis 1 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS1);
		session->createDouble(PROPERTY_AXIS2, "Value of axis 2 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS2);
		session->createDouble(PROPERTY_AXIS3, "Value of axis 3 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS3);
		session->createDouble(PROPERTY_AXIS4, "Value of axis 4 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS4);
		session->createDouble(PROPERTY_AXIS5, "Value of axis 5 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS5);
		session->createDouble(PROPERTY_AXIS6, "Value of axis 6 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS6);
		
		session->createString(PROPERTY_DEVICE, "Gamepad device", "/dev/input/js0");

	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

// bool gamepadReaderModule::initInterfaceProperties() { }

bool gamepadReaderModule::init()
{
	// in the init() function you should initialize everything your module needs (drivers initialization,
	// sockets, and so on); all modules wait for all init() before they start
	SESSION_TRY_START(session)
		// here you can declare the events you are waiting in the main exec() loop,
		// for example:
		session->listenToTimer(100.);
		string device = session->getString(PROPERTY_DEVICE);
		gpad = new Joystick(device);
	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

void gamepadReaderModule::exec()
{
	while (session->wait(), !exiting) {
		SESSION_TRY_START(session)
		//	RDK_DEBUG_PRINTF("I'm '%s', I will do something", getModuleName().c_str());
			
			gpad->refresh();			
			session->setDouble(PROPERTY_AXIS1,-normv(gpad->getAxis(0), 32767, -32767, 0, 0));
			session->setDouble(PROPERTY_AXIS2,-normv(gpad->getAxis(1), 32767, -32767, 0, 0));
			session->setDouble(PROPERTY_AXIS3,-normv(gpad->getAxis(2), 32767, -32767, 0, 0));
			session->setDouble(PROPERTY_AXIS4,-normv(gpad->getAxis(3), 32767, -32767, 0, 0));
			session->setDouble(PROPERTY_AXIS5,-normv(gpad->getAxis(4), 32767, -32767, 0, 0));
			session->setDouble(PROPERTY_AXIS6,-normv(gpad->getAxis(5), 32767, -32767, 0, 0));
			
			session->setBool(PROPERTY_BUTTON1,gpad->getButton(0));
			session->setBool(PROPERTY_BUTTON2,gpad->getButton(1));
			session->setBool(PROPERTY_BUTTON3,gpad->getButton(2));
			session->setBool(PROPERTY_BUTTON4,gpad->getButton(3));
			session->setBool(PROPERTY_BUTTON5,gpad->getButton(4));
			session->setBool(PROPERTY_BUTTON6,gpad->getButton(5));
			session->setBool(PROPERTY_BUTTON7,gpad->getButton(6));
			session->setBool(PROPERTY_BUTTON8,gpad->getButton(7));
			session->setBool(PROPERTY_BUTTON9,gpad->getButton(8));
			session->setBool(PROPERTY_BUTTON10,gpad->getButton(9));
			session->setBool(PROPERTY_BUTTON11,gpad->getButton(10));
			session->setBool(PROPERTY_BUTTON12,gpad->getButton(11));
			
		SESSION_END_CATCH_TERMINATE(session)
	}
}

double gamepadReaderModule::normv(int val, int maxv, int minv, int max0v, int min0v)
{
	if ((val >= min0v) && (val <= max0v)){ return 0.0;}
	else if (val > max0v){ return ((double) (val-max0v)/(maxv-max0v));}
	else if (val < min0v){ return -((double) (min0v-val)/(min0v-minv));}
	else { return 0.0;}
}

// implement this if you need to force the exec to go out of the loop
// if the thread may be waiting not for the session->wait() semaphore:
// on closing, the main thread will set the exiting variables, call this exitRequested()
// function and then signal the session semaphores
// void gamepadReaderModule::exitRequested() { }

// implement this if you need to clean up things after the exec has exited
void gamepadReaderModule::cleanup() {
	delete gpad;
}

// void gamepadReaderModule::asyncAgentCmd(cstr cmd)
// {
//	SESSION_TRY_START(asyncSession)
//	// here you can parse 'cmd'
//	SESSION_END_CATCH_TERMINATE(asyncSession)
// }

MODULE_FACTORY(gamepadReaderModule);

}} // namespace
