#define MODULE_NAME "GamePad2OrugatorModule"

#include "gamepad2orugatormodule.h"
#include "gamepad2orugatormodule_names.h"

#include <rdkcore/robot/robotmodule.h>
#include <rdkcore/logging/logging.h>
#include <rdkcore/ns.h>
#define LOGGING_MODULE MODULE_NAME

namespace RDK2 { namespace RAgent {

bool GamePad2OrugatorModule::initConfigurationProperties()
{
	SESSION_TRY_START(session)
		// put false in the second parameter if you want the module disabled for default
		// add a third parameter valued false if you don't want the state property
		Common::createDefaultProperties(session, true);
		// here you declare the properties of your module
		// in the repository they have the name of this module as prefix, e.g. /yourModuleName/maxSpeed
		
		session->createInt(PROPERTY_SERVO1, "Value of servo 1 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO1);
		session->createInt(PROPERTY_SERVO2, "Value of servo 2 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO2);

		session->createBool(PROPERTY_BUTTON1, "Value of button 1 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON1);
		session->createBool(PROPERTY_BUTTON2, "Value of button 2 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON2);
		session->createBool(PROPERTY_BUTTON3, "Value of button 3 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON3);
		session->createBool(PROPERTY_BUTTON4, "Value of button 4 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON4);
		session->createBool(PROPERTY_BUTTON5, "Value of button 5 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON5);
		session->createBool(PROPERTY_BUTTON6, "Value of button 6 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON6);
		session->createBool(PROPERTY_BUTTON7, "Value of button 7 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON7);
		session->createBool(PROPERTY_BUTTON8, "Value of button 8 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON8);
		session->createBool(PROPERTY_BUTTON9, "Value of button 9 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON9);
		session->createBool(PROPERTY_BUTTON10, "Value of button 10 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON10);
		session->createBool(PROPERTY_BUTTON11, "Value of button 11 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON11);
		session->createBool(PROPERTY_BUTTON12, "Value of button 12 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON12);
		
		session->createDouble(PROPERTY_AXIS1, "Value of axis 1 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS1);
		session->createDouble(PROPERTY_AXIS2, "Value of axis 2 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS2);
		session->createDouble(PROPERTY_AXIS3, "Value of axis 3 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS3);
		session->createDouble(PROPERTY_AXIS4, "Value of axis 4 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS4);
		session->createDouble(PROPERTY_AXIS5, "Value of axis 5 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS5);
		session->createDouble(PROPERTY_AXIS6, "Value of axis 6 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS6);
		
		session->createInt(PROPERTY_MODE, "Mode Control", 1);
		session->setVolatile(PROPERTY_MODE);

		
	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

// bool GamePad2OrugatorModule::initInterfaceProperties() { }

bool GamePad2OrugatorModule::init()
{
	mode = 1;
	SESSION_TRY_START(session)
		session->listenToTimer(100.);
	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

void GamePad2OrugatorModule::exec()
{
	while (session->wait(), !exiting) {
		SESSION_TRY_START(session)
		//	RDK_DEBUG_PRINTF("I'm '%s', I will do something", getModuleName().c_str());
			while(session->getBool(PROPERTY_BUTTON9)){ //-- Boton Nº9 para seleccionar modo de control.
				if(session->getBool(PROPERTY_BUTTON1)){ mode = 1;}	// Si boton Nº1 y Nº9 pulsados Modo de control 1.
				if(session->getBool(PROPERTY_BUTTON2)){ mode = 2;}	// Si boton Nº2 y Nº9 pulsados Modo de control 2.
				if(session->getBool(PROPERTY_BUTTON3)){ mode = 3;}	// Si boton Nº2 y Nº9 pulsados Modo de control 2.
			}
			
			switch(mode) {
				case 1:  //-- Cada "track" es controlado por un joystick y la cruceta controla el robot entero.
					session->setInt(PROPERTY_MODE,1);
					modeControl1();
					break;
				case 2:  //-- Con un solo joystick o la cruceta se maneja el robot entero.
					session->setInt(PROPERTY_MODE,2);
					modeControl2();
					break;
				case 3:  //-- Con un solo joystick o la cruceta se maneja el robot entero.
					session->setInt(PROPERTY_MODE,3);
					modeControl3();
					break;
			}	
		SESSION_END_CATCH_TERMINATE(session)
	}
}

void GamePad2OrugatorModule::modeControl1()
{
	int rspeed, lspeed;
	lspeed = 10*(session->getDouble(PROPERTY_AXIS2));
	rspeed = 10*(session->getDouble(PROPERTY_AXIS4));
	
//	if((lspeed==0)&&(rspeed==0)){
//		lspeed = 10*(session->getDouble(PROPERTY_AXIS6));
//		rspeed = 10*(session->getDouble(PROPERTY_AXIS6));
//	}
	
	session->setInt(PROPERTY_SERVO1,lspeed);
	session->setInt(PROPERTY_SERVO2,-rspeed);	
}

void GamePad2OrugatorModule::modeControl2()
{
	double jog, speed;
	int rspeed, lspeed;
	jog = -session->getDouble(PROPERTY_AXIS1);
	speed = session->getDouble(PROPERTY_AXIS2);
	
	
	if(speed > 0){
		if(jog > 0){
			lspeed = 10*speed;
			rspeed = 10*(speed - jog);
		}
		else if(jog < 0){
			lspeed = 10*(speed + jog);
			rspeed = 10*speed;
		}
		else{
			lspeed = 10*speed;
			rspeed = 10*speed;
		}
	}
	else if(speed < 0){
		if(jog > 0){
			lspeed = 10*speed;
			rspeed = 10*(speed + jog);
		}
		else if(jog < 0){
			lspeed = 10*(speed - jog);
			rspeed = 10*speed;
		}
		else{
			lspeed = 10*speed;
			rspeed = 10*speed;
		}
	}
	else{
		lspeed = 10*jog;
		rspeed = -10*jog;
	}
	session->setInt(PROPERTY_SERVO1,lspeed);
	session->setInt(PROPERTY_SERVO2,-rspeed);	
}

void GamePad2OrugatorModule::modeControl3()
{
	double jog, speed;
	int rspeed, lspeed;
	jog = -session->getDouble(PROPERTY_AXIS3);
	speed = session->getDouble(PROPERTY_AXIS2);
	
	if(speed > 0){
		if(jog > 0){
			lspeed = 10*speed;
			rspeed = 10*(speed - jog);
		}
		else if(jog < 0){
			lspeed = 10*(speed + jog);
			rspeed = 10*speed;
		}
		else{
			lspeed = 10*speed;
			rspeed = 10*speed;
		}
	}
	else if(speed < 0){
		if(jog > 0){
			lspeed = 10*speed;
			rspeed = 10*(speed + jog);
		}
		else if(jog < 0){
			lspeed = 10*(speed - jog);
			rspeed = 10*speed;
		}
		else{
			lspeed = 10*speed;
			rspeed = 10*speed;
		}
	}
	else{
		lspeed = 10*jog;
		rspeed = -10*jog;
	}
	session->setInt(PROPERTY_SERVO1,lspeed);
	session->setInt(PROPERTY_SERVO2,-rspeed);	
}

// implement this if you need to force the exec to go out of the loop
// if the thread may be waiting not for the session->wait() semaphore:
// on closing, the main thread will set the exiting variables, call this exitRequested()
// function and then signal the session semaphores
// void GamePad2OrugatorModule::exitRequested() { }

// implement this if you need to clean up things after the exec has exited
// void GamePad2OrugatorModule::cleanup() { }

// void GamePad2OrugatorModule::asyncAgentCmd(cstr cmd)
// {
//	SESSION_TRY_START(asyncSession)
//	// here you can parse 'cmd'
//	SESSION_END_CATCH_TERMINATE(asyncSession)
// }

MODULE_FACTORY(GamePad2OrugatorModule);

}} // namespace
