#define MODULE_NAME "GamePad2FTrackModule"

#include "gamepad2ftrackmodule.h"
#include "gamepad2ftrackmodule_names.h"

#include <rdkcore/robot/robotmodule.h>
#include <rdkcore/logging/logging.h>
#include <rdkcore/ns.h>
#define LOGGING_MODULE MODULE_NAME

namespace RDK2 { namespace RAgent {

bool GamePad2FTrackModule::initConfigurationProperties()
{
	SESSION_TRY_START(session)
		// put false in the second parameter if you want the module disabled for default
		// add a third parameter valued false if you don't want the state property
		Common::createDefaultProperties(session, true);
		// here you declare the properties of your module
		// in the repository they have the name of this module as prefix, e.g. /yourModuleName/maxSpeed
		
		session->createInt(PROPERTY_SERVO1, "Value of servo 1 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO1);
		session->createInt(PROPERTY_SERVO2, "Value of servo 2 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO2);
		session->createInt(PROPERTY_SERVO3, "Value of servo 3 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO3);
		session->createInt(PROPERTY_SERVO4, "Value of servo 4 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO4);
		session->createInt(PROPERTY_SERVO5, "Value of servo 5 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO5);
		session->createInt(PROPERTY_SERVO6, "Value of servo 6 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO6);
		session->createInt(PROPERTY_SERVO7, "Value of servo 7 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO7);
		session->createInt(PROPERTY_SERVO8, "Value of servo 8 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO8);
		
		session->createBool(PROPERTY_BUTTON1, "Value of button 1 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON1);
		session->createBool(PROPERTY_BUTTON2, "Value of button 2 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON2);
		session->createBool(PROPERTY_BUTTON3, "Value of button 3 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON3);
		session->createBool(PROPERTY_BUTTON4, "Value of button 4 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON4);
		session->createBool(PROPERTY_BUTTON5, "Value of button 5 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON5);
		session->createBool(PROPERTY_BUTTON6, "Value of button 6 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON6);
		session->createBool(PROPERTY_BUTTON7, "Value of button 7 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON7);
		session->createBool(PROPERTY_BUTTON8, "Value of button 8 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON8);
		session->createBool(PROPERTY_BUTTON9, "Value of button 9 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON9);
		session->createBool(PROPERTY_BUTTON10, "Value of button 10 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON10);
		session->createBool(PROPERTY_BUTTON11, "Value of button 11 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON11);
		session->createBool(PROPERTY_BUTTON12, "Value of button 12 (please link)", 0);
		session->setVolatile(PROPERTY_BUTTON12);
		
		session->createDouble(PROPERTY_AXIS1, "Value of axis 1 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS1);
		session->createDouble(PROPERTY_AXIS2, "Value of axis 2 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS2);
		session->createDouble(PROPERTY_AXIS3, "Value of axis 3 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS3);
		session->createDouble(PROPERTY_AXIS4, "Value of axis 4 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS4);
		session->createDouble(PROPERTY_AXIS5, "Value of axis 5 (please link)", RDouble::M_SEC, 0);
		session->setVolatile(PROPERTY_AXIS5);
		session->createDouble(PROPERTY_AXIS6, "Value of axis 6 (please link)", RDouble::RAD_SEC, 0);
		session->setVolatile(PROPERTY_AXIS6);
		
		session->createInt(PROPERTY_MODE, "Mode Control", 1);
		session->setVolatile(PROPERTY_MODE);

	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

// bool GamePad2FTrackModule::initInterfaceProperties() { }

bool GamePad2FTrackModule::init()
{
	mode = 1;
	for(int i=0;i<4;i++){position[i]=0;}
	SESSION_TRY_START(session)
		session->listenToTimer(100.);
	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

void GamePad2FTrackModule::exec()
{
	while (session->wait(), !exiting) {
		SESSION_TRY_START(session)
		//	RDK_DEBUG_PRINTF("I'm '%s', I will do something", getModuleName().c_str());
			while(session->getBool(PROPERTY_BUTTON9)){ //-- Boton Nº9 para seleccionar modo de control.
				if(session->getBool(PROPERTY_BUTTON1)){ mode = 1;}	// Si boton Nº1 y Nº9 pulsados Modo de control 1.
				if(session->getBool(PROPERTY_BUTTON2)){ mode = 2;}	// Si boton Nº2 y Nº9 pulsados Modo de control 2.
				if(session->getBool(PROPERTY_BUTTON3)){ mode = 3;}	// Si boton Nº3 y Nº9 pulsados Modo de control 3.
				if(session->getBool(PROPERTY_BUTTON4)){ mode = 4;}	// Si boton Nº4 y Nº9 pulsados Modo de control 4.
			}
			
			switch(mode) {
				case 1:  //-- Los cuatro "tracks" se mueven conjuntamente a la misma posicion.
					session->setInt(PROPERTY_MODE,1);
					modeControl1(position);
					break;
				case 2:  //-- Los dos "tracks" delanteros se mueven conjuntamente a la misma posicion.
					session->setInt(PROPERTY_MODE,2);
					modeControl2(position);
					break;
				case 3: //-- Los dos "tracks" traseros se mueven conjuntamente a la misma posicion.
					session->setInt(PROPERTY_MODE,3);
					modeControl3(position);
					break;
				case 4: //-- El movimiento de cada uno de los "tracks" es independiente al de los demas.
					session->setInt(PROPERTY_MODE,4);
					modeControl4(position);
					break;
			}	
		SESSION_END_CATCH_TERMINATE(session)
	}
}

void GamePad2FTrackModule::setDataServos(int pos[]){
	for(int i=0;i<4;i++){	// Evita que "pos" tome valores de posicion no existentes.
		if(pos[i]>80){ pos[i]=80;}
		else if(pos[i]<-80){ pos[i]=-80;}
	}
	//-- Asigna los valores de velocidad y posicion a los 8 servos.
	// Asignacion de la velocidad. Si esta pulsado el boton Nº12 entonces los "tracks"
	// delanteros giran en sentido contrario a los traseros, para facilitar el levantamiento del robot.
	// En caso contrario el joystick izquierdo controla la velocidad de los tracks del lateral izquierdo,
	// y el joystick derecho los del lateral derecho.
	if (session->getBool(PROPERTY_BUTTON12)){
		session->setInt(PROPERTY_SERVO1,10);
		session->setInt(PROPERTY_SERVO2,-10);
		session->setInt(PROPERTY_SERVO3,-10);
		session->setInt(PROPERTY_SERVO4,10);}
	else {
		session->setInt(PROPERTY_SERVO1,-10*(session->getDouble(PROPERTY_AXIS2)));
		session->setInt(PROPERTY_SERVO2,10*(session->getDouble(PROPERTY_AXIS4)));
		session->setInt(PROPERTY_SERVO3,-10*(session->getDouble(PROPERTY_AXIS2)));
		session->setInt(PROPERTY_SERVO4,10*(session->getDouble(PROPERTY_AXIS4)));	
	}
	// Asignacion de la posicion.
	session->setInt(PROPERTY_SERVO5,pos[0]);
	session->setInt(PROPERTY_SERVO6,-pos[1]);
	session->setInt(PROPERTY_SERVO7,-pos[2]);
	session->setInt(PROPERTY_SERVO8,pos[3]);
}

void GamePad2FTrackModule::modeControl1(int pos[]){
	if(session->getBool(PROPERTY_BUTTON10)){ for(int i=0;i<5;i++){pos[i] = 0; }}	// Si se pulsa el boton Nº10 "tracks" a 0º.
	
	if(session->getBool(PROPERTY_BUTTON1)){ for(int i=0;i<5;i++){pos[i] = 20; }}	// Si se pulsa el boton Nº1 "tracks" a 20º.
	if(session->getBool(PROPERTY_BUTTON2)){ for(int i=0;i<5;i++){pos[i] = 40;}}	// Si se pulsa el boton Nº2 "tracks" a 40º.
	if(session->getBool(PROPERTY_BUTTON3)){ for(int i=0;i<5;i++){pos[i] = 60;}}	// Si se pulsa el boton Nº3 "tracks" a 60º.
	if(session->getBool(PROPERTY_BUTTON4)){ for(int i=0;i<5;i++){pos[i] = 80;}}	// Si se pulsa el boton Nº4 "tracks" a 80º.
	
	if(session->getBool(PROPERTY_BUTTON5)){ for(int i=0;i<5;i++){pos[i] = -20;}}	// Si se pulsa el boton Nº5 "tracks" a -20º.
	if(session->getBool(PROPERTY_BUTTON6)){ for(int i=0;i<5;i++){pos[i] = -40;}}	// Si se pulsa el boton Nº6 "tracks" a -40º.
	if(session->getBool(PROPERTY_BUTTON7)){ for(int i=0;i<5;i++){pos[i] = -60;}}	// Si se pulsa el boton Nº7 "tracks" a -60º.
	if(session->getBool(PROPERTY_BUTTON8)){ for(int i=0;i<5;i++){pos[i] = -80;}}	// Si se pulsa el boton Nº8 "tracks" a -80º.
	
	if((session->getDouble(PROPERTY_AXIS6))>0){ for(int i=0;i<5;i++){pos[i]+=1;}} // Si pulsa arriba en cruceta "tracks" aumenta 1º.
	if((session->getDouble(PROPERTY_AXIS6))<0){ for(int i=0;i<5;i++){pos[i]-=1;}}	// Si pulsa abajo en cruceta "tracks" disminuye 1º.
	
	setDataServos(pos);
}

void GamePad2FTrackModule::modeControl2(int pos[]){
	if(session->getBool(PROPERTY_BUTTON10)){ pos[0]=0; pos[1]=0; }		// Si se pulsa el boton Nº10 "tracks" delanteros a 0º.

	if(session->getBool(PROPERTY_BUTTON1)){ pos[0]=20; pos[1]=20; }	// Si se pulsa el boton Nº1 "tracks" delanteros a 20º.
	if(session->getBool(PROPERTY_BUTTON2)){ pos[0]=40; pos[1]=40; }	// Si se pulsa el boton Nº2 "tracks" delanteros a 45º.
	if(session->getBool(PROPERTY_BUTTON3)){ pos[0]=60; pos[1]=60; }	// Si se pulsa el boton Nº3 "tracks" delanteros a 60º.
	if(session->getBool(PROPERTY_BUTTON4)){ pos[0]=80; pos[1]=80; }	// Si se pulsa el boton Nº4 "tracks" delanteros a 80º.
	
	if(session->getBool(PROPERTY_BUTTON5)){ pos[0]=-20; pos[1]=-20; }	// Si se pulsa el boton Nº5 "tracks" delanteros a -20º.
	if(session->getBool(PROPERTY_BUTTON6)){ pos[0]=-40; pos[1]=-40; }	// Si se pulsa el boton Nº6 "tracks" delanteros a -40º.
	if(session->getBool(PROPERTY_BUTTON7)){ pos[0]=-60; pos[1]=-60; }	// Si se pulsa el boton Nº7 "tracks" delanteros a -60º.
	if(session->getBool(PROPERTY_BUTTON8)){ pos[0]=-80; pos[1]=-80; }	// Si se pulsa el boton Nº8 "tracks" delanteros a -80º.
	
	if((session->getDouble(PROPERTY_AXIS6))>0){ pos[0]+=1; pos[1]+=1; } 	// Si pulsa arriba en cruceta "tracks" aumenta 1º.
	if((session->getDouble(PROPERTY_AXIS6))<0){ pos[0]-=1; pos[1]-=1; }	// Si pulsa abajo en cruceta "tracks" disminuye 1º.
	
	setDataServos(pos);
}

void GamePad2FTrackModule::modeControl3(int pos[]){
	if(session->getBool(PROPERTY_BUTTON10)){ pos[2]=0; pos[3]=0; }		// Si se pulsa el boton Nº10 "tracks" traseros a 0º.
	
	if(session->getBool(PROPERTY_BUTTON1)){ pos[2]=20; pos[3]=20; }	// Si se pulsa el boton Nº1 "tracks" traseros a 0º.
	if(session->getBool(PROPERTY_BUTTON2)){ pos[2]=40; pos[3]=40; }	// Si se pulsa el boton Nº2 "tracks" traseros a 45º.
	if(session->getBool(PROPERTY_BUTTON3)){ pos[2]=60; pos[3]=60; }	// Si se pulsa el boton Nº3 "tracks" traseros a 60º.
	if(session->getBool(PROPERTY_BUTTON4)){ pos[2]=80; pos[3]=80; }	// Si se pulsa el boton Nº4 "tracks" traseros a 80º.
	
	if(session->getBool(PROPERTY_BUTTON5)){ pos[2]=-20; pos[3]=-20; }	// Si se pulsa el boton Nº5 "tracks" traseros a -20º.
	if(session->getBool(PROPERTY_BUTTON6)){ pos[2]=-40; pos[3]=-40; }	// Si se pulsa el boton Nº6 "tracks" traseros a -40º.
	if(session->getBool(PROPERTY_BUTTON7)){ pos[2]=-60; pos[3]=-60; }	// Si se pulsa el boton Nº7 "tracks" traseros a -60º.
	if(session->getBool(PROPERTY_BUTTON8)){ pos[2]=-80; pos[3]=-80; }	// Si se pulsa el boton Nº8 "tracks" traseros a -80º.
	
	if((session->getDouble(PROPERTY_AXIS6))>0){ pos[2]+=1; pos[3]+=1; } 	// Si pulsa arriba en cruceta "tracks" aumenta 1º.
	if((session->getDouble(PROPERTY_AXIS6))<0){ pos[2]-=1; pos[3]-=1; }	// Si pulsa abajo en cruceta "tracks" disminuye 1º.
	
	setDataServos(pos);
}

void GamePad2FTrackModule::modeControl4(int pos[]){
	double axis6 = session->getDouble(PROPERTY_AXIS6);
	
	if(session->getBool(PROPERTY_BUTTON5)){ 
		if(axis6 > 0){ pos[0]+=1;} // Si pulsa boton Nº5 y arriba en cruceta "track1" aumenta 1º.
		if(axis6 < 0){ pos[0]-=1;} // Si pulsa boton Nº5 y abajo en cruceta "track1" disminuye 1º.
	}
	if(session->getBool(PROPERTY_BUTTON6)){ 
		if(axis6 > 0){ pos[1]+=1;} // Si pulsa boton Nº6 y arriba en cruceta "track2" aumenta 1º.
		if(axis6 < 0){ pos[1]-=1;} // Si pulsa boton Nº6 y abajo en cruceta "track2" disminuye 1º.
	}
	if(session->getBool(PROPERTY_BUTTON7)){ 
		if(axis6 > 0){ pos[2]+=1;} // Si pulsa boton Nº7 y arriba en cruceta "track3" aumenta 1º.
		if(axis6 < 0){ pos[2]-=1;} // Si pulsa boton Nº7 y abajo en cruceta "track3" disminuye 1º.
	}
	if(session->getBool(PROPERTY_BUTTON8)){ 
		if(axis6 > 0){ pos[3]+=1;} // Si pulsa boton Nº8 y arriba en cruceta "track4" aumenta 1º.
		if(axis6 < 0){ pos[3]-=1;} // Si pulsa boton Nº8 y abajo en cruceta "track4" disminuye 1º.
	}

	setDataServos(pos);
}

// implement this if you need to force the exec to go out of the loop
// if the thread may be waiting not for the session->wait() semaphore:
// on closing, the main thread will set the exiting variables, call this exitRequested()
// function and then signal the session semaphores
// void GamePad2FTrackModule::exitRequested() { }

// implement this if you need to clean up things after the exec has exited
// void GamePad2FTrackModule::cleanup() { }

// void GamePad2FTrackModule::asyncAgentCmd(cstr cmd)
// {
//	SESSION_TRY_START(asyncSession)
//	// here you can parse 'cmd'
//	SESSION_END_CATCH_TERMINATE(asyncSession)
// }

MODULE_FACTORY(GamePad2FTrackModule);

}} // namespace
