// fichero skymegaclient.h
// declaración de la clase SkyMegaClient

#ifndef __SKYMEGACLIENT_H__
#define __SKYMEGACLIENT_H__

#include <iostream>
#include <SerialStream.h>

using namespace std;
using namespace LibSerial;

class SkyMegaClient
{
private:
	SerialStream* port;
	unsigned char servo[9];

public:
	SkyMegaClient();
	SkyMegaClient(string serial);

	void openSerial(string serial);
	void closeSerial();
	void setServoSpeed(int num_servo, int speed);
	void setServoPos(int num_servo, int pos);
	int getServoData(int num_servo);
	void sendData();
};

#endif

