// fichero skymegaclient.cpp
// funciones y operadores de la clase SkyMegaClient

#include "skymegaclient.h"

using namespace std;
using namespace LibSerial;

SkyMegaClient::SkyMegaClient():port(NULL){
	for(int i=0;i<9;i++){
		servo[i]=0;
	}
}

SkyMegaClient::SkyMegaClient(string serial):port(NULL){
	for(int i=0;i<9;i++){
		servo[i]=0;
	}
	openSerial(serial);
}

void SkyMegaClient::openSerial(string serial) // serial = "/dev/ttyUSB0"
{
	if (port != NULL ){
		closeSerial();
	}
	
	port = new SerialStream;
	port->Open(serial);
	port->SetBaudRate( SerialStreamBuf::BAUD_9600);
	port->SetCharSize( SerialStreamBuf::CHAR_SIZE_8);
	port->SetParity( SerialStreamBuf::PARITY_NONE);
	port->SetNumOfStopBits(1); 
	port->SetFlowControl( SerialStreamBuf::FLOW_CONTROL_NONE);
	
	sleep(3);		//FIXME: Necesario cierto tiempo para poder abrir el puerto
}

void SkyMegaClient::closeSerial()
{
	if (port!=NULL){
		port->Close();
		delete port;
		port = NULL;
	}
}

void SkyMegaClient::setServoSpeed(int num_servo, int speed)	// speed = [-10 a 10]  ; num_servo = [1 a 4]
{
	servo[num_servo] = 62 + speed;
}

void SkyMegaClient::setServoPos(int num_servo, int pos)		// pos = [-90 a 90]	; num_servo = [5 a 8]
{
	servo[num_servo] = 90 + pos;
}

int SkyMegaClient::getServoData(int num_servo)
{
	return servo[num_servo];
}

void SkyMegaClient::sendData()
{
	if (port == NULL){
		cerr << "Puerto serie cerrado" << endl;
		return;
	}
	
	servo[0] = 181;	// Utilizado para sincronizar el envio de datos.
	for(int i=0;i<9;i++){		
			*port << servo[i];
	}
}

