#define MODULE_NAME "FTrackClientSSModule"

#include "ftrackclientssmodule.h"
#include "ftrackclientssmodule_names.h"

#include <rdkcore/robot/robotmodule.h>
#include <rdkcore/logging/logging.h>
#include <rdkcore/ns.h>
#define LOGGING_MODULE MODULE_NAME

namespace RDK2 { namespace RAgent {

bool FTrackClientSSModule::initConfigurationProperties()
{
	SESSION_TRY_START(session)
		// put false in the second parameter if you want the module disabled for default
		// add a third parameter valued false if you don't want the state property
		Common::createDefaultProperties(session, true);
		// here you declare the properties of your module
		// in the repository they have the name of this module as prefix, e.g. /yourModuleName/maxSpeed
		
		session->createInt(PROPERTY_SERVO1, "Value of servo 1 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO1);
		session->createInt(PROPERTY_SERVO2, "Value of servo 2 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO2);
		session->createInt(PROPERTY_SERVO3, "Value of servo 3 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO3);
		session->createInt(PROPERTY_SERVO4, "Value of servo 4 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO4);
		session->createInt(PROPERTY_SERVO5, "Value of servo 5 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO5);
		session->createInt(PROPERTY_SERVO6, "Value of servo 6 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO6);
		session->createInt(PROPERTY_SERVO7, "Value of servo 7 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO7);
		session->createInt(PROPERTY_SERVO8, "Value of servo 8 (please link)", 0);
		session->setVolatile(PROPERTY_SERVO8);
		
		session->createString(PROPERTY_DEVICE, "SkyMega device", "/dev/ttyUSB0");

	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

// bool FTrackClientSSModule::initInterfaceProperties() { }

bool FTrackClientSSModule::init()
{
	// in the init() function you should initialize everything your module needs (drivers initialization,
	// sockets, and so on); all modules wait for all init() before they start
	SESSION_TRY_START(session)
		// here you can declare the events you are waiting in the main exec() loop,
		// for example:
		string device = session->getString(PROPERTY_DEVICE);
		ftrack = new SkyMegaClient(device);
		session->listenToTimer(100.);
	SESSION_END(session)
	return true;
	SESSION_CATCH_TERMINATE(session)
	return false;
}

void FTrackClientSSModule::exec()
{
	while (session->wait(), !exiting) {
		SESSION_TRY_START(session)
		//	RDK_DEBUG_PRINTF("I'm '%s', I will do something", getModuleName().c_str());
			
			ftrack->setServoSpeed(1,session->getInt(PROPERTY_SERVO1));
			ftrack->setServoSpeed(2,session->getInt(PROPERTY_SERVO2));
			ftrack->setServoSpeed(3,session->getInt(PROPERTY_SERVO3));
			ftrack->setServoSpeed(4,session->getInt(PROPERTY_SERVO4));
			ftrack->setServoPos(5,session->getInt(PROPERTY_SERVO5));
			ftrack->setServoPos(6,session->getInt(PROPERTY_SERVO6));
			ftrack->setServoPos(7,session->getInt(PROPERTY_SERVO7));
			ftrack->setServoPos(8,session->getInt(PROPERTY_SERVO8));
			
			ftrack->sendData();
			
		SESSION_END_CATCH_TERMINATE(session)
	}
}

// implement this if you need to force the exec to go out of the loop
// if the thread may be waiting not for the session->wait() semaphore:
// on closing, the main thread will set the exiting variables, call this exitRequested()
// function and then signal the session semaphores
// void FTrackClientSSModule::exitRequested() { }

// implement this if you need to clean up things after the exec has exited
void FTrackClientSSModule::cleanup()
{
	ftrack->closeSerial();
	delete ftrack;
}

// void FTrackClientSSModule::asyncAgentCmd(cstr cmd)
// {
//	SESSION_TRY_START(asyncSession)
//	// here you can parse 'cmd'
//	SESSION_END_CATCH_TERMINATE(asyncSession)
// }

MODULE_FACTORY(FTrackClientSSModule);

}} // namespace
