package utils;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

/**
 * 
 */
public final class ImageUtils{
	
	private ImageUtils(){}
	
	private static final ClassLoader CLASS_LOADER = ClassLoader.getSystemClassLoader();
	
	public static Image getImage( String filename ){
		Image image = null;
		try{
			image = ImageIO.read( new File(filename) );
		}catch( IOException e ){
			e.printStackTrace();
		}
		if( image == null )
			image = Toolkit.getDefaultToolkit().getImage( CLASS_LOADER.getResource( filename ) );
		return image;
	}
	
	public static ImageIcon getImageIcon( String filename ){
		return new ImageIcon( getImage( filename ) );
	}
	
	public static ImageIcon getImageIcon( String filename, int w, int h ){
		Image image = getImage( filename );
		if( image != null )
			return new ImageIcon( image.getScaledInstance( w, h, Image.SCALE_SMOOTH ) );
		return null;
	}
}
