package serialporttest;

import java.util.List;

import giovynet.nativelink.SerialPort;
import giovynet.serial.Baud;
import giovynet.serial.Com;
import giovynet.serial.Parameters;

public class Main {

	/**
	 * www.giovynet.com
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		try {
			SerialPort serialPort = new SerialPort();
			List<String> portsFree;
			portsFree = serialPort.getFreeSerialPort();
			/**** If there are free ports, use the first found. ****/
			if (portsFree != null && portsFree.size() > 0) {
				for (String free : portsFree) {
					System.out.println("Free port: " + free);
				}
				/**** Open the port. ****/
				Parameters parameters = new Parameters();
				parameters.setPort(portsFree.get(0));
				parameters.setBaudRate(Baud._9600);
				System.out.println("Open port: " + portsFree.get(0));
				Com com = new Com(parameters);
				/**** Send data. ****/
				String data = "Test Giovynet Driver.";
				System.out.println("<Send Data>");
				for (int i = 0; i < data.toCharArray().length; i++) {
					Thread.sleep(400);
					com.sendSingleData(data.toCharArray()[i]);
					System.out.print(data.toCharArray()[i]);
				}
				/**** Close the port. ****/
				System.out.println("\n<End Send Data>");
				com.close();
			} else {
				System.out.println("No Free ports!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
