package serial;

import giovynet.nativelink.SerialPort;
import giovynet.serial.Baud;
import giovynet.serial.Com;
import giovynet.serial.Parameters;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

/**
 * Panel que permite selecionar un puerto serie para abrir una conexión
 * y notificar dichas operaciones a los observadores registrados.
 */
@SuppressWarnings( "serial" )
public class SerialPortSelector extends JPanel{
	
	/** Lista de de observadores. */
	private final Collection<SerialPortObserver> observers;

	/**
	 * Constructor que crea, inicializa y añade los componentes que forman
	 * parte de este panel.
	 */
	public SerialPortSelector(){
		
		this.observers = new LinkedList<SerialPortObserver>();
		
		List<String> portsFree = null;
		try{
			SerialPort serialPort = new SerialPort();
			portsFree = serialPort.getFreeSerialPort();
		}catch( Exception ignorada ){
			ignorada.printStackTrace();
		}
		
		final JButton cambiarPuerto = new JButton( new AbstractAction( "Cambiar" ){
			@Override
			public void actionPerformed( ActionEvent e ){
				notifyObservers( null );
			}
		});
		cambiarPuerto.setEnabled( false );
		
		final JComboBox portsCombo = new JComboBox();
		
		if( portsFree == null || portsFree.size() == 0 ){
			portsCombo.addItem( "No hay puertos libres" );
			portsCombo.setEnabled( false );
		}else{
			portsCombo.addItem( "Seleccione el puerto Serie:" );
			for( String str: portsFree )
				portsCombo.addItem( str );
			portsCombo.setEnabled( true );
		}
			
		portsCombo.addActionListener(
			new ActionListener() {
				@Override
				public void actionPerformed( ActionEvent e ){
					if( ( (JComboBox)e.getSource() ).getSelectedIndex() != 0  ){
						String comStr = ( (JComboBox)e.getSource() ).getSelectedItem().toString();
						Com com = null;
						try{
							Parameters parameters = new Parameters();
							parameters.setPort( comStr );
							parameters.setBaudRate( Baud._9600 );
							parameters.setStopBits( "2" );
							com = new Com( parameters );
						}catch( Exception ignorada ){
							ignorada.printStackTrace();
						}
						notifyObservers( com );
					}
				}
			}
		);
		portsCombo.setEditable( false );

		add(cambiarPuerto);
		add(portsCombo);
		
		registerObserver( new SerialPortObserver(){
			@Override
			public void notifySerialPortStateChange( Com com ){
				if( com == null ){
					portsCombo.setEnabled( true );
					portsCombo.setSelectedIndex( 0 );
				}else
					portsCombo.setEnabled( false );
				cambiarPuerto.setEnabled( com != null );
			}
		});
	}
	
	/**
	 * Método que registra un nuevo observador.
	 * 
	 * @param observer Observador registrado.
	 */
	public void registerObserver( SerialPortObserver observer ){
		observers.add( observer );
	}

	/**
	 * Método que notifica a los observadores que se ha cambiado
	 * el puerto serie.
	 * 
	 * @param com Nuevo valor del puerto serie.
	 */
	void notifyObservers( Com com ){
		for( SerialPortObserver observer: observers )
			observer.notifySerialPortStateChange( com );
	}
}
