package robot.gui;

import giovynet.serial.Com;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

import robot.EstadoRobot;
import robot.comunication.Lector;
import robot.comunication.RobotObserver;
import serial.SerialPortObserver;
import serial.SerialPortSelector;

/**
 * Clase con la función principal.
 */
public final class RobotMain{
	
	private static void addComponents(
			Container container,
			SerialPortSelector selector,
			Monitor monitor,
			ButtonActions actions ){
		
		GridBagConstraints gbc = new GridBagConstraints();
		container.setLayout( new GridBagLayout() );
		
		gbc.insets.set( 5, 5, 5, 5 );
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.anchor = GridBagConstraints.NORTH;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridwidth = 4;
		gbc.gridheight = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 0.0;
		container.add( selector, gbc );
		
		gbc.insets.set( 0, 5, 5, 5 );
		gbc.gridx = 0;
		gbc.gridy = 1;
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.gridwidth = 4;
		gbc.gridheight = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		container.add( monitor, gbc );
		
		JPanel panelRutas = new JPanel();
		GridLayout layout = new GridLayout( 0, 3 );
		layout.setHgap( 6 );
		layout.setVgap( 0 );

		panelRutas.setLayout( layout );
		panelRutas.add( new JButton( actions.ruta1 ) );
		panelRutas.add( new JButton( actions.ruta2 ) );
		panelRutas.add( new JButton( actions.ruta3 ) );
		
		gbc.insets.set( 0, 5, 0, 5 );
		gbc.gridx = 0;
		gbc.gridy = 2;
		gbc.anchor = GridBagConstraints.CENTER;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.gridwidth = 4;
		gbc.gridheight = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 0.0;
		container.add( panelRutas, gbc );
		
		gbc.insets.set( 5, 5, 0, 0 );
		gbc.gridx = 0;
		gbc.gridy = 3;
		gbc.anchor = GridBagConstraints.NORTHWEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0.25;
		gbc.weighty = 0.0;
		container.add( new JButton( actions.home ), gbc );
		
		gbc.insets.set( 5, 5, 5, 0 );
		gbc.gridx = 1;
		gbc.gridy = 3;
		gbc.anchor = GridBagConstraints.NORTH;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0.25;
		gbc.weighty = 0.0;
		container.add( new JButton( actions.detener_reanudar ), gbc );
		
		JPanel panelControlManual = new JPanel();
		layout = new GridLayout( 0, 3 );
		layout.setHgap( 5 );
		layout.setVgap( 5 );
		
		panelControlManual.setLayout( layout );
		panelControlManual.add( new JLabel() );
		panelControlManual.add( new JButton( actions.avanzar ) );
		panelControlManual.add( new JLabel() );
		panelControlManual.add( new JButton( actions.girarIzq ) );
		panelControlManual.add( new JButton( actions.parar ) );
		panelControlManual.add( new JButton( actions.girarDer ) );
		panelControlManual.add( new JLabel() );
		panelControlManual.add( new JButton( actions.retroceder ) );
		panelControlManual.add( new JLabel() );
		
		gbc.insets.set( 5, 5, 5, 0 );
		gbc.gridx = 2;
		gbc.gridy = 3;
		gbc.anchor = GridBagConstraints.NORTH;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0.25;
		gbc.weighty = 0.0;
		container.add( panelControlManual, gbc );
		
		gbc.insets.set( 5, 5, 5, 5 );
		gbc.gridx = 3;
		gbc.gridy = 3;
		gbc.anchor = GridBagConstraints.NORTHEAST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.gridwidth = 1;
		gbc.gridheight = 1;
		gbc.weightx = 0.25;
		gbc.weighty = 0.0;
		container.add( new JButton( actions.cargar_descargar ), gbc );
	}

	/**
	 * Función principal que crea y muestra la ventana de control
	 * del robot.
	 * 
	 * @param args ignorados.
	 */
	public static void main( String[] args ){
		
		try{
			UIManager.setLookAndFeel( UIManager.getSystemLookAndFeelClassName() );
		}catch( Throwable ignorada ){
			ignorada.printStackTrace();
		}
		
		JFrame ventana = new JFrame( "Control Robot" );
		ventana.setDefaultCloseOperation( JFrame.EXIT_ON_CLOSE );
		ventana.setResizable( false );
		
		SerialPortSelector selector = new SerialPortSelector();
		
		final Monitor monitor = new Monitor();
		final ButtonActions actions = new ButtonActions();
		final Lector lector = new Lector();
		
		lector.registerObserver( new RobotObserver(){
			@Override
			public void notifyRobotStateChange( EstadoRobot estado ){
				monitor.setEstado( estado );
				actions.setEstado( estado );
			}
		});
		
		selector.registerObserver( new SerialPortObserver(){
			@Override
			public void notifySerialPortStateChange( Com com ){
				monitor.setEnabled( com != null );
				actions.setCom( com );
				lector.setCom( com );
			}
		});
		
		addComponents( ventana.getContentPane(), selector, monitor, actions );
		ventana.pack();
		ventana.setVisible( true );
		
		lector.start();
	}
}
