package robot;

/**
 * Definiciones de máscaras 
 */
public final class Definitions{

	private Definitions(){}
	
	public static final byte BUMPER_IZQ_MASK     =(byte) 0x04;
	public static final byte BUMPER_DER_MASK     =(byte) 0x02;
	
	public static final byte SENSOR_DEL_IZQ_MASK = (byte)0x01;
	public static final byte SENSOR_DEL_DER_MASK = (byte)0x20;
	public static final byte SENSOR_CEN_IZQ_MASK = (byte)0x40;
	public static final byte SENSOR_CEN_DER_MASK = (byte)0x80;
	
	public static final byte RUDEDA_IZQ_MASK     =(byte) 0x06;
	
	public static final byte RUDEDA_IZQ_ATRAS    =(byte) 0x06;
	public static final byte RUDEDA_IZQ_ADELANTE =(byte) 0x04;
	
	public static final byte RUDEDA_DER_MASK     =(byte) 0x18;
	
	public static final byte RUDEDA_DER_ATRAS    =(byte) 0x10;
	public static final byte RUDEDA_DER_ADELANTE = (byte)0x18;
	
	public static final byte LED_MASK            = (byte)0x02;
	
	public static final byte CABECERA            = (byte)0xF0;
	
	/**
	 *   Emergencia | Carga | Control | ..................
	 *   -----------+-------+---------+-------------------
	 *      1 Bit   | 1 Bit | 2 Bits  |  xxxxxxxxxxxxxxxxx 
	 *   -----------+-------+---------+-------------------
	 *              |       |  HOME   |  xxxxxxxxxxxxxxxxx        
	 *   -----------+-------+---------+----------+--------
	 *              |       |  AUTO   | Sentido  |  Ruta
	 *   -----------+-------+---------+----------+--------
	 *              |       |         |  2 Bits  | 2 Bits
	 *   -----------+-------+---------+----------+--------
	 *              |       |  MANUAL |        Orden
	 *   -----------+-------+---------+-------------------
	 *              |       |         |        4 Bits
	 */
	
	public static final byte EMERGENCIA_MASK     = (byte)0x80;
	public static final byte CARGA_MASK          = (byte)0x40;
	
	public static final byte CONTROL_MASK        = (byte)0x30;
	public static final byte CONTROL_HOME        = (byte)0x30;
	public static final byte CONTROL_AUTO        = (byte)0x20;
	public static final byte CONTROL_MANUAL      = (byte)0x10;
	
	public static final byte SENTIDO_MASK        = (byte)0x0C;
	public static final byte SENTIDO_IDA         = (byte)0x08;
	public static final byte SENTIDO_VUELTA      = (byte)0x04;
	
	public static final byte RUTA_MASK           = (byte)0x03;
	
	public static final byte MOVIMIENTO_MASK     = (byte)0x0F;
	
	public static final byte MOVIMIENTO_ADELANTE = (byte)0x09;
	public static final byte MOVIMIENTO_ATRAS    = (byte)0x0A;
	public static final byte MOVIMIENTO_GIRO_IZQ = (byte)0x0B;
	public static final byte MOVIMIENTO_GIRO_DER = (byte)0x0C;
	public static final byte MOVIMIENTO_PARAR    = (byte)0x0D;
	
	//Orden parada de emergencia
	public static final int ORD_EMERGENCIA       = EMERGENCIA_MASK;

	//Manuales Especiales
	public static final int ORD_HOME             = CONTROL_HOME;
	public static final int ORD_CARGA_DESCARGA   = CARGA_MASK;
	
	//Manuales Especiales
	public static final int ORD_ADELANTE         = CONTROL_MANUAL | MOVIMIENTO_ADELANTE ;
	public static final int ORD_ATRAS            = CONTROL_MANUAL | MOVIMIENTO_ATRAS ;
	public static final int ORD_GIRO_IZQ         = CONTROL_MANUAL | MOVIMIENTO_GIRO_IZQ ;
	public static final int ORD_GIRO_DER         = CONTROL_MANUAL | MOVIMIENTO_GIRO_DER ;
	public static final int ORD_PARAR            = CONTROL_MANUAL | MOVIMIENTO_PARAR ;

	//Automaticas
	public static final int ORD_CAMINO_IZQ       = CONTROL_AUTO | 0x01;
	public static final int ORD_CAMINO_RECTO     = CONTROL_AUTO | 0x02;
	public static final int ORD_CAMINO_DER       = CONTROL_AUTO | 0x03;

}