/*
 * Decompiled with CFR 0.152.
 */
package giovynet.serial;

import giovynet.nativelink.SerialPort;
import giovynet.serial.ActionListenerReadPort;
import giovynet.serial.Buffer;
import giovynet.serial.Parameters;
import giovynet.serial.TaskParallel;

public class Com
extends SerialPort {
    private Parameters parameters;
    private String port;
    private Task task;
    private Buffer buffer;
    private int data;

    public Com(Parameters parameters) throws Exception {
        this.parameters = parameters;
        this.buffer = new Buffer();
        this.port = parameters.getPort();
        SerialPort serial = new SerialPort();
        if (SerialPort.OS.equals("Linux")) {
            serial.openPortC(parameters.getPort(), parameters.getBaudRate(), parameters.getByteSize(), parameters.getStopBits(), parameters.getParity());
        } else {
            serial.openPortC("\\\\.\\" + parameters.getPort(), parameters.getBaudRate(), parameters.getByteSize(), parameters.getStopBits(), parameters.getParity());
        }
        serial.setTimeOutSerialPortC(parameters.getPort(), parameters.getReadInterval(), parameters.getReadTotalConstant(), parameters.getReadTotalMultiplier(), parameters.getWriteTotalConstant(), parameters.getWriteTotalMultiplier());
        serial = null;
    }

    public void sendString(String data) throws Exception {
        SerialPort serial = new SerialPort();
        if (SerialPort.OS.equals("Linux")) {
            throw new ActionListenerReadPortException("Operation not supported in Linux.");
        }
        for (int i = 0; i < data.length(); ++i) {
            if (this.parameters.getMinDelayWrite() > 0) {
                Thread.sleep(this.parameters.getMinDelayWrite());
                serial.writePortC(this.port, data.substring(i, i + 1));
                continue;
            }
            serial.writePortC(this.port, data.substring(i, i + 1));
        }
        serial = null;
    }

    public void sendArrayChar(char[] data) throws Exception {
        SerialPort serial = new SerialPort();
        for (int i = 0; i < data.length; ++i) {
            if (this.parameters.getMinDelayWrite() > 0) {
                Thread.sleep(this.parameters.getMinDelayWrite());
                serial.writePortC(this.port, data[i]);
                continue;
            }
            serial.writePortC(this.port, data[i]);
        }
        serial = null;
    }

    public String receiveToString(int amount) throws Exception {
        SerialPort serial = new SerialPort();
        StringBuffer store = new StringBuffer();
        for (int i = 0; i < amount; ++i) {
            if (this.parameters.getMinDelayRead() > 0) {
                Thread.sleep(this.parameters.getMinDelayRead());
                store.append((char)serial.readDataInt(this.port));
                continue;
            }
            store.append((char)serial.readDataInt(this.port));
        }
        serial = null;
        return store.toString();
    }

    public void receiveToStringBuilder(int untilAmount, StringBuilder stringBuilder) throws Exception {
        SerialPort serial = new SerialPort();
        for (int i = 0; i < untilAmount; ++i) {
            if (this.parameters.getMinDelayRead() > 0) {
                Thread.sleep(this.parameters.getMinDelayRead());
                stringBuilder.append((char)serial.readDataInt(this.port));
                continue;
            }
            stringBuilder.append((char)serial.readDataInt(this.port));
        }
        serial = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String receiveSingleString() throws Exception {
        SerialPort serial = new SerialPort();
        if (this.parameters.getMinDelayRead() > 0) {
            Thread.sleep(this.parameters.getMinDelayRead());
        }
        try {
            String string = serial.readPortC(this.port);
            return string;
        }
        finally {
            serial = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char receiveSingleChar() throws Exception {
        SerialPort serial = new SerialPort();
        if (this.parameters.getMinDelayRead() > 0) {
            Thread.sleep(this.parameters.getMinDelayRead());
        }
        try {
            char c = serial.readPortLikeCharC(this.port);
            return c;
        }
        finally {
            serial = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receiveSingleDataInt() throws Exception {
        SerialPort serial = new SerialPort();
        if (this.parameters.getMinDelayRead() > 0) {
            Thread.sleep(this.parameters.getMinDelayRead());
        }
        try {
            int n = serial.readDataInt(this.port);
            return n;
        }
        finally {
            serial = null;
        }
    }

    public void sendSingleData(String data) throws Exception {
        SerialPort serial = new SerialPort();
        if (this.parameters.getMinDelayWrite() > 0) {
            Thread.sleep(this.parameters.getMinDelayWrite());
        }
        serial.writePortC(this.port, data);
        serial = null;
    }

    public void sendSingleData(char data) throws Exception {
        SerialPort serial = new SerialPort();
        if (this.parameters.getMinDelayWrite() > 0) {
            Thread.sleep(this.parameters.getMinDelayWrite());
        }
        serial.writePortC(this.port, data);
        serial = null;
    }

    public void sendSingleData(int data) throws Exception {
        SerialPort serial = new SerialPort();
        if (this.parameters.getMinDelayWrite() > 0) {
            Thread.sleep(this.parameters.getMinDelayWrite());
        }
        serial.writeDataInt(this.port, data);
        serial = null;
    }

    public void close() throws Exception {
        SerialPort serial = new SerialPort();
        serial.closePortC(this.port);
        serial = null;
    }

    public void addActionListenerReadPort(ActionListenerReadPort actionListenerReadPort) throws ActionListenerReadPortException {
        if (SerialPort.OS.equals("Linux")) {
            throw new ActionListenerReadPortException("Operation not supported in Linux.");
        }
        try {
            if (this.task != null) {
                throw new ActionListenerReadPortException("There is already an ActionListenerReadPort defined");
            }
            this.task = new Task(actionListenerReadPort);
            this.task.on();
        }
        catch (Exception e) {
            throw new ActionListenerReadPortException(e.toString());
        }
    }

    public void removeActionListenerReadPort() throws ComException {
        if (SerialPort.OS.equals("Linux")) {
            throw new ComException("Operation not supported in Linux.");
        }
        if (this.task == null) {
            throw new ComException("No ActionListenerReadPort defined.");
        }
        this.task.off();
        this.task.halt();
        this.task = null;
    }

    public class ActionListenerReadPortException
    extends Exception {
        public ActionListenerReadPortException(String message) {
            super(message);
        }
    }

    public class ComException
    extends Exception {
        public ComException(String message) {
            super(message);
        }
    }

    private class Task
    extends TaskParallel {
        private ActionListenerReadPort alrp;

        public Task(ActionListenerReadPort actionListenerReadPort) {
            this.alrp = actionListenerReadPort;
            this.setPriority(10);
        }

        public void loopTask() {
            try {
                Com.this.data = 0;
                Com.this.data = Com.this.receiveSingleDataInt();
                while (Com.this.data != 0) {
                    Com.this.buffer.getBufferInIntegerList().add(Com.this.data);
                    Com.this.data = Com.this.receiveSingleDataInt();
                    if (Com.this.data != 0) continue;
                    this.alrp.tryActionPerformed(Com.this.buffer);
                }
                this.yield();
            }
            catch (Exception e) {
                this.alrp.catchActionPerformed(e);
            }
        }
    }
}

