/*
 * Decompiled with CFR 0.152.
 */
package giovynet.nativelink;

import giovynet.nativelink.InfoSystem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialPort {
    public static String OS;

    public List<String> getFreeSerialPort() throws Exception {
        try {
            ArrayList<String> data = new ArrayList<String>();
            if (OS.equals("Linux")) {
                for (int i = 0; i < 41; ++i) {
                    if (this.getStateSerialPortC("/dev/ttyS" + i).equals("free")) {
                        data.add("COM" + i);
                    }
                    if (!this.getStateSerialPortC("/dev/ttyUSB" + i).equals("free")) continue;
                    data.add("COMUSB" + i);
                }
            } else {
                for (int i = 0; i < 40; ++i) {
                    if (!this.getStateSerialPortC("\\\\.\\COM" + i).equals("free")) continue;
                    data.add("COM" + i);
                }
            }
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public native String getStateSerialPortC(String var1);

    public native int openPortC(String var1, String var2, String var3, String var4, String var5);

    public native int setTimeOutSerialPortC(String var1, int var2, int var3, int var4, int var5, int var6);

    public native String readPortC(String var1);

    public native char readPortLikeCharC(String var1);

    public native int writePortC(String var1, String var2);

    public native int writePortC(String var1, char var2);

    public native void writeDataInt(String var1, int var2);

    public native int readDataInt(String var1);

    public native int closePortC(String var1);

    static {
        try {
            InfoSystem sys = new InfoSystem();
            OS = sys.getOSName();
            if (OS.equals("Linux")) {
                System.load(sys.getUserDir() + "/libSOSerialPort.so");
            } else {
                System.loadLibrary("libSerialPort");
            }
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

