module hinge_ear_center(d,w,h,l,off_dx,round=true)
{

    union() {
      difference() {

      union() {
          translate([-h/4,0,0])
            cube([h/2,w,h],center=true);

          if (round) {
            rotate([90,0,0])
              cylinder(r=h/2,h=w,center=true,$fn=50);
          }
          else {
            cube([h,w,h],center=true);
          }
      }

      //-- Drill
      translate([off_dx,0,0])
        rotate([90,0,0])
          cylinder(r=d/2, h=2*w,center=true, $fn=50);
    }

    translate([-h/2,0,0])
      translate([-l/2,0,0])
        cube([l,w,h],center=true);
  }
}


module hinge_ear(d=3, l=0, h=6, w=4, off_dx=0,center=true,round=true)
{

  if (center) {
    hinge_ear_center(d,w,h,l,off_dx,round);
  }
  else {
    translate([h/2+l,0,0])
     hinge_ear_center(d,w,h,l,off_dx,round);
  }  

}

hinge_ear(off_dx=-0.5,l=2,round=false);

