use <hinge_ear.scad>

//-- Global parameters

//-- Eye frame outer dimensions
lx=50;
ly=25;
lz=3;
w=3; //-- Frame width

//-- Bridge width
bw = 7.5;

//-- Bridge length
bl = 10;

//-- Leg1 length
l1l = 50;

//-- Leg2 length
l2l=50;

//-- Clearence between the two hinges
cw=0.5;

//-- Tolerance
t=0.001;

//-- Hinge parameters
  d=3;
  hz=6;
  hw=4;
  hl = 1.5;
  h_off_dx=-0.5;

module eye_frame() 
{

  //-- Draw the eye-frame
  union() {
    difference() {
    cube([lx,ly,lz], center=true); 
    cube([lx-w*2, ly-w*2, lz*5],center=true);
  }

  union() {

      //-- Upper right hinge
      translate([lx/2, ly/2-hw, -lz/2])
      translate([0, hw/2, hz/2])
        hinge_ear(w=hw,l=hl, h=hz, off_dx=h_off_dx, center=false);

      translate([lx/2-w/2, hw/2 + ly/2 -hw, lz/2])
      cube([w,hw,hz],center=true);

      //-- Bottom right left hinge
     translate([lx/2,  ly/2-hw,  -lz/2])
      translate([0,  hw/2-hw-cw-bw, hz/2])
        hinge_ear(w=hw,l=hl, h=hz, off_dx=h_off_dx, center=false);

      translate([ lx/2-w/2,  hw/2-hw + ly/2 -hw-cw-bw, lz/2])
      cube([w,hw,hz],center=true);

      //-- Upper Left hinge
      translate([-lx/2,ly/2-hw,-lz/2])
      translate([-hz/2-1+w, hw/2,0])
      rotate([0,90,0])
      mirror([1,0,0])
      hinge_ear(w=hw, l=hl+lz, h=hz+2, off_dx=h_off_dx, center=false);
     

     //-- Bottom left hinge
      translate([-lx/2,ly/2-hw-hw-cw-bw,-lz/2])
      translate([-hz/2-1+w, hw/2,0])
      rotate([0,90,0])
      mirror([1,0,0])
      hinge_ear(w=hw, l=hl+lz, h=hz+2, off_dx=h_off_dx, center=false);
    }

  }
}

module bridge() 
{

//-- Bridge --
  mirror([1,0,0])
    hinge_ear(w=bw,l=hl, h=hz, off_dx=h_off_dx, center=false);

  hinge_ear(w=bw,l=bl, h=hz, off_dx=h_off_dx, center=false);
}



module leg1()
{

  union() {

     mirror([1,0,0])
      hinge_ear(w=bw,l=l1l, h=hz, off_dx=h_off_dx,center=false);

     translate([-4,hw/2+bw/2,0])
       hinge_ear(w=hw, h=hz, l=hl+4, off_dx=h_off_dx, center=false);

     translate([-4, -hw/2-bw/2,0])
       hinge_ear(w=hw, l=hl+4, h=hz, off_dx=h_off_dx, center=false);

  }  

}

module leg2()
{

     mirror([1,0,0])
      hinge_ear(w=bw-2*cw,l=l2l, h=hz, off_dx=h_off_dx,center=false);

    cylinder(r=bw/2-cw, h=hz,center=true, $fn=50);

  rotate([0,0,-45])
  union() {
    translate([20/2,0,0])
     cube([20,bw-2*cw,hz],center=true);

     translate([20,0,0])
      cylinder(r=bw/2-cw, h=hz,center=true, $fn=50);
  }
 
}



//mirror([1,0,0]) eye_frame();
//eye_frame();
//bridge();
//leg1();
//translate([60,0,0])
   leg2();



