//-- U-piece for joining two servo Futaba 3003 together
//-- This piece has two drills
//-- (c) Juan Gonzalez-Gomez (Obijuan) Nov-2010
//-- GPL License

use <U_piece.scad>

//--------------------------------------------------------
//-- Input parameters:
//--  l: Length
//--  w: Width
//--  h: height
//--  thick
//--  Drills diameter
//---------------------------------------------------------
module Futaba_U_union2(l=47, w=10, h=20, thick=3, drill=3)
{
  //-- Parameters for the Futaba 3003 holes
  //-- Distrance from the base (1st drill)
  zd=5.2;
  
  //-- Distance from one side
  xd=4.1;

  //-- Distance between drills
  dd=9.6;

  difference() {
    U_piece(l, w, h, thick);

    translate([w/2-xd,0,thick/2+zd])
      rotate([90,0,0])
        cylinder(h=l*1.5, r=drill/2, center=true, $fn=20);

    translate([w/2-xd,0,thick/2+zd+dd])
      rotate([90,0,0])
        cylinder(h=l*1.5, r=drill/2, center=true, $fn=20);
  }
}

//-- Render the piece
Futaba_U_union2();