#-------------------------------------------------------------------------------
#--  wiimote_2D.py
#--  Movimiento de punto en 2D
#-------------------------------------------------------------------------------
#-- Carlos Pastor
#-------------------------------------------------------------------------------

# Importar modulos
import sys
import cwiid
import math
import time
import decimal
import consola_io
import pygame

def menu():
  print """
  
     Menu de opciones
     ----------------
     
     1.- Opcion 1= Mando en mano
     2.- Opcion 2= Mando en gorra
     
  SP.- Volver a sacar el menu
  ESC.- Terminar
  """

def lee_pitch_roll(wiimote):
	# Leer el calibrado
  	ext_type = wiimote.state['ext_type']
 	cal = wiimote.get_acc_cal(ext_type)

	# Leer las aceleraciones
 	acc = wiimote.state['acc']

	#Calcular las aceleraciones normalizadas
	a_x = float( acc[cwiid.X] - cal[0][cwiid.X] ) / float( cal[1][cwiid.X] - cal[0][cwiid.X] )

  	a_y = float( acc[cwiid.Y] - cal[0][cwiid.Y] ) / float( cal[1][cwiid.Y] - cal[0][cwiid.Y] )

	a_z = float( acc[cwiid.Z] - cal[0][cwiid.Z] ) / float( cal[1][cwiid.Z] - cal[0][cwiid.Z] )

	#Calcular pitch y roll
	if a_z!=0:
	    roll = math.atan(a_x/a_z);
	else:
	    roll = math.pi/2;

	if (a_z<=0.0):
	    if (a_x!=0):
	      signo = (a_x/a_x)
	      roll += math.pi * signo
	    else:
	      roll += math.pi

	roll *= -1
	divisor = a_z*math.cos(roll)
	    
	if divisor!=0:
		pitch = math.atan(a_y/a_z*math.cos(roll))
	else:
		pitch=0

	#Pasar pitch y roll a grados
  	roll = roll * 180.0/math.pi
  	pitch = pitch * 180.0/math.pi

	return (pitch, roll)

#Comienzo programa
led=0;
reintentos=0;
ok=False;
blue = 0, 0, 255
black = 0, 0, 0
white = 255, 255, 255
red= 255, 0, 0
mano=0
gorra=0

print 'Pulsa las teclas 1+2 en el Wiimote......'

#Establecer conexion con Wiimote
while reintentos<3 and not ok:
  try:
    print "Reintento ",reintentos
    if len(sys.argv) > 1:
      wiimote = cwiid.Wiimote(sys.argv[1])
    else:
      wiimote = cwiid.Wiimote()
    ok=True
  except RuntimeError, msg:
    print "Error: ",msg
    reintentos+=1;

#Si se superan los reintentos, terminar
if reintentos==3:
  print "Sin conexion con wiimote despues de "+repr(reintentos)+" reintentos"
  sys.exit(1)

#Conexion establecida
#Encender el led 1 del wiimote
wiimote.led = cwiid.LED1_ON

#Activar acelerometros
wiimote.rpt_mode = cwiid.RPT_ACC

#Sacar menu, leer tecla y procesarla
menu()
c = consola_io.getkey()
  
#Procesar tecla
if   c=='1': 
	mano=1
elif c=='2': 
	gorra=1
elif c==' ': 
	menu()

#Configurar pygame
pygame.init()
size = width, height = 640, 400
screen = pygame.display.set_mode(size)
pygame.display.set_caption("Wiimote_2D")

#Coordenadas para el centro del control
cox = width/2
coy = height/2

#Bucle principal
while 1:	
	
  	for eventos in pygame.event.get():
  		if eventos.type == pygame.QUIT :
  	  	    sys.exit(0)

	(pitch,roll) = lee_pitch_roll(wiimote)

	#Limitando accion de pitch y roll a giros de 90
	if mano==1:
		if pitch>90:
			pitch=90
		if pitch<-90:
			pitch=-90
		if roll>90:
			roll=90
		if roll<-90:
			roll=-90
	#Limitando accion de pitch y roll a giros de 22.5
	if gorra==1:
		if pitch>22.5:
			pitch=22.5
		if pitch<-22.5:
			pitch=-22.5
		if roll>22.5:
			roll=22.5
		if roll<-22.5:
			roll=-22.5
	

	#Borrar lo que habia antes
 	screen.fill(white)
  
  	#Dibujar ejes y punto
        pygame.draw.aaline (screen, black, (cox-cox, coy), (cox+cox, coy),5)
        pygame.draw.aaline (screen, black, (cox, coy-coy), (cox, coy+coy),5)
	
	#Pasar a decimal y cuantizar numero de cifras decimales
	TWOPLACES = decimal.Decimal(repr(0.01))
	rn=decimal.Decimal(repr(roll)).quantize(TWOPLACES)
	pn=decimal.Decimal(repr(pitch)).quantize(TWOPLACES)
	
	#Para mando en posicion perpendicular a la pantalla(mano) cox-rn y coy+pn
	#Para mando en posicion paralela a la pantalla(gorra) cox-pn y coy+rn 
	if mano==1:
		dox=cox-(rn*width/180)
		doy=coy+(pn*height/180)
	if gorra==1:
		dox=cox-(pn*width/45)
		doy=coy-(rn*height/45)	
	
	pygame.draw.circle(screen, red, (dox,doy),5,0)
       
  	#Refrescar pantalla
  	pygame.display.flip()
  	time.sleep(0.1)

