#-------------------------------------------------------------------------------
#--  wii_mancuerna.py
#--  Aplicacion de seguimiento de puntero led y representacion en 2D
#-------------------------------------------------------------------------------
#-- Carlos Pastor
#-------------------------------------------------------------------------------

#Importar modulos
import sys
import cwiid
import math
import time
import pygame
import wave
import os

#Variables
led=0;
reintentos=0;
ok=False;
blue = 0, 0, 255
black = 0, 0, 0
white = 255, 255, 255
red= 255, 0, 0
ceroX2=0
ceroY2=0

print 'Pulsa las teclas 1+2 en el Wiimote......'

#Establecer conexion con Wiimote
while reintentos<3 and not ok:
  try:
    print "Reintento ",reintentos
    if len(sys.argv) > 1:
      wiimote = cwiid.Wiimote(sys.argv[1])
    else:
      wiimote = cwiid.Wiimote()
    ok=True
  except RuntimeError, msg:
    print "Error: ",msg
    reintentos+=1;

#Si se superan los reintentos, terminar
if reintentos==3:
  print "Sin conexion con wiimote despues de "+repr(reintentos)+" reintentos"
  sys.exit(1)

#Conexion establecida
#Encender el led 1 del wiimote
wiimote.led = cwiid.LED1_ON  

#Activar ir
wiimote.rpt_mode = cwiid.RPT_IR 

#Configurar pygame
pygame.init()
size = width, height = 512, 384
screen = pygame.display.set_mode(size)
pygame.display.set_caption("Wii_mancuerna")

#Coordenadas para el centro del control
cox = width/2
coy = 2*height/3

#Calibracion de la aplicacion
print 'Coloque brazo en posicion inicial'

time.sleep( 10 )

state = wiimote.state

if 'ir_src' in state:

    src= state['ir_src'][0]
    if src:         
        posCal2=src['pos']
	print posCal2			
	ceroX2=posCal2[0]
	ceroY2=posCal2[1]

print 'Calibrado OK'

time.sleep(2)

#Comienzo de la aplicacion
print 'Go!'
while 1:
	screen.fill(white)
	pygame.draw.circle(screen,blue, (cox,coy),5,0)
	font = pygame.font.Font(None, 20)

	#Dibujar ejes y punto
     	pygame.draw.aaline (screen, black, (cox-(width/4), coy), (cox+cox, coy),5)
        pygame.draw.aaline (screen, black, (cox, coy-coy), (cox, coy+(height/6)),5)

	for eventos in pygame.event.get():
  		if eventos.type == pygame.QUIT :
  	  	    sys.exit(0)

	state = wiimote.state

	if 'ir_src' in state:
           for src in state['ir_src']:
               if src:
                        posicion=src['pos']
			cx=posicion[0]
			cy=posicion[1]
			
			xp=1023-cx			
			yp=cy-ceroY2
			
			#Calculo del angulo del brazo respecto a la horizontal
			angulo=math.atan2(yp,xp)
			anguloGrados= math.degrees(angulo)

			#Representacion en pantalla de valores
			text_angulo = font.render('Angulo: ', True, black, white)
			text_anguloN = font.render(repr(anguloGrados), True, black, white)
			screen.blit(text_angulo, (50, 50))
			screen.blit(text_anguloN, (100, 50))
			pygame.draw.aaline (screen, red, (cox, coy), (cox+xp, coy-yp))
					
	pygame.display.flip()
	
	time.sleep(0.1)

