#-------------------------------------------------------------------------------
#--  pong_wiimote.py
#--  Clasico juego pong adaptado para que el jugador 1 use un wiimote como 
#--	interfaz de control
#-------------------------------------------------------------------------------
#-- Carlos Pastor
#-------------------------------------------------------------------------------

#Importar modulos
import pygame
from pygame.locals import Rect, K_ESCAPE, QUIT, KEYDOWN, KEYUP, K_UP, K_DOWN, K_q, K_a
import sys
import math
import cwiid

#Variables
SCREEN_DIMENSIONS = (800, 600)
screen = None
clock = None
paddle1 = None
paddle2 = None
ball = None

#Datos de wiimote
reintentos=0
ok=False
pitchPrev=0
    
#Establecer conexion con Wiimote
while reintentos<3 and not ok:
	try:
	    print "Reintento ",reintentos
            if len(sys.argv) > 1:
              wiimote = cwiid.Wiimote(sys.argv[1])
    	    else:
      	      wiimote = cwiid.Wiimote()
            ok=True
        except RuntimeError, msg:
    	    print "Error: ",msg
    	    reintentos+=1;

	#Si se superan los reintentos, terminar
	if reintentos==3:
	  print "Sin conexion con wiimote despues de "+repr(reintentos)+" reintentos"
	  sys.exit(1)

	#Encender el led 1 del wiimote
	wiimote.led = cwiid.LED1_ON

	#Activar acelerometros
	wiimote.rpt_mode = cwiid.RPT_ACC

#Rutina de inicio
def main():
    global screen
    global clock
    global SCREEN_DIMENSIONS
    
    #Inicializando todo lo relacionado con Pygame
    pygame.init()
    screen = pygame.display.set_mode( SCREEN_DIMENSIONS )
    pygame.display.set_caption("Pong_wiimote")
    clock = pygame.time.Clock()
    initData()
    mainLoop() 

#Inicializacion de estructuras de datos
def initData():
    global paddle1
    global paddle2
    global ball
     
    paddle1 = Paddle(30, 300)
    paddle2 = Paddle(770, 300)
    ball = Ball(400, 300, 3, 3)
        
#Bucle principal
def mainLoop():
    global clock

    while True:
	renderScreen()
        readInput()
        updateState()
        clock.tick(120)

#Funcion que dibuja la pantalla
def renderScreen():
    global screen

    s = screen
    s.lock()
    s.fill(0)
    s.fill(0xffffff, Rect(ball.left(), ball.top(), ball.width, ball.height))
    s.fill(0xccccff, Rect(paddle1.left(), paddle1.top(), paddle1.width, paddle1.height))
    s.fill(0xccccff, Rect(paddle2.left(), paddle2.top(), paddle2.width, paddle2.height))
    s.unlock()
    pygame.display.update()

#Lectura de la entrada de teclado y eventos del wiimote
def readInput():
    global paddle1
    global paddle2
    global pitchPrev
    
    pitch = lee_pitch_roll(wiimote)
   	 
    paddle1.dy=0.2*abs(pitch)
    paddle2.dy=8

    for event in pygame.event.get():
	if event.type == QUIT:
 	   quit()
	elif event.type == KEYDOWN:
	   if event.key == K_ESCAPE:
	      quit()
	   elif event.key == K_UP:
	      paddle2.joystick.up = True
	   elif event.key == K_DOWN:
	      paddle2.joystick.down = True
	elif event.type == KEYUP:
	   if event.key == K_UP:
	      paddle2.joystick.up = False
	   elif event.key == K_DOWN:
	      paddle2.joystick.down = False

    if abs(pitch-pitchPrev)> 0.5:
	    if pitch < 0:
		paddle1.joystick.up = True
	    else:
		paddle1.joystick.up= False
	    if pitch > 0:
		paddle1.joystick.down= True
	    else:
		paddle1.joystick.down = False
    else:
	    paddle1.joystick.up= False
	    paddle1.joystick.down= False

    pitchPrev=pitch
 
#Actualizar estado del juego
def updateState():
    global paddle1
    global paddle2
    global ball
     
    if (paddle1.joystick.up):
        paddle1.moveUp()
    elif (paddle1.joystick.down):
        paddle1.moveDown()
 
    if (paddle2.joystick.up):
        paddle2.moveUp()
    elif (paddle2.joystick.down):
        paddle2.moveDown()
         
    ball.update(paddle1, paddle2)


#Obtener pitch y roll a partir de aceleraciones
def lee_pitch_roll(wiimote):
	# Leer el calibrado
  	ext_type = wiimote.state['ext_type']
 	cal = wiimote.get_acc_cal(ext_type)

	# Leer las aceleraciones
 	acc = wiimote.state['acc']

	# Calcular las aceleraciones normalizadas
	a_x = float( acc[cwiid.X] - cal[0][cwiid.X] ) / float( cal[1][cwiid.X] - cal[0][cwiid.X] )

  	a_y = float( acc[cwiid.Y] - cal[0][cwiid.Y] ) / float( cal[1][cwiid.Y] - cal[0][cwiid.Y] )

	a_z = float( acc[cwiid.Z] - cal[0][cwiid.Z] ) / float( cal[1][cwiid.Z] - cal[0][cwiid.Z] )

	#Calcular pitch y roll
	if a_z!=0:
	    roll = math.atan(a_x/a_z);
	else:
	    roll = math.pi/2;
	if (a_z<=0.0):
	    if (a_x!=0):
	      signo = (a_x/a_x)
	      roll += math.pi * signo
	    else:
	      roll += math.pi

	roll *= -1

	divisor = a_z*math.cos(roll)
	    
	if divisor!=0:
		pitch = math.atan(a_y/a_z*math.cos(roll))
	else:
		pitch=0

	#Pasar pitch a grados
  	pitch = pitch * 180.0/math.pi

	return (pitch)

#Clase joystick
class Joystick:
    up = False
    down = False

#Clase bola
class Ball:
    x = 0
    y = 0
    dx = 0
    dy = 0
    width = 10
    height = 10
 
    def __init__(self, x, y, dx, dy):
        self.x = x
        self.y = y
        self.dx = dx
        self.dy = dy
       
    def top(self):
        return self.y - self.height/2
     
    def left(self):
        return self.x - self.width/2

    def update(self, paddle1, paddle2):
        #Actualizo posicion
        self.x += self.dx
        self.y += self.dy
         
        #Deteccion de colision con las paletas
        if paddle1.collides((self.x, self.y)):
            self.dx = -self.dx
        if paddle2.collides((self.x, self.y)):
            self.dx = -self.dx
         
        #Deteccion de colision con los bordes de la ventana
        if (self.x < 0):
            self.x = 1
            self.dx = -self.dx
        if (self.x > SCREEN_DIMENSIONS[0]):
            self.x = SCREEN_DIMENSIONS[0]-1
            self.dx = -self.dx  
        if (self.y < 0):
            self.y = 1
            self.dy = -self.dy
        if (self.y > SCREEN_DIMENSIONS[1]):
            self.y = SCREEN_DIMENSIONS[1]-1
            self.dy = -self.dy

#Clase paleta
class Paddle:
    x = 0
    y = 0
    #Velocidad vertical de la paleta
    dy = 0
    width = 10
    height = 120
    joystick = None
     
    def __init__(self, x, y):
        self.x = x
        self.y = y
        self.joystick = Joystick()
         
    def top(self):
        return self.y - self.height/2

    def bottom(self):
        return self.y + self.height/2
  
    def left(self):
        return self.x - self.width/2
     
    def right(self):
        return self.x + self.width/2
   
    def moveUp(self):
        self.y -= self.dy
        self.y = max([self.height/2, self.y])
        
    def moveDown(self):
        self.y += self.dy
        self.y = min([self.y, SCREEN_DIMENSIONS[1]-self.height/2])
   
    def collides(self, point):
        return (point[0] >= self.left() and point[0] <= self.right()) and (point[1] >= self.top() and point[1] <= self.bottom())

#Inicio del juego
main()

