#-------------------------------------------------------------------------------
#--  pong_wiiboard.py
#--  Clasico juego pong adaptado para que el jugador use la wiiboard como 
#--	interfaz de control
#-------------------------------------------------------------------------------
#-- Carlos Pastor
#-------------------------------------------------------------------------------

# Importar modulos
import pygame
from pygame.locals import Rect, K_ESCAPE, QUIT, KEYDOWN, KEYUP, K_UP, K_DOWN, K_q, K_a
import sys
import math
import cwiid
import time

#Variables
SCREEN_DIMENSIONS = (800, 600)
screen = None
clock = None
paddle1 = None
paddle2 = None
ball = None

#Datos de WiiBoard
reintentos=0
ok=False
yPrevi,yPrevd=0,0
    
print 'Pulsa el boton de sync de la wiiboard (donde estan las pilas)...'

#Establecer conexion con la WiiBoard
while reintentos<3 and not ok:
	try:
	    print "Reintento ",reintentos
            if len(sys.argv) > 1:
              wiimote = cwiid.Wiimote(sys.argv[1])
    	    else:
      	      wiimote = cwiid.Wiimote()
            ok=True
        except RuntimeError, msg:
    	    print "Error: ",msg
    	    reintentos+=1;

	#Si se superan los reintentos, terminar
	if reintentos==3:
	  print "Sin conexion con wiimote despues de "+repr(reintentos)+" reintentos"
	  sys.exit(1)

	#Encender el led 1 de la WiiBoard
	wiimote.led = cwiid.LED1_ON

	#Activar la WiiBoard
	wiimote.rpt_mode = cwiid.RPT_BALANCE

#Rutina de inicio
def main():
    global screen
    global clock
    global SCREEN_DIMENSIONS
    
    #Inicializando todo lo relacionado con Pygame
    pygame.init()
    screen = pygame.display.set_mode( SCREEN_DIMENSIONS )
    pygame.display.set_caption("Pong_wiiboard")
    clock = pygame.time.Clock()
    initData()
    mainLoop() 

#Inicializacion de estructuras de datos
def initData():
    global paddle1
    global paddle2
    global ball
     
    paddle1 = Paddle(30, 300)
    paddle2 = Paddle(770, 300)
    ball = Ball(400, 300, 3, 3)
        

#Bucle principal
def mainLoop():
    global clock

    while True:
	renderScreen()
        readInput()
        updateState()
        clock.tick(120)


#Funcion que dibuja la pantalla
def renderScreen():
    global screen
    s = screen
    s.lock()
    s.fill(0)
    s.fill(0xffffff, Rect(ball.left(), ball.top(), ball.width, ball.height))
    s.fill(0xccccff, Rect(paddle1.left(), paddle1.top(), paddle1.width, paddle1.height))
    s.fill(0xccccff, Rect(paddle2.left(), paddle2.top(), paddle2.width, paddle2.height))
    s.unlock()
    pygame.display.update()


#Lectura de la entrada de teclado y eventos del wiiboard
def readInput():
   global paddle1
   global paddle2
   global yPrevi
   global yPrevd
    
   balance_calibration = wiimote.get_balance_cal()
   calibration = {'right_top'   : balance_calibration[0],
						   'right_bottom': balance_calibration[1],
						   'left_top'    : balance_calibration[2],
						   'left_bottom' : balance_calibration[3]   }
   view_peso = True
   #Leer los valores nomalizados de los sensores
   lt,rt,lb,rb = leer_sensores(wiimote,calibration)

   #Calcular el peso en kilos
   peso = (lt+rt+lb+rb)/100.0 

   #Se usa un umbral de peso para determinar si hay 
   #alguien subido. El peso debe ser mayor de 2Kg
   if peso>2:
   	#Calcular las posiciones x,y del centro de gravedad
        try:
             x_balance = (rt+rb) / (lt+lb)
             if x_balance > 1:
               x_balance = -1.0*(lt+lb) / (rt+rb) + 1.0
             else:
               x_balance = x_balance -1.0

             y_balance = (lb+rb) / (lt+rt)
             
             if y_balance > 1:
               y_balance = -1.0*(lt+rt)/(lb+rb) +1.0
             else:
               y_balance = y_balance -1.0
        except:
              x_balance = 1.0
              y_balance = 1.0

    #Peso menor de dos kilos: no hay nadie subido
   else:
         x_balance=0.0;
         y_balance=0.0;
  

   paddle1.dy=10*abs(y_balance)
   paddle2.dy=10*abs(y_balance)

   for event in pygame.event.get():
	if event.type == QUIT:
 	   quit()
	
   if x_balance<0:
	   paddle2.joystick.up = False
	   paddle2.joystick.down = False

	   if y_balance>0:
		paddle1.joystick.up = False
		paddle1.joystick.down = True
	   else:
		paddle1.joystick.up = True
		paddle1.joystick.down = False

	   if abs(y_balance-yPrevi)<0.0009:
		paddle1.joystick.up = False
		paddle1.joystick.down = False
   yPrevi=y_balance 

   if x_balance>0:
	   paddle1.joystick.up = False
	   paddle1.joystick.down = False

	   if y_balance>0:
		paddle2.joystick.up = False
		paddle2.joystick.down = True
	   else:
		paddle2.joystick.up = True
		paddle2.joystick.down = False
	   if abs(y_balance-yPrevd)<0.0009:
		paddle2.joystick.up = False
		paddle2.joystick.down = False
   yPrevid=y_balance  
   

#Actualizar estado del juego
def updateState():
    global paddle1
    global paddle2
    global ball
     
    if (paddle1.joystick.up):
        paddle1.moveUp()
    elif (paddle1.joystick.down):
        paddle1.moveDown()
 
    if (paddle2.joystick.up):
        paddle2.moveUp()
    elif (paddle2.joystick.down):
        paddle2.moveDown()
         
    ball.update(paddle1, paddle2)

#Leer los valores normalizados de los 4 sensores
def leer_sensores(wiimote,calibration):
  state = wiimote.state

  sensor = 'left_top'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  a = 1700 * float((valor - valor0)) / float((valor1-valor0))

  sensor = 'right_top'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  b = 1700 * float((valor - valor0)) / float((valor1-valor0))

  sensor = 'left_bottom'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  c = 1700 * float((valor - valor0)) / float((valor1-valor0))

  sensor = 'right_bottom'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  d = 1700 * float((valor - valor0)) / float((valor1-valor0))
 
  return (a,b,c,d)

#Clase joystick
class Joystick:
    up = False
    down = False

#Clase bola
class Ball:
    x = 0
    y = 0
    dx = 0
    dy = 0
    width = 10
    height = 10
 
    def __init__(self, x, y, dx, dy):
        self.x = x
        self.y = y
        self.dx = dx
        self.dy = dy
       
    def top(self):
        return self.y - self.height/2
     
    def left(self):
        return self.x - self.width/2

    def update(self, paddle1, paddle2):
        #Actualizo posicion
        self.x += self.dx
        self.y += self.dy
         
        #Deteccion de colision con las paletas
        if paddle1.collides((self.x, self.y)):
            self.dx = -self.dx
        if paddle2.collides((self.x, self.y)):
            self.dx = -self.dx
         
        #Deteccion de colision con los bordes de la ventana
        if (self.x < 0):
            self.x = 1
            self.dx = -self.dx
         
        if (self.x > SCREEN_DIMENSIONS[0]):
            self.x = SCREEN_DIMENSIONS[0]-1
            self.dx = -self.dx
         
        if (self.y < 0):
            self.y = 1
            self.dy = -self.dy
         
        if (self.y > SCREEN_DIMENSIONS[1]):
            self.y = SCREEN_DIMENSIONS[1]-1
            self.dy = -self.dy

#Clase paleta
class Paddle:
    x = 0
    y = 0

    #Velocidad vertical de la paleta
    dy = 0

    width = 10
    height = 120
    joystick = None
     
    def __init__(self, x, y):
        self.x = x
        self.y = y
        self.joystick = Joystick()
         
    def top(self):
        return self.y - self.height/2

    def bottom(self):
        return self.y + self.height/2
  
    def left(self):
        return self.x - self.width/2
     
    def right(self):
        return self.x + self.width/2
   
    def moveUp(self):
        self.y -= self.dy
        self.y = max([self.height/2, self.y])
        
    def moveDown(self):
        self.y += self.dy
        self.y = min([self.y, SCREEN_DIMENSIONS[1]-self.height/2])
   
    def collides(self, point):
        return (point[0] >= self.left() and point[0] <= self.right()) and (point[1] >= self.top() and point[1] <= self.bottom())

#Inicio del juego
main()

