#-------------------------------------------------------------------------------
#--  wii_led.py
#--  Aplicacion de seguimiento de puntero led y representacion en 2D
#-------------------------------------------------------------------------------
#-- Carlos Pastor
#-------------------------------------------------------------------------------

# Importar modulos
import sys
import cwiid
import math
import time
import decimal
import pygame
import wave
import os

# Variables
led=0;
reintentos=0;
ok=False;
blue = 0, 0, 255
black = 0, 0, 0
white = 255, 255, 255
red= 255, 0, 0
blue= 0, 0, 255

print 'Pulsa las teclas 1+2 en el Wiimote......'

#Establecer conexion con Wiimote
while reintentos<3 and not ok:
  try:
    print "Reintento ",reintentos
    if len(sys.argv) > 1:
      wiimote = cwiid.Wiimote(sys.argv[1])
    else:
      wiimote = cwiid.Wiimote()
    ok=True
  except RuntimeError, msg:
    print "Error: ",msg
    reintentos+=1;

#Si se superan los reintentos, terminar
if reintentos==3:
  print "Sin conexion con wiimote despues de "+repr(reintentos)+" reintentos"
  sys.exit(1)

#Conexion establecida
#Encender el led 1 del wiimote
wiimote.led = cwiid.LED1_ON  

#Activar acelerometros y ir
wiimote.rpt_mode = cwiid.RPT_IR 

#Configurar pygame
pygame.init()
size = width, height = 512, 384
screen = pygame.display.set_mode(size)
pygame.display.set_caption("Wii_led")

#Coordenadas para el centro del control
cox = width/2
coy = height/2

#Bucle principal
while 1:
	screen.fill(white)
  
	#Dibujar ejes y punto
        pygame.draw.aaline (screen, black, (cox-cox, coy), (cox+cox, coy),5)
        pygame.draw.aaline (screen, black, (cox, coy-coy), (cox, coy+coy),5)

	for eventos in pygame.event.get():
  		if eventos.type == pygame.QUIT :
  	  	    sys.exit(0)

	state = wiimote.state

	if 'ir_src' in state:
            for src in state['ir_src']:
                  if src:
                        posicion=src['pos']
			print posicion			
			cx=posicion[0]/2
			cy=posicion[1]/2
			pygame.draw.circle(screen, red, (cox+cox-cx,coy+coy-cy),5,0)
				
	pygame.display.flip()

