#-------------------------------------------------------------------------------
#--  Wii_motionPlus.py
#--  Representacion de las velocidades captadas por el WMP
#-------------------------------------------------------------------------------
#-- Carlos Pastor
#-------------------------------------------------------------------------------

#Importar modulos
import cwiid
import sys
import time
import pygame

#Variables
size = width, height = 768, 576
reintentos=0
ok=False
positivoP, negativoP= False,False
positivoR, negativoR= False,False
positivoY, negativoY= False,False
dP,dR,dY=0,0,0
xP,xR,xY=0,0,0
yaw,pitch,roll=0,0,0
white=255,255,255
red=255,0,0
black=0,0,0
blue=0,0,255
green=0,255,0
vel_ang=0

def comprobar_orientacion(yaw,pitch,roll):
	if yaw>8000:
		positivoY= True
		negativoY= False
	else:
		negativoY= True
		positivoY= False
	if pitch>7860:
		positivoP= True
		negativoP= False
	else:
		negativoP= True
		positivoP= False
	if roll>7980:
		positivoR= True
		negativoR= False
	else:
		negativoR= True
		positivoR= False

	return (positivoY,negativoY,positivoR,negativoR,positivoP,negativoP)

print 'Pulsa las teclas 1+2 en el Wiimote......'

#Establecer conexion con Wiimote
while reintentos<3 and not ok:
  try:
    print "Reintento ",reintentos
    if len(sys.argv) > 1:
      wiimote = cwiid.Wiimote(sys.argv[1])
    else:
      wiimote = cwiid.Wiimote()
    ok=True
  except RuntimeError, msg:
    reintentos+=1;

#Si se superan los reintentos, terminar
if reintentos==3:
  print "Sin conexion con wiimote despues de "+repr(reintentos)+" reintentos"
  sys.exit(1)

#Coordenadas para los centros del control
cox = width/2
coyP = height/6
coyR = height/2
coyY = 5*height/6

#Activar MotionPlus
wiimote.enable(cwiid.FLAG_MOTIONPLUS)
wiimote.rpt_mode = cwiid.RPT_MOTIONPLUS 

#Configurar pygame
pygame.init()
screen = pygame.display.set_mode(size)
pygame.display.set_caption("Wii_motionPlus")
font = pygame.font.Font(None, 30)

while 1:
	for eventos in pygame.event.get():
  		if eventos.type == pygame.QUIT :
  	  	    sys.exit(0)	
	
	if wiimote.state.has_key('motionplus'):
		vel_ang=wiimote.state['motionplus']['angle_rate']
		pitch=vel_ang[0]
		roll=vel_ang[1]
		yaw=vel_ang[2]
		
		xP=(pitch/100)*(width-100)/(16383/100)
		xR=(roll/100)*(width-100)/(16383/100)
		xY=(yaw/100)*(width-100)/(16825/100)

		(positivoY,negativoY,positivoR,negativoR,positivoP,negativoP)=comprobar_orientacion(yaw,pitch,roll)
		
		if positivoP==True:
			dP=-(xP-((7860/100)*(width-100)/(16383/100)))
		else:
			dP=((7860/100)*(width-100)/(16383/100))-xP
		if positivoR==True:
			dR=-(xR-((7980/100)*(width-100)/(16383/100)))
		else:
			dR=((7980/100)*(width-100)/(16383/100))-xR
		if positivoY==True:
			dY=-(xY-((8000/100)*(width-100)/(16825/100)))
		else:
			dY=((8000/100)*(width-100)/(16825/100))-xY
			
	#Borrar lo que habia antes
 	screen.fill(white)
  
  	#Dibujar elementos graficos
	text_pitch = font.render('PITCH', True, black, white)
	text_roll = font.render('ROLL', True, black, white)
	text_yaw = font.render('YAW',True,black,white)
	screen.blit(text_pitch, (50, height/6-40))
	screen.blit(text_roll, (50, height/2-40))
	screen.blit(text_yaw, (50,5*height/6-40))

        pygame.draw.aaline (screen, black, (50, height/6), (width-50, height/6),5)
        pygame.draw.aaline (screen, black, (50, height/2), (width-50, height/2),5)
	pygame.draw.aaline (screen, black, (50, 5*height/6), (width-50, 5*height/6),5)

	pygame.draw.circle(screen, black, (cox,coyP),5,0)
	pygame.draw.circle(screen, black, (cox,coyR),5,0)
	pygame.draw.circle(screen, black, (cox,coyY),5,0)

	pygame.draw.circle(screen, red, (cox+dP,coyP),6,0)
	pygame.draw.circle(screen, green, (cox+dR,coyR),6,0)
	pygame.draw.circle(screen, blue, (cox+dY,coyY),6,0)
			
	pygame.display.flip()
		
	time.sleep(0.1)

