#-------------------------------------------------------------------------------
#--  grawiity_center.py
#--  Mapeo de los movimientos sobre la tabla(centro de gravedad) en un espacio 
#--  en 2 dimensiones
#-------------------------------------------------------------------------------
#-- Carlos Pastor
#-------------------------------------------------------------------------------

#Importar modulos
import sys
import cwiid
import math
import time
import pygame

#Devolver una cadena con el estado de la bateria
def estado_bateria (state):
	bateria = state['battery']
	porcentaje = (100.0 * bateria / cwiid.BATTERY_MAX)
	return 'Battery: ' + str(int(porcentaje)) + '%'

#Leer los valores normalizados de los 4 sensores
def leer_sensores(wiimote,calibration):
  state = wiimote.state

  sensor = 'left_top'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  a = 1700 * float((valor - valor0)) / float((valor1-valor0))

  sensor = 'right_top'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  b = 1700 * float((valor - valor0)) / float((valor1-valor0))

  sensor = 'left_bottom'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  c = 1700 * float((valor - valor0)) / float((valor1-valor0))

  sensor = 'right_bottom'
  valor = state['balance'][sensor]
  valor0 = calibration[sensor][0]
  valor1 = calibration[sensor][1]
  d = 1700 * float((valor - valor0)) / float((valor1-valor0))

  return (a,b,c,d)

#Comienzo programa
reintentos=0;
ok=False;

print 'Pulsa el boton de sync de la wiiboard (donde estan las pilas)...'

while reintentos<3 and not ok:
  try:
    print "Reintento ",reintentos
    if len(sys.argv) > 1:
      wiimote = cwiid.Wiimote(sys.argv[1])
    else:
      wiimote = cwiid.Wiimote()
    ok=True
  except RuntimeError, msg:
    #print "Error: ",msg
    reintentos+=1;

#Si se superan los reintentos, terminar
if reintentos==3:
  print "Sin conexion con wiimote", reintentos
  sys.exit(-1)

#Conexion establecida 
#Encender el led de la wii-board
wiimote.led = cwiid.LED1_ON

#Activar la wii-board
wiimote.rpt_mode = cwiid.RPT_BALANCE

print "CONEXION ESTABLECIDA"

#Obtener los valores de calibracion, usados para calcular
#los valores normalizados de los sensores de presion
balance_calibration = wiimote.get_balance_cal()
calibration = {'right_top'   : balance_calibration[0],
						   'right_bottom': balance_calibration[1],
						   'left_top'    : balance_calibration[2],
						   'left_bottom' : balance_calibration[3]   }


pygame.init()
size = width, height = 800, 511
black = 0, 0, 0
white = 255,255,255
color1 = 196, 160, 15
font = pygame.font.Font(None, 25)

screen = pygame.display.set_mode(size)
pygame.display.set_caption("Grawiity_center")

#Cargamos la imagen de la wiiboard
fondo = pygame.image.load("wiiboard-top-view-1.jpg")
fondorect = fondo.get_rect()

time.sleep(0.2)

#Variable para mostrar/ocultar el peso
view_peso = True

try:
    while 1:
       #Leer los valores nomalizados de los sensores
       lt,rt,lb,rb = leer_sensores(wiimote,calibration)

       #Calcular el peso en kilos
       peso = (lt+rt+lb+rb)/100.0 

       #Se usa un umbral de peso para determinar si hay 
       #alguien subido. El peso debe ser mayor de 2Kg
       if peso>2:
           #Calcular las posiciones x,y del centro de gravedad
           try:
             x_balance = (rt+rb) / (lt+lb)
             if x_balance > 1:
               x_balance = -1.0*(lt+lb) / (rt+rb) + 1.0
             else:
               x_balance = x_balance -1.0

             y_balance = (lb+rb) / (lt+rt)
             
             if y_balance > 1:
               y_balance = -1.0*(lt+rt)/(lb+rb) +1.0
             else:
               y_balance = y_balance -1.0
           except:
              x_balance = 1.0
              y_balance = 1.0

       #Peso menor de dos kilos: no hay nadie subido
       else:
         x_balance=0.0;
         y_balance=0.0;

       #Escalar las coordenadas y establecer el criterio de signos
       xpos = 400*x_balance + 400
       ypos = 248*y_balance + 248

       #Comprobar si programa terminado
       for event in pygame.event.get():
         if event.type == pygame.QUIT: 
           wiimote.close()
           sys.exit()
         elif event.type == pygame.KEYDOWN:
           if view_peso:
             view_peso=False
           else:
             view_peso=True
           
       screen.blit(fondo, fondorect)
       text_bateria = font.render(str(estado_bateria(wiimote.state)), True, black)
       screen.blit(text_bateria, (150,485))

       if view_peso:
         text_peso = font.render("Peso: %d" % peso, True, black)
         screen.blit(text_peso, (500,485))

       #Estado sensores de peso
       text_lt = font.render("%d" % (lt/100),True,color1)
       screen.blit(text_lt, (160,140))

       text_lb = font.render("%d" % (lb/100),True,color1)
       screen.blit(text_lb, (160,350))

       text_rt = font.render("%d" % (rt/100),True,color1)
       screen.blit(text_rt, (640,140))

       text_rb = font.render("%d" % (rb/100),True,color1)
       screen.blit(text_rb, (640,350))

       #Circulo para indicar la posicion del centro de gravedad
       pygame.draw.circle(screen, (255,0,0), (int(xpos), int(ypos)), 10)
       pygame.display.flip()

#Terminar con Control-C
except KeyboardInterrupt:
  wiimote.close()
  print
  print "-- FIN --"

