/*************************************************************************** */
/* sin.c  (c) Juan Gonzalez. Abril 2009                                      */
/* Implementacion de la funcion sin() mediante tablas                        */
/* Esta funcion es necesaria si se usan las versiones 2.8.0 y 2.9.0 del SDCC */
/* ya que debido a un bug los flotantes negativos no funcionan correctamente */
/* y por tanto la libreria matematica tampoco.                               */
/*                                                                           */
/* A partir de la revision r5431 este error esta solucionado y se puede      */
/* usar directamente la funcion sinf() de la libreria matematica             */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f876a.h>
#include <float.h>
#include <math.h>

//-- Tabla con los valores del seno para cada angulo entre 0 y 90 grados
__code static float tabla[]={
0.0,
0.017452, 0.034899, 0.052336, 0.069756, 0.087156, 0.10453, 0.12187, 0.13917, 0.15643, 0.17365, //- 01 - 10
0.19081,  0.20791,  0.22495,  0.24192,  0.25882,  0.27564, 0.29237, 0.30902, 0.32557, 0.34202, //- 11 - 20
0.35837,  0.37461,  0.39073,  0.40674,  0.42262,  0.43837, 0.45399, 0.46947, 0.48481, 0.50000, //- 21 - 30
0.51504,  0.52992,  0.54464,  0.55919,  0.57358,  0.58779, 0.60182, 0.61566, 0.62932, 0.64279, //- 31 - 40
0.65606,  0.66913,  0.68200,  0.69466,  0.70711,  0.71934, 0.73135, 0.74314, 0.75471, 0.76604, //- 41 - 50
0.77715,  0.78801,  0.79864,  0.80902,  0.81915,  0.82904, 0.83867, 0.84805, 0.85717, 0.86603, //- 51 - 60
0.87462,  0.88295,  0.89101,  0.89879,  0.90631,  0.91355, 0.92050, 0.92718, 0.93358, 0.93969, //- 61 - 70
0.94552,  0.95106,  0.95630,  0.96126,  0.96593,  0.97030, 0.97437, 0.97815, 0.98163, 0.98481, //- 71 - 80
0.98769,  0.99027,  0.99255,  0.99452,  0.99619,  0.99756, 0.99863, 0.99939, 0.99985, 1.00000, //- 81 - 90
};


/*************************************************************************/
/* Esta funcion calcula  A*sin(x), redondeado a un numero entero         */
/* ENTRADAS:                                                             */
/*   -A: Amplitud en grados (entre 0 y 90)                               */
/*   -x: Fase. Entre 0 y 360 grados. Tambien validas fases negativas     */
/*************************************************************************/
int sin(int A, int x)
{
  volatile int result;
  int signo1=1;
  int signo;


 //-- Si fase negativa, tomarla positiva, pero indicar que es negativa
 //-- haciendo que signo=-1. Con esto se implementa la imparidad del seno
 if (x>=0) signo=1;
 else {
    signo=-1;
    x=-x;
 }

  //-- Dejar la fase en el rango 0-360
  x = x % 360; 

  //-- Obtener la fase equivalente en el primer cuadrante
  //-- Calcular el signo adecuado

  //-- Segundo cuadrante
  if (x>90 && x<=180) {
    x = 180-x;
  }

  //-- Tercer cuadrante
  if (x>180 && x<=270) {
    x = x - 180;
    signo1=-1;
  }

  //-- Cuarto cuadrante
  if (x>270 && x<=360) {
    x = 360 -x;
    signo1=-1;
  }

  //-- Calcular el resultado
  result = (int) (A*tabla[x]);

  //-- Devolver el resultado, con el signo correcto
  return signo*signo1*result;
}

