/*****************************************************************************/
/* test-PP2.c  Enero-2010                                                    */
/*---------------------------------------------------------------------------*/
/* Ejemplo de movimiento de la configuracion PP                              */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Andres Prieto-Moreno <andres@iearobotics.com>                            */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f877.h>
#include "servos.h"
#include "oscillator-pn.h"

#define PULSADOR RA0  //-- Skycube 

//-- Constantes para determinar si pulsador esta apretado o no
#define ON       0
#define OFF      1

/***********************************************************************/
/*  PARAMETROS DE LAS OSCILACIONES. MODIFICABLES POR EL USUARIO        */
/***********************************************************************/
//-- Mas documentacion en el rfichero oscillator-pn.h

//-- Diferencia de fase (en grados) (-180 a 180)
#define DF -120

//--Fase inicial de los servos (en grados) (0-360)
#define FASE0 0

//-- Correspondencia entre servos virtuales y reales
//-- Cambiarlo segun el conexionado del robot y el numero de modulos usados
//-- El '0' inicial se ignora
//-- Servos virtuales:            1  2  3  4  5  6  7  8
//-- '0' significa NO-USADO
unsigned char v[9]={0,            2, 4, 6, 8, 0, 0, 0, 0};

int Av=40;
int inc = 4;
int df = 120;

/*******************************************************/
/* RUTINA DE ATENCION A LAS INTERRUPCIONES             */
/*******************************************************/
void intr(void) interrupt 0
{
  //---------------------------------------------------------------
  //-- Rutina de servicio del timer0 para actualizar las senales
  //-- de PWM
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();
}


//----------------------------
//- Comienzo del programa  
//----------------------------
void main(void)
{
  //-- Inicializacion del modulo de servos
  servos_init();

  //-- Inicializar los osciladores
  oscillator_init(Av,df,0);
    
  //-- Habilitar Interrupciones
  GIE=1;

  //-- Configurar skypads
  ADCON1=0x06;   //-- Configurar RA0 como entrada digital
  TRISA = 0xFF;  //-- RA0-RA6 como entradas
 

  //----------------------
  //-- Bucle principal
  //----------------------
  while (1) {

    //-- Refrescar osciladores
    oscillator_calculate(inc);

    //-- Comprobar si hay una tecla pulsada
    if ((PORTA&0x3F)!=0x3F) {

      //-- Actualizar parametros segun boton pulsado
      if (RA0==ON)
        Av=(Av+10)%90;
      else if (RA1==ON) {
        Av=(Av-10)%90;
      }
      else if (RA2==ON) {
        inc = (inc + 1)%10;
        if (inc==0) inc=10;
      }
      else if (RA3==ON) {
        inc = (inc - 1)%10;
        if (inc==0) inc=10;
      }
      else if (RA4==ON) {
        df = (df + 10);
        if (df>180) df=0;
      }
      else if (RA5==ON) {
        df = (df - 10);
        if (df<0) df=180;
      }

      //-- Recalcular osciladores para el nuevo movimiento
      oscillator_init(Av,df,1);

      //-- Esperar hasta que el boton se suelte
      while((PORTA&0x3F)!=0x3F);
    }

  } 
}

