/*****************************************************************************/
/* test-PP2.c  Enero-2010                                                    */
/*---------------------------------------------------------------------------*/
/* Ejemplo de movimiento de la configuracion PP                              */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Andres Prieto-Moreno <andres@iearobotics.com>                            */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f877.h>
#include "servos.h"
#include "oscillator-pn.h"

#define PULSADOR RA0  //-- Skycube 

//-- Constantes para determinar si pulsador esta apretado o no
#define ON       0
#define OFF      1

/***********************************************************************/
/*  PARAMETROS DE LAS OSCILACIONES. MODIFICABLES POR EL USUARIO        */
/***********************************************************************/
//-- Mas documentacion en el rfichero oscillator-pn.h

//-- Diferencia de fase (en grados) (-180 a 180)
#define DF -120

//--Fase inicial de los servos (en grados) (0-360)
#define FASE0 0

//-- Correspondencia entre servos virtuales y reales
//-- Cambiarlo segun el conexionado del robot y el numero de modulos usados
//-- El '0' inicial se ignora
//-- Servos virtuales:            1  2  3  4  5  6  7  8
//-- '0' significa NO-USADO
unsigned char v[9]={0,            2, 4, 6, 8, 0, 0, 0, 0};

int Av=60;
int inc = 8;
int df = -120;

/*******************************************************/
/* RUTINA DE ATENCION A LAS INTERRUPCIONES             */
/*******************************************************/
void intr(void) interrupt 0
{
  //---------------------------------------------------------------
  //-- Rutina de servicio del timer0 para actualizar las senales
  //-- de PWM
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();
}


//----------------------------
//- Comienzo del programa  
//----------------------------
void main(void)
{
  //-- Inicializacion del modulo de servos
  servos_init();

  //-- Inicializar los osciladores
  oscillator_init(Av,df,0);
    
  //-- Habilitar Interrupciones
  GIE=1;

  //-- Configurar skypads
  ADCON1=0x06;   //-- Configurar RA0 como entrada digital
  TRISA0 = 1;  
 

  //----------------------
  //-- Bucle principal
  //----------------------
  while (1) {

    //-- Refrescar osciladores
    oscillator_calculate(inc);

  } 
}

