/*************************************************************************** */
/* Juan gonzalez                                                             */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

/***********************************************************************/
/*  PARAMETROS DE LAS OSCILACIONES. DOCUMENTACION                      */
/***********************************************************************/

//-- INC: Velocidad de fase (en grados) (1-180)
//-- Este parametro permite cambiar la frecuencia de oscilacion, asi como
//-- el sentido. Es un numero entero
//-- Valores negativos hacen que oscile en sentido contrario
//-- El periodo de oscilacion se calcula con la formula:
//--  T=360/W, con W expresado en grados/seg. Para los servos futaba,
//-- la velocidad angular es aproximadamente de 260 grados/seg, por lo que
//-- la formula queda:
//--
//--  T=7.2/INC
//--
//--  Tabla de valores de T en funcion de INC:
//--
//--      INC      T (seg)   f(Hz)
//--    -----------------------------
//--       0       no oscila   0
//--       1       7.2         0.14
//--       2       3.7         0.28
//--       3       2,4         0.42
//--       4       1.8         0.55
//--       5       1.4         0.71
//--       6       1.2         0.83
//--       7       1.03        0.97
//--       8       0.9         1.11
//--       9       0.8         1.25
//--      10       0.72        1.39
//--      ..       ...         ...


//-- A: Amplitud de la oscilacion (en grados) (0-90)

//-- DF: Diferencia de fase entre dos sevos virtuales consecutivos
//--     Expresada en grados (-180 a 180)

//-- FASE0: Fase inicial de los osciladoresservos (en grados) (0-360)

/***************************************/
/* CONCEPTOS DE SERVO VIRTUAL Y REAL   */
/***************************************/
//-- Servo real: Son los que se conectan directamente a la Skycube/skypic
//-- Su numeracion es la indicada en la serigrafia. Van desde el 1 (RB0) hasta
//-- el 8 (RB7)

//-- Servo virtual: Tienen una numeracion normalizada para los robots. 
//--   comienzan desde el 1 (cola) hasta el 8 (cabeza), consecutivamente.

//-- Esta distincion entre servos reales/virtuales permite que el software se
//-- independice del conexionado de los robots. Solo es necesario establecer
//-- la correspondencia entre servos virtuales y reales. Una vez hecho, el 
//-- software es el mismo para todos los robots con conexionados diferentes

//-- Ejemplo : Tenemos dos configuraciones PP. Una con los dos servos 
// conectados a los pines 3 y 4. Y la otra con ellos conectos a los pines 2 y 8
//-- En ambos casos, los servos vituales son dos: el uno y el dos. El "mapeo"
//-- se haria de la siguiente forma:
//-- Configuracion 1:   v[9]={0,    3, 4, 0, 0, 0, 0, 0, 0}
//-- Configuracion 2:   v[9]={0,    2, 8, 0, 0, 0, 0, 0, 0}
//-- En ambos casos, los indices de los servos reales son v[1] y v[2]


#ifndef OSCILLATOR_PN_H
#define OSCILLATOR_PN_H

void oscillator_calculate(int inc);
void oscillator_pyn_init(int Av, int Ah, int dfv, int dfh, int dfvh, 
                         int fase0, char oh);

#endif

