/*****************************************************************************/
/* test-PYP1.c  Enero-2010                                                   */
/*---------------------------------------------------------------------------*/
/* Pruebas de movimiento de PYP. Con el pulsador de la Skycube, o con una    */
/* una Skypads conectada a una skypic, se cambia al siguiente movimiento     */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Andres Prieto-Moreno <andres@iearobotics.com>                            */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f877.h>
#include "servos.h"
#include "oscillator-pyn.h"

//-- Indicar la tarjeta usada: Skycube o Skypic
//-- Si la siguiente linea se comenta, se supondra una Skypic
//-- La configuracion SKYCUBE tambien es valida para una skypic on una
//-- tarjeta Skypads conectada al puerto A
#define SKYCUBE

//-- Definir el bit del pulsador de pruebas, segun la tarjeta usada
#ifdef SKYCUBE
  #define PULSADOR RA0  //-- Skycube 
#else
  #define PULSADOR RB0  //-- Skypic
#endif

//-- Constantes para determinar si pulsador esta apretado o no
#define ON       0
#define OFF      1



/***********************************************************************/
/*  PARAMETROS DE LAS OSCILACIONES. MODIFICABLES POR EL USUARIO        */
/***********************************************************************/
//-- Mas documentacion en el fichero oscillator-pyn.h

//-- Velocidad de fase
#define INC 4

//--Fase inicial de los servos (en grados) (0-360)
#define FASE0 0

//-- Correspondencia entre servos virtuales y reales
//-- Cambiarlo segun el conexionado del robot y el numero de modulos usados
//-- El '0' inicial se ignora
//-- Servos virtuales:            1  2  3  4  5  6  7  8
//-- '0' significa NO-USADO
//-- Conexionado para Hypercube
__code unsigned char v[9]={0,            2, 8, 6, 0, 0, 0, 0, 0};

//-- Amplitudes para los diferentes estados:
//-- STOP, ADELANTE, ATRAS, ARCO-AD, ARCO-AT, LAT1, LAT2, ROT1, ROT2, ROLL1  
__code int Av[]  = {0,   45,  45,    45,    45, 30,   30,  45,  45,  0,    80};
__code int Ah[]  = {0,    0,   0,    0,      0, 30,   30,  45,  45,  0,    80};
__code int Oh[]  = {0,    0,   0,    45,    45,  0,    0,   0,   0,  70,    0};
__code int DFv[] = {0, -125, -125, -125,  -125,  0,    0,  180, 180,  0,    0};
__code int DFvh[]= {0,    0,    0,    0,     0, 90,   90,   90,  90,  0,   90};
__code int inc[] = {0,  INC, -INC,  INC,  -INC, INC,-INC,  INC,-INC,  0,    1};

/*******************************************************/
/* RUTINA DE ATENCION A LAS INTERRUPCIONES             */
/*******************************************************/
void intr(void) interrupt 0
{
  //---------------------------------------------------------------
  //-- Rutina de servicio del timer0 para actualizar las senales
  //-- de PWM
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();
}


//----------------------------
//- Comienzo del programa  
//----------------------------
void main(void)
{
  unsigned char m=0;
  unsigned char TAM=sizeof(Av)/sizeof(int);  //-- Numero de movimientos diferentes
    
  //-- Inicializacion del modulo de servos
  servos_init();

  //-- Inicializar los osciladores
  oscillator_pyn_init(Av[m],Ah[m],DFv[m],0,DFvh[m],FASE0,Oh[m]);

  //-- Habilitar Interrupciones
  GIE=1;

  //-- Configurar el pulsador usado. Segun la tarjeta se hara una cosa u otra
  #ifdef SKYCUBE
    ADCON1=0x06; //-- Configurar RA0 como entrada digital
    TRISA0 = 1;  //-- RA0 como entrada
  #else
    TRISB0=1;  //-- RB0 como entrada
  #endif

  //----------------------
  //-- Bucle principal
  //----------------------
  while (1) {

    //-- Refrescar osciladores
    oscillator_calculate(inc[m]);

    //-- Si el pulsador esta apretado, cambiar el incremento de fase
    if (PULSADOR==ON) {

      //-- Siguiente movimiento
      m = (m+1) % TAM;

      //-- Recalcular osciladores para el nuevo movimiento
      oscillator_pyn_init(Av[m],Ah[m],DFv[m],0,DFvh[m],FASE0,Oh[m]);
        
      //-- Esperar hasta que el boton se suelte
      while(PULSADOR==ON);
    }
        
  } 
    
}

