/*****************************************************************************/
/* test-PP2.c  Enero-2010                                                    */
/*---------------------------------------------------------------------------*/
/* Ejemplo de movimiento de la configuracion PP                              */
/*---------------------------------------------------------------------------*/
/*  Juan Gonzalez <juan@iearobotics.com>                                     */
/*  Andres Prieto-Moreno <andres@iearobotics.com>                            */
/*---------------------------------------------------------------------------*/
/*  LICENCIA GPL                                                             */
/*****************************************************************************/

//-- Especificar el pic a emplear
#include <pic16f877.h>
#include "servos.h"
#include "oscillator-pn.h"

//-- Indicar la tarjeta usada: Skycube o Skypic
//-- Si la siguiente linea se comenta, se supondra una Skypic
//-- La configuracion SKYCUBE tambien es valida para una skypic on una
//-- tarjeta Skypads conectada al puerto A
#define SKYCUBE

//-- Definir el bit del pulsador de pruebas, segun la tarjeta usada
#ifdef SKYCUBE
  #define PULSADOR RA0  //-- Skycube 
#else
  #define PULSADOR RB0  //-- Skypic
#endif

//-- Constantes para determinar si pulsador esta apretado o no
#define ON       0
#define OFF      1

/***********************************************************************/
/*  PARAMETROS DE LAS OSCILACIONES. MODIFICABLES POR EL USUARIO        */
/***********************************************************************/
//-- Mas documentacion en el rfichero oscillator-pn.h

//-- Diferencia de fase (en grados) (-180 a 180)
#define DF -120

//--Fase inicial de los servos (en grados) (0-360)
#define FASE0 0

//-- Correspondencia entre servos virtuales y reales
//-- Cambiarlo segun el conexionado del robot y el numero de modulos usados
//-- El '0' inicial se ignora
//-- Servos virtuales:            1  2  3  4  5  6  7  8
//-- '0' significa NO-USADO
unsigned char v[9]={0,            4, 6, 0, 0, 0, 0, 0, 0};

__code int Av[]  = {30,    30,  30,  60,  20,0,45, 45, 45, 0};
__code int inc[] = {4,      8,   4,   4,   4,0, 4,  4, 4,  0};
__code int df[]  = {-120,-120,-120,-120,-120,0, 0,180,-120,0};
/*******************************************************/
/* RUTINA DE ATENCION A LAS INTERRUPCIONES             */
/*******************************************************/
void intr(void) interrupt 0
{
  //---------------------------------------------------------------
  //-- Rutina de servicio del timer0 para actualizar las senales
  //-- de PWM
  //-----------------------------------------------------------
  if (T0IF==1)
    servos_intr();
}


//----------------------------
//- Comienzo del programa  
//----------------------------
void main(void)
{
  unsigned char m=0;
  unsigned char TAM=sizeof(Av)/sizeof(int);  

  //-- Inicializacion del modulo de servos
  servos_init();

  //-- Inicializar los osciladores
  oscillator_init(Av[m],df[m],FASE0);
    
  //-- Habilitar Interrupciones
  GIE=1;

  //-- Configurar el pulsador usado. Segun la tarjeta se hara una cosa u otra
  #ifdef SKYCUBE
    ADCON1=0x06; //-- Configurar RA0 como entrada digital
    TRISA0 = 1;  //-- RA0 como entrada
  #else
    TRISB0=1;  //-- RB0 como entrada
  #endif

  //----------------------
  //-- Bucle principal
  //----------------------
  while (1) {

    //-- Refrescar osciladores
    oscillator_calculate(inc[m]);

    //-- Si el pulsador esta apretado, cambiar el incremento de fase
    if (PULSADOR==ON) {
        //-- Siguiente movimiento
        m = (m+1) % TAM;

        //-- Recalcular osciladores para el nuevo movimiento
        oscillator_init(Av[m],df[m],FASE0);

      //-- Esperar hasta que el boton se suelte
      while(PULSADOR==ON);
    }
  } 
}

