//---------------------------------------------------------
// Repy1 Modules. Version 1.1                          
// FE PART                                           
//---------------------------------------------------------
//  (c) Juan Gonzalez-Gomez (Obijuan) 2011   
//  GPL license                                                        
//----------------------------------------------------------


//----------------------------------------
//-- REPY1 F PART
//-- Parameters:
// thickness. Typicall: 3
// metrics: Drills diameter. Typicall: 3
// countersink. Typicall: 6
//----------------------------------------

//-- Helper function for reading parameters from the DXF FE part file
function FE_get_parameter(name) = dxf_dim(file="part-FE.dxf", name=name);

module part_FE(thickness=3,metrics=3,countersink=0) {

   //-- Get the parameters from the DXF file
   yd = FE_get_parameter("yd");

   //-- Build the part
   difference() {
     linear_extrude(height=thickness)
       import(file="part-FE.dxf", layer="exterior");

     //-- Drill
     translate([0,yd,0]) cylinder(r=metrics/2, h=thickness+10, $fn=16, center=true);    

     //-- Countersink
     translate([0,yd,-thickness/2+1]) cylinder(r=countersink/2, h=thickness, $fn=16,center=true);
  }
}
  

//-- Testing the FE part
part_FE(thickness=3,metrics=3,countersink=6);



