//---------------------------------------------------------
// Repy1 Modules. Version 1.1                          
// F PART                                           
//---------------------------------------------------------
//  (c) Juan Gonzalez-Gomez (Obijuan) 2011   
//  GPL license                                                        
//----------------------------------------------------------

//----------------------------------------
//-- REPY1 F PART
//-- Parameters:
// thickness. Typicall: 3
// metrics: Drills diameter. Typicall: 3
//----------------------------------------
module part_F(thickness=3,metrics=3) 
{
  //-- Get the parameters from the DXF file
  xd1 = dxf_dim(file = "part-F.dxf", name = "xd1");
  yd1 = dxf_dim(file = "part-F.dxf", name= "yd1");
  xd2 = dxf_dim(file = "part-F.dxf", name = "xd2");
  yd2 = dxf_dim(file = "part-F.dxf", name= "yd2");
  xd3 = dxf_dim(file = "part-F.dxf", name = "xd3");
  yd3 = dxf_dim(file = "part-F.dxf", name= "yd3");
  xd4 = dxf_dim(file = "part-F.dxf", name = "xd4");
  yd4 = dxf_dim(file = "part-F.dxf", name= "yd4");

  //-- Build the part
  difference() {
     //-- Main part: extrude the exterior
     linear_extrude(height=thickness)
       import(file="part-F.dxf", layer="exterior");

     //-- Drills!!
     translate ([-xd1,yd1,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([-xd2,yd2,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([xd3,-yd3,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([xd4,-yd4,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
  }
}
  
//-- Testing the F part
part_F(thickness=3,metrics=3);



