//---------------------------------------------------------
// Repy1 Modules. Version 1.1                          
// E PART                                           
//---------------------------------------------------------
//  (c) Juan Gonzalez-Gomez (Obijuan) 2011   
//  GPL license                                                        
//----------------------------------------------------------

//-- Helper function for reading parameters from the DXF E part file
function E_get_parameter(name) = dxf_dim(file="part-E.dxf", name=name);

//----------------------------------------
//-- REPY1 E PART
//-- Parameters:
// thickness. Typicall: 3
// metrics: Drills diameter. Typicall: 3
//----------------------------------------
module part_E(thickness=3)
{

   //-- Get the parameters from the DXF file
   yd1 = E_get_parameter("yd1");
   yd2 = E_get_parameter("yd2");
   yd3 = E_get_parameter("yd3");
   ds = E_get_parameter("ds");

   //-- Build the part
   difference() {

     //-- Main part: extrude the exterior
     linear_extrude(height=thickness)
       import(file="part-E.dxf", layer="exterior");

     //-- Drill
     translate([0,yd2,0]) cylinder(r=ds/2, h=thickness+10, $fn=16, center=true);    
  }
}
  

//-- Testing the E part
part_E(thickness=3);


