//---------------------------------------------------------
// Repy1 Modules. Version 1.1                          
// B2 PART                                           
//---------------------------------------------------------
//  (c) Juan Gonzalez-Gomez (Obijuan) 2011   
//  GPL license                                                        
//----------------------------------------------------------

//-- Help function for reading parameters from the DXF B2 part file
function B2_get_parameter(name) = dxf_dim(file="part-B2.dxf", name=name);

//----------------------------------------
//-- REPY1 B2 PART
//-- Parameters:
// thickness. Typicall: 3
// metrics: Drills diameter. Typicall: 3
//----------------------------------------
module part_B2(thickness=3,metrics=3)
{
  //-- Get the parameters from the DXF file
  xd = B2_get_parameter("xd");
  yd = B2_get_parameter("yd");

  //-- Build the part
  difference() {

     //-- Main part: extrude the exterior
     linear_extrude(height=thickness)
       import(file="part-B2.dxf", layer="exterior");

     //-- Eliminate the interior part
     linear_extrude(height=thickness+10, center=true)
       import(file="part-B2.dxf", layer="interior");
 
     //-- Drills
     translate ([xd,yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([-xd,yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([-xd,-yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([xd,-yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
  }  
}


//-- Testing the B2 part
part_B2(thickness=3, metrics=3);



