//---------------------------------------------------------
// Repy1 Modules. Version 1.1                          
// B1 PART                                           
//---------------------------------------------------------
//  (c) Juan Gonzalez-Gomez (Obijuan) 2011   
//  GPL license                                                        
//----------------------------------------------------------

//----------------------------------------
//-- REPY1 B1 PART
//-- Parameters:
// thickness. Typicall: 3
// metrics: Drills diameter. Typicall: 3
//----------------------------------------

//-- Help function for reading parameters from the DXF B1 part file
function B1_get_parameter(name) = dxf_dim(file="part-B1.dxf", name=name);


module part_B1(thickness=3,metrics=3) 
{

  //-- Get the parameters from the DXF file
  xd = B1_get_parameter("xd");
  yd = B1_get_parameter("yd");

  //-- Build the part
  difference() {
     //-- Main part: extrude the exterior
     linear_extrude(height=thickness)
       import(file="part-B1.dxf", layer="exterior");

     //-- Eliminate the interior part
     linear_extrude(height=thickness+10, center=true)
       import(file="part-B1.dxf", layer="interior");

     //-- Drills!!
     translate ([xd,yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([-xd,yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([-xd,-yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
     translate ([xd,-yd,0]) cylinder(h=thickness+10, r=metrics/2, center=true, $fn=16);
  }
  
}

//-- Testing the B1 part
part_B1(thickness=3,metrics=3);



